/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.build;

import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilderContext;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public class DefaultLayoutModelBuilderContext
implements LayoutModelBuilderContext,
Cloneable {
    private LayoutModelBuilderContext parent;
    private RenderBox renderBox;
    private boolean empty;
    private boolean commited;
    private boolean keepWrapperBoxAlive;
    private boolean autoGeneratedWrapperBox;

    public DefaultLayoutModelBuilderContext(LayoutModelBuilderContext parent, RenderBox renderBox) {
        if (renderBox == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.renderBox = renderBox;
        this.empty = true;
        if (renderBox.getNodeType() == 524290) {
            this.commitAsEmpty();
        }
    }

    @Override
    public RenderBox getRenderBox() {
        return this.renderBox;
    }

    @Override
    public LayoutModelBuilderContext getParent() {
        return this.parent;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public boolean mergeSection(ReportStateKey stateKey) {
        return false;
    }

    @Override
    public void setEmpty(boolean empty) {
        if (empty && !this.empty) {
            throw new IllegalStateException();
        }
        this.empty = empty;
        if (!empty && this.parent != null && this.renderBox.getParent() == null) {
            if (!this.commited) {
                this.parent.addChild(this.renderBox);
                this.commited = true;
            }
            this.parent.setEmpty(false);
        }
    }

    @Override
    public void commitAsEmpty() {
        if (!this.empty) {
            return;
        }
        if (this.parent != null && this.renderBox.getParent() == null && !this.commited) {
            this.parent.addChild(this.renderBox);
            this.commited = true;
        }
    }

    @Override
    public boolean isKeepWrapperBoxAlive() {
        return this.keepWrapperBoxAlive;
    }

    @Override
    public void setKeepWrapperBoxAlive(boolean keepWrapperBoxAlive) {
        this.keepWrapperBoxAlive = keepWrapperBoxAlive;
    }

    @Override
    public boolean isAutoGeneratedWrapperBox() {
        return this.autoGeneratedWrapperBox;
    }

    @Override
    public void setAutoGeneratedWrapperBox(boolean autoGeneratedWrapperBox) {
        this.autoGeneratedWrapperBox = autoGeneratedWrapperBox;
    }

    @Override
    public LayoutModelBuilderContext close() {
        this.renderBox.close();
        if (!this.isEmpty()) {
            if (this.renderBox.getParent() == null) {
                throw new InvalidReportStateException();
            }
        } else if (this.renderBox.getNodeType() == 524290) {
            RenderBox parentRenderBox = this.renderBox.getParent();
            if (parentRenderBox == null) {
                throw new InvalidReportStateException();
            }
            parentRenderBox.remove(this.renderBox);
        }
        return this.parent;
    }

    @Override
    public void addChild(RenderBox child) {
        this.renderBox.addChild(child);
    }

    @Override
    public void removeChild(RenderBox child) {
        this.renderBox.remove(child);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public LayoutModelBuilderContext deriveForPagebreak() {
        DefaultLayoutModelBuilderContext clone = (DefaultLayoutModelBuilderContext)this.clone();
        if (this.parent != null) {
            clone.parent = this.parent.deriveForPagebreak();
        }
        return clone;
    }

    @Override
    public LayoutModelBuilderContext deriveForStorage(RenderBox clonedRoot) {
        if (clonedRoot == null) {
            throw new NullPointerException();
        }
        DefaultLayoutModelBuilderContext clone = (DefaultLayoutModelBuilderContext)this.clone();
        if (this.parent == null) {
            clone.renderBox = clonedRoot;
        } else {
            clone.parent = this.parent.deriveForStorage(clonedRoot);
            if (this.isEmpty()) {
                clone.renderBox = (RenderBox)this.renderBox.derive(true);
            } else {
                clone.renderBox = (RenderBox)clone.parent.getRenderBox().findNodeById(this.renderBox.getInstanceId());
                if (clone.renderBox == null) {
                    throw new IllegalStateException();
                }
            }
        }
        return clone;
    }

    @Override
    public void validateAfterCommit() {
    }

    @Override
    public void performParanoidModelCheck() {
    }

    @Override
    public void restoreStateAfterRollback() {
    }

    @Override
    public int getDepth() {
        if (this.parent == null) {
            return 1;
        }
        return 1 + this.parent.getDepth();
    }
}

