/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime;

import java.util.Date;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactoryDesignTimeSupport;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.cache.CachingDataFactory;
import org.pentaho.reporting.engine.classic.core.cache.IndexedTableModel;
import org.pentaho.reporting.engine.classic.core.designtime.AbstractDesignTimeDataSchemaModel;
import org.pentaho.reporting.engine.classic.core.designtime.DefaultDesignTimeDataSchemaModelChangeTracker;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeDataSchemaModelChangeTracker;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.core.designtime.OfflineTableModel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DesignTimeDataFactoryContext;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.sorting.SortConstraint;
import org.pentaho.reporting.engine.classic.core.sorting.SortOrderReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.sorting.SortingDataFactory;
import org.pentaho.reporting.engine.classic.core.states.NoOpPerformanceMonitorContext;
import org.pentaho.reporting.engine.classic.core.states.QueryDataRowWrapper;
import org.pentaho.reporting.engine.classic.core.states.datarow.EmptyTableModel;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaCompiler;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataSchema;
import org.pentaho.reporting.libraries.base.util.LinkedMap;

public class DesignTimeDataSchemaModel
extends AbstractDesignTimeDataSchemaModel {
    private static final Log logger = LogFactory.getLog(DesignTimeDataSchemaModel.class);
    private DataSchema dataSchema;
    private OfflineTableModel offlineTableModel;
    private Throwable dataFactoryException;
    private final DesignTimeDataSchemaModelChangeTracker changeTracker = this.createChangeTracker();

    public DesignTimeDataSchemaModel(AbstractReportDefinition report) {
        this((MasterReport)report.getMasterReport(), report);
    }

    public DesignTimeDataSchemaModel(MasterReport masterReportElement, AbstractReportDefinition report) {
        super(masterReportElement, report);
    }

    protected DesignTimeDataSchemaModelChangeTracker createChangeTracker() {
        return new DefaultDesignTimeDataSchemaModelChangeTracker(this.getParent());
    }

    public AbstractReportDefinition getParent() {
        return this.getReport();
    }

    @Override
    public boolean isValid() {
        this.ensureDataSchemaValid();
        return this.dataFactoryException == null;
    }

    @Override
    public DataSchema getDataSchema() {
        this.ensureDataSchemaValid();
        return this.dataSchema;
    }

    private void ensureDataSchemaValid() {
        if (this.dataSchema == null || this.changeTracker.isReportChanged()) {
            try {
                this.dataFactoryException = null;
                this.dataSchema = this.buildDataSchema();
            }
            catch (Throwable e) {
                this.handleError(e);
                this.dataFactoryException = e;
                this.dataSchema = new DefaultDataSchema();
            }
            this.changeTracker.updateChangeTrackers();
        }
    }

    protected void handleError(Throwable e) {
        logger.debug((Object)"Failure in DataSchema", e);
    }

    @Override
    public Throwable getDataFactoryException() {
        return this.dataFactoryException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSchema buildDataSchema() throws ReportDataFactoryException {
        this.dataFactoryException = null;
        AbstractReportDefinition parent = this.getReport();
        ParameterDataRow parameterRow = this.computeParameterData();
        ParameterDefinitionEntry[] parameterDefinitions = this.computeParameterDefinitionEntries();
        Expression[] expressions = parent.getExpressions().getExpressions();
        DataSchemaCompiler dataSchemaCompiler = new DataSchemaCompiler(this.getDataSchemaDefinition(), this.getDataAttributeContext(), this.getMasterReportElement().getResourceManager());
        CachingDataFactory dataFactory = new CachingDataFactory(new SortingDataFactory(this.createDataFactory(parent), new NoOpPerformanceMonitorContext()), true);
        MasterReport masterReport = this.getMasterReportElement();
        dataFactory.initialize(new DesignTimeDataFactoryContext(masterReport));
        try {
            List<SortConstraint> sortConstraints = new SortOrderReportPreProcessor().computeSortConstraints(parent);
            TableModel reportData = this.queryReportData(parent.getQuery(), parent.getQueryTimeout(), dataFactory, sortConstraints);
            DataSchema dataSchema = dataSchemaCompiler.compile(reportData, expressions, parameterRow, parameterDefinitions, masterReport.getReportEnvironment());
            if (reportData instanceof CloseableTableModel) {
                CloseableTableModel ctm = (CloseableTableModel)reportData;
                ctm.close();
            }
            DataSchema dataSchema2 = dataSchema;
            dataFactory.close();
            return dataSchema2;
        }
        catch (Throwable throwable) {
            try {
                dataFactory.close();
                throw throwable;
            }
            catch (ReportProcessingException e) {
                DefaultTableModel reportData = new DefaultTableModel();
                DataSchema dataSchema = dataSchemaCompiler.compile(reportData, expressions, parameterRow, parameterDefinitions, this.getMasterReportElement().getReportEnvironment());
                this.dataFactoryException = e;
                return dataSchema;
            }
        }
    }

    private CompoundDataFactory createDataFactory(AbstractReportDefinition reportDefinition) throws ReportDataFactoryException {
        CompoundDataFactory cdf = new CompoundDataFactory();
        while (reportDefinition != null) {
            Section parentSection;
            DataFactory dataFactory = reportDefinition.getDataFactory();
            if (dataFactory != null) {
                cdf.add(dataFactory);
            }
            if ((parentSection = reportDefinition.getParentSection()) == null) {
                reportDefinition = null;
                continue;
            }
            reportDefinition = (AbstractReportDefinition)parentSection.getReportDefinition();
        }
        return CompoundDataFactory.normalize(cdf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableModel queryReportData(String query, int queryTimeout, DataFactory dataFactory, List<SortConstraint> sortConstraints) throws ReportDataFactoryException {
        if (this.offlineTableModel == null || this.changeTracker.isReportQueryChanged()) {
            TableModel reportData = null;
            try {
                if (query == null) {
                    reportData = new EmptyTableModel();
                } else if (dataFactory instanceof DataFactoryDesignTimeSupport) {
                    DataFactoryDesignTimeSupport dts = (DataFactoryDesignTimeSupport)dataFactory;
                    reportData = dts.queryDesignTimeStructure(query, new QueryDataRowWrapper((DataRow)new StaticDataRow(), queryTimeout, 1, sortConstraints));
                } else {
                    reportData = dataFactory.queryData(query, new QueryDataRowWrapper((DataRow)new StaticDataRow(), queryTimeout, 1, sortConstraints));
                }
                this.offlineTableModel = new OfflineTableModel(reportData, new DefaultDataAttributeContext());
            }
            finally {
                if (reportData instanceof CloseableTableModel) {
                    CloseableTableModel ctm = (CloseableTableModel)reportData;
                    ctm.close();
                }
            }
        }
        if (this.offlineTableModel == null) {
            return new IndexedTableModel(new DefaultTableModel());
        }
        return this.offlineTableModel;
    }

    @Deprecated
    public boolean isSelectedDataSource(DataFactory dataFactory, String queryName) {
        return DesignTimeUtil.isSelectedDataSource(this.getReport(), dataFactory, queryName);
    }

    @Deprecated
    public static LinkedMap computeParameterValueSet(MasterReport report) {
        LinkedMap retval = new LinkedMap();
        retval.put((Object)"report.date", (Object)new Date());
        ReportParameterValues reportParameterValues = report.getParameterValues();
        ParameterDefinitionEntry[] columnNames = report.getParameterDefinition().getParameterDefinitions();
        for (int i = 0; i < columnNames.length; ++i) {
            ParameterDefinitionEntry parameter = columnNames[i];
            String columnName = parameter.getName();
            if (columnName == null) continue;
            retval.put((Object)columnName, reportParameterValues.get(columnName));
        }
        return retval;
    }
}

