/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.pvfs.conf;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.hadoop.shim.pvfs.conf.PvfsConf;

public class SnwConf
extends PvfsConf {
    private Pattern pathPattern = Pattern.compile("pvfs://.+/@[~%]?[^/]*/?.*");

    public SnwConf(ConnectionDetails details) {
        super(details);
    }

    @Override
    public boolean supportsConnection() {
        return "snw".equals(this.details.getType());
    }

    @Override
    public Path mapPath(Path pvfsPath) {
        this.generateUnsupportedException();
        return null;
    }

    @Override
    public Path mapPath(Path pvfsPath, Path realFsPath) {
        this.generateUnsupportedException();
        return null;
    }

    @Override
    public Configuration conf(Path pvfsPath) {
        return new Configuration();
    }

    private void generateUnsupportedException() {
        throw new UnsupportedOperationException("Use generateAlias method to process this URI");
    }

    @Override
    public String generateAlias(String pvfsPath) {
        java.nio.file.Path tempDir;
        this.validatePath(new Path(pvfsPath));
        if (!this.pathPattern.matcher(pvfsPath).matches()) {
            throw new IllegalStateException(pvfsPath + " not supported by " + this.details.getClass().getName());
        }
        try {
            tempDir = Files.createTempDirectory("SnowflakeStaging", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create a temporary work folder to hold the snowflake file");
        }
        UUID uuid = UUID.randomUUID();
        return Paths.get(tempDir.toString() + File.separator + uuid.toString(), new String[0]).toUri().toString();
    }
}

