/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.pvfs.conf;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.hadoop.shim.pvfs.PvfsHadoopBridge;
import org.pentaho.hadoop.shim.pvfs.conf.PvfsConf;

public class S3Conf
extends PvfsConf {
    private final String accessKey;
    private final String secretKey;
    private final String sessionToken;
    private String endpoint;
    private String pathStyleAccess;
    private final String credentialsFilePath;

    public S3Conf(ConnectionDetails details) {
        super(details);
        Map props = details.getProperties();
        this.credentialsFilePath = (String)props.get("credentialsFilePath");
        if (this.shouldGetCredsFromFile((String)props.get("accessKey"), (String)props.get("credentialsFilePath"))) {
            AWSCredentials creds = this.getCredsFromFile(props, this.credentialsFilePath);
            this.accessKey = creds.getAWSAccessKeyId();
            this.secretKey = creds.getAWSSecretKey();
            this.sessionToken = creds instanceof BasicSessionCredentials ? ((BasicSessionCredentials)creds).getSessionToken() : null;
        } else {
            this.accessKey = (String)props.get("accessKey");
            this.secretKey = (String)props.get("secretKey");
            this.sessionToken = (String)props.get("sessionToken");
            this.endpoint = (String)props.get("endpoint");
            this.pathStyleAccess = (String)props.get("pathStyleAccess");
        }
    }

    @Override
    public boolean supportsConnection() {
        return Arrays.asList("s3", "s3a", "s3n").contains(this.details.getType());
    }

    @Override
    public Path mapPath(Path pvfsPath) {
        this.validatePath(pvfsPath);
        String[] splitPath = pvfsPath.toUri().getPath().split("/");
        Preconditions.checkArgument((splitPath.length > 0 ? 1 : 0) != 0);
        String bucket = splitPath[1];
        String path = "/" + Arrays.stream(splitPath).skip(2L).collect(Collectors.joining("/"));
        try {
            return new Path(new URI("s3a", bucket, path, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Path mapPath(Path pvfsPath, Path realFsPath) {
        URI uri = realFsPath.toUri();
        return new Path(pvfsPath.toUri().getScheme(), PvfsHadoopBridge.getConnectionName(pvfsPath), "/" + uri.getHost() + uri.getPath());
    }

    @Override
    public Configuration conf(Path pvfsPath) {
        this.validatePath(pvfsPath);
        Configuration conf = new Configuration();
        conf.set("fs.s3a.access.key", this.accessKey);
        conf.set("fs.s3a.secret.key", this.secretKey);
        if (!Strings.isNullOrEmpty((String)this.sessionToken)) {
            conf.set("fs.s3a.aws.credentials.provider", "org.apache.hadoop.fs.s3a.TemporaryAWSCredentialsProvider");
            conf.set("fs.s3a.session.token", this.sessionToken);
        }
        conf.set("fs.s3a.impl", "org.apache.hadoop.fs.s3a.S3AFileSystem");
        conf.set("fs.s3a.connection.ssl.enabled", "true");
        conf.set("fs.s3a.attempts.maximum", "3");
        conf.set("fs.s3a.impl.disable.cache", "true");
        conf.set("fs.s3a.buffer.dir", System.getProperty("java.io.tmpdir"));
        if (!Strings.isNullOrEmpty((String)this.endpoint)) {
            conf.set("fs.s3a.endpoint", this.endpoint);
        }
        if (!Strings.isNullOrEmpty((String)this.pathStyleAccess)) {
            conf.set("fs.s3a.path.style.access", this.pathStyleAccess);
        }
        return conf;
    }

    private boolean shouldGetCredsFromFile(String accessKey, String credentialsFilePath) {
        return Strings.isNullOrEmpty((String)accessKey) && !Strings.isNullOrEmpty((String)credentialsFilePath);
    }

    private AWSCredentials getCredsFromFile(Map<String, String> props, String credentialsFilePath) {
        try {
            ProfileCredentialsProvider credProvider = new ProfileCredentialsProvider(credentialsFilePath, props.get("profileName"));
            return credProvider.getCredentials();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Failed to load credentials for profile [%s] from %s", props.get("profileName"), credentialsFilePath), e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        S3Conf s3Conf = (S3Conf)o;
        return Objects.equals(this.accessKey, s3Conf.accessKey) && Objects.equals(this.secretKey, s3Conf.secretKey) && Objects.equals(this.sessionToken, s3Conf.sessionToken) && Objects.equals(this.endpoint, s3Conf.endpoint) && Objects.equals(this.pathStyleAccess, s3Conf.pathStyleAccess) && Objects.equals(this.credentialsFilePath, s3Conf.credentialsFilePath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.accessKey, this.secretKey, this.sessionToken, this.endpoint, this.pathStyleAccess, this.credentialsFilePath);
    }
}

