/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.pvfs.conf;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.hadoop.shim.pvfs.PvfsHadoopBridge;
import org.pentaho.hadoop.shim.pvfs.conf.PvfsConf;

public class GcsConf
extends PvfsConf {
    private final String credentialsKeyPath;

    public GcsConf(ConnectionDetails details) {
        super(details);
        this.credentialsKeyPath = (String)details.getProperties().get("keyPath");
    }

    @Override
    public boolean supportsConnection() {
        return "gs".equalsIgnoreCase(this.details.getType());
    }

    @Override
    public Path mapPath(Path pvfsPath) {
        this.validatePath(pvfsPath);
        String[] splitPath = pvfsPath.toUri().getPath().split("/");
        Preconditions.checkArgument((splitPath.length > 0 ? 1 : 0) != 0);
        String bucket = splitPath[1];
        String path = "/" + Arrays.stream(splitPath).skip(2L).collect(Collectors.joining("/"));
        try {
            return new Path(new URI("gs", bucket, path, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Path mapPath(Path pvfsPath, Path realFsPath) {
        URI uri = realFsPath.toUri();
        return new Path(pvfsPath.toUri().getScheme(), PvfsHadoopBridge.getConnectionName(pvfsPath), "/" + uri.getHost() + uri.getPath());
    }

    @Override
    public Configuration conf(Path pvfsPath) {
        Configuration config = new Configuration();
        config.set("fs.gs.impl", "com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem");
        config.set("fs.AbstractFileSystem.gs.impl", "com.google.cloud.hadoop.fs.gcs.GoogleHadoopFS");
        config.set("google.cloud.auth.service.account.enable", "true");
        config.set("google.cloud.auth.service.account.json.keyfile", this.credentialsKeyPath);
        config.set("fs.gs.http.max.retry", "10");
        config.set("fs.gs.http.connect-timeout", "20000");
        config.set("fs.gs.performance.cache.enable", "false");
        return config;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GcsConf gcsConf = (GcsConf)o;
        return Objects.equals(this.credentialsKeyPath, gcsConf.credentialsKeyPath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.credentialsKeyPath);
    }
}

