/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.pvfs.conf;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.SecureAzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.hadoop.shim.pvfs.PvfsHadoopBridge;
import org.pentaho.hadoop.shim.pvfs.conf.PvfsConf;

public class ADLSGen2Conf
extends PvfsConf {
    private static final String DFS_CORE_WINDOWS_NET = ".dfs.core.windows.net";
    private static final String AZURE_AUTH_TYPE = "fs.azure.account.auth.type.";
    private final String accountName;
    private final String scheme;
    private String sharedKey;
    private String clientId;
    private String clientSecret;
    private String tenantId;
    private String sasToken;

    public ADLSGen2Conf(ConnectionDetails details) {
        super(details);
        try (SecureAzureBlobFileSystem secureAzureBlobFileSystem = new SecureAzureBlobFileSystem();){
            this.scheme = secureAzureBlobFileSystem.getScheme();
            this.accountName = (String)details.getProperties().get("accountName");
            if (this.isSharedKeyAuthentication((String)details.getProperties().get("sharedKey"))) {
                this.sharedKey = (String)details.getProperties().get("sharedKey");
            } else if (this.isAzureADAuthentication((String)details.getProperties().get("clientId"), (String)details.getProperties().get("clientSecret"), (String)details.getProperties().get("tenantId"))) {
                this.clientId = (String)details.getProperties().get("clientId");
                this.clientSecret = (String)details.getProperties().get("clientSecret");
                this.tenantId = (String)details.getProperties().get("tenantId");
            } else if (this.isSASTokenAuthentication((String)details.getProperties().get("sasToken"))) {
                this.sasToken = (String)details.getProperties().get("sasToken");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean supportsConnection() {
        return this.scheme.equalsIgnoreCase(this.details.getType());
    }

    @Override
    public Path mapPath(Path pvfsPath) {
        this.validatePath(pvfsPath);
        String[] splitPath = pvfsPath.toUri().getPath().split("/");
        Preconditions.checkArgument((splitPath.length > 0 ? 1 : 0) != 0);
        String bucket = splitPath[1] + "@" + this.accountName + DFS_CORE_WINDOWS_NET;
        String path = "/" + Arrays.stream(splitPath).skip(2L).collect(Collectors.joining("/"));
        try {
            return new Path(new URI(this.scheme, bucket, path, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Path mapPath(Path pvfsPath, Path realFsPath) {
        URI uri = realFsPath.toUri();
        return new Path(pvfsPath.toUri().getScheme(), PvfsHadoopBridge.getConnectionName(pvfsPath), "/" + uri.getUserInfo() + uri.getPath());
    }

    @Override
    public Configuration conf(Path pvfsPath) {
        Configuration config = new Configuration();
        config.set("fs.abfss.impl", "org.apache.hadoop.fs.azurebfs.SecureAzureBlobFileSystem");
        config.set("fs.AbstractFileSystem.abfss.impl", "org.apache.hadoop.fs.azurebfs.Abfss");
        config.set("fs.azure.abfss.account.name", this.accountName + DFS_CORE_WINDOWS_NET);
        if (!Strings.isNullOrEmpty((String)this.sharedKey)) {
            config.set(AZURE_AUTH_TYPE + this.accountName + DFS_CORE_WINDOWS_NET, AuthType.SharedKey.name());
            config.set("fs.azure.account.key." + this.accountName + DFS_CORE_WINDOWS_NET, this.sharedKey);
        } else if (!(Strings.isNullOrEmpty((String)this.clientId) || Strings.isNullOrEmpty((String)this.clientSecret) || Strings.isNullOrEmpty((String)this.tenantId))) {
            config.set(AZURE_AUTH_TYPE + this.accountName + DFS_CORE_WINDOWS_NET, AuthType.OAuth.name());
            config.set("fs.azure.account.oauth.provider.type." + this.accountName + DFS_CORE_WINDOWS_NET, "org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider");
            config.set("fs.azure.account.oauth2.client.endpoint." + this.accountName + DFS_CORE_WINDOWS_NET, "https://login.microsoftonline.com/" + this.tenantId + "/oauth2/token");
            config.set("fs.azure.account.oauth2.client.id." + this.accountName + DFS_CORE_WINDOWS_NET, this.clientId);
            config.set("fs.azure.account.oauth2.client.secret." + this.accountName + DFS_CORE_WINDOWS_NET, this.clientSecret);
        } else if (!Strings.isNullOrEmpty((String)this.sasToken)) {
            config.set("fs.azure.secure.mode", "true");
            config.set(AZURE_AUTH_TYPE + this.accountName + DFS_CORE_WINDOWS_NET, AuthType.SAS.name());
            config.set("fs.azure.sas.token.provider.type", "org.pentaho.hadoop.shim.pvfs.conf.providers.PentahoAzureSasTokenProvider");
            config.set("fs.azure.sas.token", this.sasToken.substring(1));
        }
        config.set("fs.azure.local.sas.key.mode", "false");
        config.set("fs.azure.enable.check.access", "true");
        config.set("fs.abfss.impl.disable.cache", "true");
        config.set("fs.abfss.buffer.dir", System.getProperty("java.io.tmpdir"));
        return config;
    }

    private boolean isSharedKeyAuthentication(String sharedKey) {
        return !Strings.isNullOrEmpty((String)sharedKey);
    }

    private boolean isAzureADAuthentication(String clientId, String clientSecret, String tenantId) {
        return !Strings.isNullOrEmpty((String)clientId) && !Strings.isNullOrEmpty((String)clientSecret) && !Strings.isNullOrEmpty((String)tenantId);
    }

    private boolean isSASTokenAuthentication(String sasToken) {
        return !Strings.isNullOrEmpty((String)sasToken);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ADLSGen2Conf adlsConf = (ADLSGen2Conf)o;
        return Objects.equals(this.accountName, adlsConf.accountName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.accountName);
    }
}

