/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.pvfs.conf;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.AdlFileSystem;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.hadoop.shim.pvfs.PvfsHadoopBridge;
import org.pentaho.hadoop.shim.pvfs.conf.PvfsConf;

public class ADLSGen1Conf
extends PvfsConf {
    private static final String AZURE_AUTH_TYPE = "fs.adl.oauth2.access.token.provider.type";
    private final String accountFQDN;
    private final String scheme;
    private String clientId;
    private String clientSecret;
    private String authTokenEndpoint;

    public ADLSGen1Conf(ConnectionDetails details) {
        super(details);
        try (AdlFileSystem adlFileSystem = new AdlFileSystem();){
            this.scheme = adlFileSystem.getScheme();
            this.accountFQDN = (String)details.getProperties().get("accountFQDN");
            if (this.isServiceToServiceAuthentication((String)details.getProperties().get("clientId"), (String)details.getProperties().get("clientSecret"), (String)details.getProperties().get("authTokenEndpoint"))) {
                this.clientId = (String)details.getProperties().get("clientId");
                this.clientSecret = (String)details.getProperties().get("clientSecret");
                this.authTokenEndpoint = (String)details.getProperties().get("authTokenEndpoint");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean supportsConnection() {
        return this.scheme.equalsIgnoreCase(this.details.getType());
    }

    @Override
    public Path mapPath(Path pvfsPath) {
        this.validatePath(pvfsPath);
        String[] splitPath = pvfsPath.toUri().getPath().split("/");
        Preconditions.checkArgument((splitPath.length > 0 ? 1 : 0) != 0);
        String bucket = this.accountFQDN;
        String path = "/" + Arrays.stream(splitPath).skip(1L).collect(Collectors.joining("/"));
        try {
            return new Path(new URI(this.scheme, bucket, path, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Path mapPath(Path pvfsPath, Path realFsPath) {
        URI uri = realFsPath.toUri();
        String userInfo = uri.getUserInfo();
        if (uri.getUserInfo() == null) {
            userInfo = "";
        }
        return new Path(pvfsPath.toUri().getScheme(), PvfsHadoopBridge.getConnectionName(pvfsPath), "/" + userInfo + uri.getPath());
    }

    @Override
    public Configuration conf(Path pvfsPath) {
        Configuration config = new Configuration();
        config.set("fs.adl.impl", "org.apache.hadoop.fs.adl.AdlFileSystem");
        config.set("fs.AbstractFileSystem.adl.impl", "org.apache.hadoop.fs.adl.Adl");
        if (!(Strings.isNullOrEmpty((String)this.clientId) || Strings.isNullOrEmpty((String)this.clientSecret) || Strings.isNullOrEmpty((String)this.authTokenEndpoint))) {
            config.set(AZURE_AUTH_TYPE, "ClientCredential");
            config.set("fs.adl.oauth2.refresh.url", this.authTokenEndpoint);
            config.set("fs.adl.oauth2.client.id", this.clientId);
            config.set("fs.adl.oauth2.credential", this.clientSecret);
        }
        return config;
    }

    private boolean isServiceToServiceAuthentication(String clientId, String clientSecret, String authTokenEndpoint) {
        return !Strings.isNullOrEmpty((String)clientId) && !Strings.isNullOrEmpty((String)clientSecret) && !Strings.isNullOrEmpty((String)authTokenEndpoint);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ADLSGen1Conf adlsConf = (ADLSGen1Conf)o;
        return Objects.equals(this.accountFQDN, adlsConf.accountFQDN);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.accountFQDN);
    }
}

