/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.libsparklines.util;

public final class GraphUtils {
    private GraphUtils() {
    }

    public static float getDivisor(Number[] data, int height) {
        if (data == null) {
            throw new NullPointerException("Data array must not be null.");
        }
        if (height < 1) {
            throw new IndexOutOfBoundsException("Height must be greater or equal to 1");
        }
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        for (int index = 0; index < data.length; ++index) {
            Number i = data[index];
            if (i == null) continue;
            float numValue = i.floatValue();
            if (numValue < min) {
                min = numValue;
            }
            if (!(numValue > max)) continue;
            max = numValue;
        }
        if (max <= min) {
            return 1.0f;
        }
        if (height == 1) {
            return 0.0f;
        }
        return (max - min) / (float)(height - 1);
    }

    public static float getAxe(Number[] data) {
        if (data == null) {
            throw new NullPointerException("Data array must not be null.");
        }
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        for (int index = 0; index < data.length; ++index) {
            Number i = data[index];
            if (i == null) continue;
            float numValue = i.floatValue();
            if (index == 0) {
                max = min = numValue;
                continue;
            }
            if (numValue > max) {
                max = numValue;
            }
            if (!(numValue < min)) continue;
            min = numValue;
        }
        if (min >= 0.0f) {
            return 0.0f;
        }
        if (max <= 0.0f) {
            return -1.0f;
        }
        float distance = max - min;
        float axe = distance / 2.0f;
        float delta = max - axe;
        return axe + delta;
    }
}

