/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils.widgets;

import java.util.ArrayList;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.pentaho.di.baserver.utils.widgets.WidgetBuilder;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;

public class TableViewBuilder
extends WidgetBuilder<TableView> {
    public static final int MINIMUM_LAST_COLUMN_WIDTH = 20;
    private VariableSpace variableSpace;
    private ArrayList<ColumnInfo> columns = new ArrayList();
    private int rowsCount = 0;
    private ModifyListener modifyListener = null;

    public TableViewBuilder(PropsUI props, Composite parent, VariableSpace variableSpace) {
        super(parent, props);
        this.variableSpace = variableSpace;
    }

    public TableViewBuilder addColumnInfo(ColumnInfo columnInfo) {
        this.columns.add(columnInfo);
        return this;
    }

    public TableViewBuilder setRowsCount(int rowsCount) {
        this.rowsCount = rowsCount;
        return this;
    }

    public TableViewBuilder setModifyListener(ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
        return this;
    }

    @Override
    protected TableView createWidget(Composite parent) {
        ColumnInfo[] columnsArray = this.columns.toArray(new ColumnInfo[this.columns.size()]);
        TableView tableView = this.createTableView(this.variableSpace, parent, 67586, columnsArray, this.rowsCount, this.modifyListener, this.props);
        if (!Const.isRunningOnWebspoonMode()) {
            final Table table = tableView.getTable();
            ControlAdapter columnResizeListener = new ControlAdapter(){

                public void controlResized(ControlEvent controlEvent) {
                    super.controlResized(controlEvent);
                    TableColumn[] tableColumns = table.getColumns();
                    int columnsWidth = 0;
                    for (int i = 0; i < tableColumns.length - 1; ++i) {
                        TableColumn column = table.getColumn(i);
                        columnsWidth += column.getWidth();
                    }
                    int lastColumnWidth = table.getClientArea().width - columnsWidth;
                    tableColumns[tableColumns.length - 1].setWidth(lastColumnWidth < 20 ? 20 : lastColumnWidth);
                }
            };
            table.addControlListener((ControlListener)columnResizeListener);
            for (TableColumn column : table.getColumns()) {
                column.addControlListener((ControlListener)columnResizeListener);
            }
        }
        return tableView;
    }

    protected TableView createTableView(VariableSpace variableSpace, Composite parent, int flags, ColumnInfo[] columnsArray, int rowsCount, ModifyListener modifyListener, PropsUI props) {
        return new TableView(variableSpace, parent, flags, columnsArray, rowsCount, modifyListener, props);
    }
}

