/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.mapreduce;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.pentaho.big.data.impl.shim.mapreduce.FutureMapReduceJobSimpleRunnable;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceExecutionException;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceJobSimple;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceService;

public class FutureMapReduceJobSimpleImpl
implements MapReduceJobSimple {
    private final Future<?> future;
    private final String mainClass;
    private final AtomicBoolean complete;
    private final AtomicInteger status;
    private final AtomicReference<MapReduceExecutionException> exceptionAtomicReference;

    public FutureMapReduceJobSimpleImpl(ExecutorService executorService, Class<?> mainClass, String commandLineArgs) {
        this(executorService, mainClass, new FutureMapReduceJobSimpleRunnable(mainClass, commandLineArgs, new AtomicBoolean(false), new AtomicInteger(-1), new AtomicReference<Object>(null)));
    }

    public FutureMapReduceJobSimpleImpl(ExecutorService executorService, Class<?> mainClass, FutureMapReduceJobSimpleRunnable runnable) {
        this.mainClass = mainClass.getCanonicalName();
        this.future = executorService.submit(runnable);
        this.complete = runnable.getComplete();
        this.status = runnable.getStatus();
        this.exceptionAtomicReference = runnable.getExceptionAtomicReference();
    }

    public void killJob() throws IOException {
        if (!this.complete.getAndSet(true)) {
            this.future.cancel(true);
        }
    }

    public boolean waitOnCompletion(long timeout, TimeUnit timeUnit, MapReduceService.Stoppable stoppable) throws IOException, MapReduceExecutionException {
        try {
            this.future.get(timeout, timeUnit);
            MapReduceExecutionException mapReduceExecutionException = this.exceptionAtomicReference.get();
            if (mapReduceExecutionException != null) {
                throw mapReduceExecutionException;
            }
            return true;
        }
        catch (InterruptedException e) {
            this.killJob();
            return true;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MapReduceExecutionException) {
                throw (MapReduceExecutionException)cause;
            }
            throw new MapReduceExecutionException(cause);
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public boolean isSuccessful() throws IOException {
        return this.status.get() == 0;
    }

    public boolean isComplete() throws IOException {
        return this.complete.get();
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public int getStatus() {
        return this.status.get();
    }
}

