/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi.service.notifier;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.pentaho.di.osgi.service.lifecycle.LifecycleEvent;
import org.pentaho.di.osgi.service.notifier.DelayedServiceNotifierListener;

public class AggregatingNotifierListener
implements DelayedServiceNotifierListener {
    private final AtomicInteger count = new AtomicInteger(0);
    private final Set<DelayedServiceNotifierListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public boolean addListener(DelayedServiceNotifierListener notifierListener) {
        return this.listeners.add(notifierListener);
    }

    public boolean removeListener(DelayedServiceNotifierListener notifierListener) {
        return this.listeners.remove(notifierListener);
    }

    public void incrementCount() {
        this.count.incrementAndGet();
    }

    public int getCount() {
        return this.count.get();
    }

    @Override
    public void onRun(LifecycleEvent event, Object serviceObject) {
        this.count.decrementAndGet();
        for (DelayedServiceNotifierListener listener : this.listeners) {
            listener.onRun(event, serviceObject);
        }
    }
}

