/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi;

import com.google.common.annotations.VisibleForTesting;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.pentaho.di.core.util.ExecutorUtil;
import org.pentaho.di.osgi.KettleLifecycleEvent;
import org.pentaho.di.osgi.OSGIPluginTracker;
import org.pentaho.di.osgi.service.lifecycle.LifecycleEvent;
import org.pentaho.di.osgi.service.notifier.DelayedServiceNotifierListener;
import org.pentaho.osgi.api.IKarafBlueprintWatcher;
import org.pentaho.osgi.api.IKarafFeatureWatcher;
import org.pentaho.platform.servicecoordination.api.IPhasedLifecycleEvent;
import org.pentaho.platform.servicecoordination.api.IPhasedLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafLifecycleListener
implements IPhasedLifecycleListener<KettleLifecycleEvent> {
    private static KarafLifecycleListener instance;
    private static Logger logger;
    private final long timeout;
    private final OSGIPluginTracker osgiPluginTracker;
    private AtomicBoolean listenerActive = new AtomicBoolean(false);
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private BundleContext bundleContext;
    private IPhasedLifecycleEvent<KettleLifecycleEvent> event;
    private Thread watcherThread;
    private final Integer frameworkBeginningStartLevel;
    private FrameworkStartLevel frameworkStartLevel;

    @VisibleForTesting
    KarafLifecycleListener() {
        this(KarafLifecycleListener.getSystemProperty(KarafLifecycleListener.class.getCanonicalName() + ".timeout", TimeUnit.SECONDS.toMillis(100L), Long::parseLong));
    }

    @VisibleForTesting
    KarafLifecycleListener(long timeout) {
        this(timeout, OSGIPluginTracker.getInstance());
    }

    @VisibleForTesting
    KarafLifecycleListener(long timeout, OSGIPluginTracker osgiPluginTracker) {
        this(timeout, osgiPluginTracker, KarafLifecycleListener.getSystemProperty("org.osgi.framework.startlevel.beginning", 100, Integer::parseInt));
    }

    @VisibleForTesting
    KarafLifecycleListener(long timeout, OSGIPluginTracker osgiPluginTracker, int frameworkBeginningStartLevel) {
        this.timeout = timeout;
        this.osgiPluginTracker = osgiPluginTracker;
        this.frameworkBeginningStartLevel = frameworkBeginningStartLevel;
    }

    private static <T> T getSystemProperty(String propertyKey, T defaultValue, Function<String, T> parseFunction) {
        String propertyValue = System.getProperty(propertyKey);
        T result = defaultValue;
        try {
            result = parseFunction.apply(propertyValue);
        }
        catch (Exception e) {
            logger.debug("Failed to parse {} property of value {}, returning default value of {}.", new Object[]{propertyKey, propertyValue, defaultValue});
        }
        return result;
    }

    public static synchronized KarafLifecycleListener getInstance() {
        if (instance == null) {
            instance = new KarafLifecycleListener();
        }
        return instance;
    }

    public void onPhaseChange(IPhasedLifecycleEvent<KettleLifecycleEvent> event) {
        this.event = event;
        if (((KettleLifecycleEvent)((Object)event.getNotificationObject())).equals((Object)KettleLifecycleEvent.INIT)) {
            this.listenerActive.set(true);
            this.startTimeoutThread();
            this.maybeStartWatchers();
        } else {
            event.accept();
        }
    }

    private void startTimeoutThread() {
        final long endWaitTime = System.currentTimeMillis() + this.timeout;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!KarafLifecycleListener.this.initialized.get() && !this.timedOut()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                if (!KarafLifecycleListener.this.initialized.get()) {
                    logger.error("The Kettle Karaf Lifecycle Listener failed to execute properly after waiting for {} seconds. Releasing lifecycle hold, but some services may be unavailable.", (Object)TimeUnit.MILLISECONDS.toSeconds(KarafLifecycleListener.this.timeout));
                    KarafLifecycleListener.this.event.accept();
                }
            }

            private boolean timedOut() {
                if (KarafLifecycleListener.this.timeout < 0L) {
                    return false;
                }
                return System.currentTimeMillis() > endWaitTime;
            }
        });
        t.setDaemon(true);
        t.setName("KarafLifecycleListener Timeout Thread");
        t.start();
    }

    private void maybeStartWatchers() {
        if (this.bundleContext != null && this.listenerActive.get()) {
            this.watcherThread = new Thread(() -> {
                logger.debug("Watcher thread started");
                this.waitForBundlesStarted();
                this.waitForBlueprints();
                this.acceptEventOnDelayedServiceNotifiersDone();
            });
            this.watcherThread.setDaemon(true);
            this.watcherThread.setName("KarafLifecycleListener Watcher Thread");
            this.watcherThread.start();
            this.initialized.set(true);
        }
    }

    private void waitForBundlesStarted() {
        this.waitForFeatures();
        this.waitForFrameworkStarted();
    }

    private synchronized <T> T getOsgiService(Class<T> serviceClass) {
        block4: {
            ServiceReference serviceReference = null;
            try {
                if (null == serviceReference && null != this.bundleContext && !Thread.currentThread().isInterrupted()) {
                    this.wait(100L);
                    serviceReference = this.bundleContext.getServiceReference(serviceClass);
                    if (serviceReference == null) {
                        return null;
                    }
                    return (T)this.bundleContext.getService(serviceReference);
                }
            }
            catch (IllegalStateException | InterruptedException e) {
                if (!(e instanceof InterruptedException) && (!(e instanceof IllegalStateException) || !((IllegalStateException)e).getMessage().startsWith("Invalid BundleContext"))) break block4;
                logger.debug(String.format("Watcher thread interrupted waiting for service %s", serviceClass.getName()));
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    @VisibleForTesting
    void waitForFeatures() {
        try {
            Thread.sleep(100L);
            IKarafFeatureWatcher karafFeatureWatcher = this.getOsgiService(IKarafFeatureWatcher.class);
            if (karafFeatureWatcher == null) {
                if (null != this.bundleContext && !Thread.currentThread().isInterrupted()) {
                    throw new IKarafFeatureWatcher.FeatureWatcherException("No IKarafFeatureWatcher service available.");
                }
                if (Thread.currentThread().isInterrupted()) {
                    logger.debug("Thread interrupted itself because bundle context was invalid; bundle likely restarting");
                }
            } else {
                karafFeatureWatcher.waitForFeatures();
            }
        }
        catch (IKarafFeatureWatcher.FeatureWatcherException e) {
            if (null != this.bundleContext && !(e.getCause() instanceof InterruptedException)) {
                logger.error("Error in Feature Watcher", (Throwable)e);
            } else if (e.getCause() instanceof InterruptedException) {
                logger.debug("Watcher thread interrupted during karafFeatureWatcher.waitForFeatures");
                Thread.currentThread().interrupt();
            }
        }
        catch (InterruptedException e) {
            logger.debug("Watcher thread interrupted during waitForFeatures");
            Thread.currentThread().interrupt();
        }
    }

    @VisibleForTesting
    void waitForBlueprints() {
        try {
            Thread.sleep(100L);
            IKarafBlueprintWatcher karafBlueprintWatcher = this.getOsgiService(IKarafBlueprintWatcher.class);
            if (karafBlueprintWatcher == null) {
                if (null != this.bundleContext && !Thread.currentThread().isInterrupted()) {
                    throw new IKarafBlueprintWatcher.BlueprintWatcherException("No IKarafBlueprintWatcher service available.");
                }
                if (Thread.currentThread().isInterrupted()) {
                    logger.debug("Thread interrupted itself because bundle context was invalid; bundle likely restarting");
                }
            } else {
                karafBlueprintWatcher.waitForBlueprint();
            }
        }
        catch (IKarafBlueprintWatcher.BlueprintWatcherException e) {
            if (null != this.bundleContext && !(e.getCause() instanceof InterruptedException)) {
                logger.error("Error in Feature Watcher", (Throwable)e);
            } else if (e.getCause() instanceof InterruptedException) {
                logger.debug("Watcher thread interrupted during karafBlueprintWatcher.waitForBlueprint");
                Thread.currentThread().interrupt();
            }
        }
        catch (InterruptedException e) {
            logger.debug("Watcher thread interrupted during waitForBlueprints");
            Thread.currentThread().interrupt();
        }
    }

    @VisibleForTesting
    void acceptEventOnDelayedServiceNotifiersDone() {
        try {
            Thread.sleep(100L);
            if (null != this.bundleContext && !Thread.currentThread().isInterrupted()) {
                final AtomicBoolean accepted = new AtomicBoolean(false);
                DelayedServiceNotifierListener delayedServiceNotifierListener = new DelayedServiceNotifierListener(){

                    @Override
                    public void onRun(LifecycleEvent lifecycleEvent, Object serviceObject) {
                        if (KarafLifecycleListener.this.osgiPluginTracker.getOutstandingServiceNotifierListeners() == 0 && !accepted.getAndSet(true)) {
                            logger.debug("Done waiting on delayed service notifiers");
                            KarafLifecycleListener.this.event.accept();
                            KarafLifecycleListener.this.osgiPluginTracker.removeDelayedServiceNotifierListener(this);
                        }
                    }
                };
                logger.debug("About to start waiting on delayed service notifiers");
                this.osgiPluginTracker.addDelayedServiceNotifierListener(delayedServiceNotifierListener);
                delayedServiceNotifierListener.onRun(null, null);
            }
        }
        catch (InterruptedException e) {
            logger.debug("Watcher thread interrupted during acceptEventOnDelayedServiceNotifiersDone");
            Thread.currentThread().interrupt();
        }
    }

    @VisibleForTesting
    void waitForFrameworkStarted() {
        while (this.frameworkStartLevel.getStartLevel() < this.frameworkBeginningStartLevel) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.debug("Thread interrupted while waiting for OSGi framework start level to reach the beginning start level.");
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void setBundleContext(BundleContext bundleContext) {
        if (null != bundleContext) {
            this.bundleContext = bundleContext;
            logger.debug("Bundle context set in KarafLifecycleListener");
            bundleContext.registerService(ExecutorService.class, (Object)ExecutorUtil.getExecutor(), new Hashtable());
            this.frameworkStartLevel = (FrameworkStartLevel)bundleContext.getBundle(0L).adapt(FrameworkStartLevel.class);
            this.maybeStartWatchers();
        } else {
            logger.debug("Bundle context cleared in KarafLifecycleListener");
            if (null != this.watcherThread && this.watcherThread.isAlive()) {
                this.watcherThread.interrupt();
                logger.debug("Watcher thread interrupted");
                while (this.watcherThread.isAlive()) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.watcherThread = null;
                this.bundleContext = null;
            }
        }
    }

    @VisibleForTesting
    static void setLogger(Logger testLogger) {
        logger = testLogger;
    }

    static {
        logger = LoggerFactory.getLogger(KarafLifecycleListener.class);
    }
}

