/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.teradatabulkloader;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.teradatabulkloader.TeraDataBulkLoader;
import org.pentaho.di.trans.steps.teradatabulkloader.TeraDataBulkLoaderMeta;

public class TeraDataBulkLoaderRoutines {
    private static Class<?> PKG = TeraDataBulkLoaderMeta.class;
    private TeraDataBulkLoader parent;
    private TeraDataBulkLoaderMeta meta;
    private OutputStream scriptFile;
    private PrintStream scriptFilePrintStream;
    static final int SIZEOF_INT = 4;

    public TeraDataBulkLoaderRoutines(TeraDataBulkLoader parent, TeraDataBulkLoaderMeta meta) {
        this.parent = parent;
        this.meta = meta;
    }

    @VisibleForTesting
    String getTargetSchema(boolean isPreview) {
        if (this.meta.getSchemaName() == null || this.meta.getSchemaName().isEmpty()) {
            return isPreview ? this.meta.getDbName() : this.parent.environmentSubstitute(this.meta.getDbName());
        }
        return isPreview ? this.meta.getSchemaName() : this.parent.environmentSubstitute(this.meta.getSchemaName());
    }

    private String createInsertCommand(boolean isPreview) {
        StringBuffer cmd = new StringBuffer();
        cmd.append(" INSERT INTO " + this.getTargetSchema(isPreview) + '.' + (isPreview ? this.meta.getTableName() : this.parent.environmentSubstitute(this.meta.getTableName() + "\n")));
        cmd.append("   (\n");
        String[] fieldTable = this.meta.getFieldTable();
        for (int i = 0; i < fieldTable.length; ++i) {
            cmd.append("       " + fieldTable[i]);
            if (i < fieldTable.length - 1) {
                cmd.append(",");
            }
            cmd.append("\n");
        }
        cmd.append("   )\n");
        cmd.append(" VALUES\n");
        cmd.append("   (\n");
        String[] fieldStream = this.meta.getFieldStream();
        for (int i = 0; i < fieldStream.length; ++i) {
            cmd.append("       :" + fieldStream[i]);
            if (i < fieldStream.length - 1) {
                cmd.append(",");
            }
            cmd.append("\n");
        }
        cmd.append("   )\n");
        return cmd.toString();
    }

    @VisibleForTesting
    String createUpsertCommand(boolean isPreview) {
        StringBuffer updatecmd = new StringBuffer();
        StringBuffer insertcmd = new StringBuffer();
        updatecmd.append(" UPDATE " + this.getTargetSchema(isPreview) + '.' + (isPreview ? this.meta.getTableName() : this.parent.environmentSubstitute(this.meta.getTableName())) + " SET\n");
        String[] fieldTable = this.meta.getFieldTable();
        String[] fieldStream = this.meta.getFieldStream();
        Boolean[] fieldUpdate = this.meta.getFieldUpdate();
        HashMap<String, Boolean> usedAsKey = new HashMap<String, Boolean>();
        StringBuffer whereClause = new StringBuffer();
        for (int i = 0; i < this.meta.getKeyStream().length; ++i) {
            whereClause.append("        " + (i == 0 ? "WHERE " : "AND") + " ");
            whereClause.append(this.meta.getKeyLookup()[i] + " " + this.meta.getKeyCondition()[i] + " :" + this.meta.getKeyStream()[i] + "\n");
            usedAsKey.put(this.meta.getKeyLookup()[i], new Boolean(true));
        }
        int numberOfFieldsAdded = 0;
        for (int i = 0; i < fieldTable.length; ++i) {
            if (usedAsKey.containsKey(fieldTable[i]) || !fieldUpdate[i].booleanValue()) continue;
            if (numberOfFieldsAdded > 0) {
                updatecmd.append(",");
            }
            updatecmd.append("          " + fieldTable[i] + " = :" + fieldStream[i]);
            updatecmd.append("\n");
            ++numberOfFieldsAdded;
        }
        updatecmd.append(whereClause + ";\n");
        insertcmd.append(this.createInsertCommand(isPreview));
        return this.quote(updatecmd.toString()) + ",\n" + this.quote(insertcmd.toString());
    }

    private String createStep(String label, String code, String operator) {
        StringBuffer cmd = new StringBuffer("STEP " + label + "(\n" + code + "\n");
        if (operator != null) {
            cmd.append(operator);
        }
        cmd.append("\n);\n");
        return cmd.toString();
    }

    private String toOperator(String operator) {
        return "TO OPERATOR ( " + operator + " )";
    }

    private String selectOperator(String operator) {
        return "SELECT * FROM OPERATOR ( " + operator + " )";
    }

    private String toSelectOperator(String toOp, String selOp) {
        StringBuffer cmd = new StringBuffer(this.toOperator(toOp) + "\n");
        if (selOp != null) {
            cmd.append(this.selectOperator(selOp));
        }
        cmd.append(";\n");
        return cmd.toString();
    }

    private String quote(String s) {
        return "'" + s + "'";
    }

    private String paren(String s) {
        return "(" + s + ")";
    }

    private String addMissingOptions() {
        StringBuffer cmd = new StringBuffer();
        if (this.meta.getIgnoreDupUpdate()) {
            cmd.append("IGNORE DUPLICATE UPDATE ROWS\n");
        }
        if (this.meta.getInsertMissingUpdate()) {
            cmd.append("INSERT FOR MISSING UPDATE ROWS\n");
        }
        if (this.meta.getIgnoreMissingUpdate()) {
            cmd.append("IGNORE MISSING UPDATE ROWS\n");
        }
        return cmd.toString();
    }

    private String teradataJob(String jobName, String description, String code) {
        return "DEFINE JOB " + jobName + "\nDESCRIPTION '" + description + "'\n(\n" + code + ");";
    }

    public String dropTable(boolean isPreview, String user, String suffix) {
        return "DROP TABLE " + (Const.isEmpty((String)user) ? (isPreview ? this.meta.getTableName() : this.parent.environmentSubstitute(this.meta.getTableName())) + "_" + suffix : user);
    }

    public String createScriptFile() throws Exception {
        File tempScriptFile = this.meta.getGenerateScript() ? File.createTempFile(FilenameUtils.getBaseName((String)this.parent.environmentSubstitute(this.meta.getScriptFileName())), "") : File.createTempFile(FilenameUtils.getBaseName((String)this.parent.environmentSubstitute(this.meta.getExistingScriptFile())), "");
        tempScriptFile.deleteOnExit();
        try {
            this.scriptFile = FileUtils.openOutputStream((File)tempScriptFile);
            this.scriptFilePrintStream = new PrintStream(this.scriptFile);
        }
        catch (IOException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.Exception.OpenScriptFile", (Object[])new Object[]{this.scriptFile}), (Throwable)e);
        }
        if (this.meta.getGenerateScript()) {
            this.createGeneratedScriptFile();
        } else {
            this.createFromExistingScriptFile();
        }
        this.scriptFilePrintStream.close();
        IOUtils.closeQuietly((OutputStream)this.scriptFile);
        return tempScriptFile.getAbsolutePath();
    }

    public void createFromExistingScriptFile() throws Exception {
        String strLine;
        FileInputStream originalScript = new FileInputStream(this.parent.environmentSubstitute(this.meta.getExistingScriptFile()));
        DataInputStream in = new DataInputStream(originalScript);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((strLine = br.readLine()) != null) {
            if (this.meta.getSubstituteControlFile()) {
                this.scriptFilePrintStream.print(this.parent.environmentSubstitute(strLine) + "\n");
                continue;
            }
            this.scriptFilePrintStream.print(strLine + "\n");
        }
        in.close();
    }

    public String createGeneratedScriptFile() throws Exception {
        HashMap<String, Integer> inputFieldTypes = new HashMap<String, Integer>();
        HashMap<String, Integer> inputFieldLength = new HashMap<String, Integer>();
        for (int i = 0; i < this.parent.getInputRowMeta().size(); ++i) {
            inputFieldTypes.put(this.parent.getInputRowMeta().getValueMeta(i).getName(), this.parent.getInputRowMeta().getValueMeta(i).getType());
            inputFieldLength.put(this.parent.getInputRowMeta().getValueMeta(i).getName(), this.parent.getInputRowMeta().getValueMeta(i).getLength());
        }
        return this.createGeneratedScriptFile(inputFieldTypes, inputFieldLength);
    }

    public String createGeneratedScriptFile(Map<String, Integer> inputFieldTypes, Map<String, Integer> inputFieldLength) throws Exception {
        boolean isPreview = this.parent == null;
        String hiddenPassword = BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.HiddenPassword", (String[])new String[0]);
        DefineSchema tableSchema = new DefineSchema(isPreview ? this.meta.getSchemaName() : this.parent.environmentSubstitute(this.meta.getSchemaName()));
        String[] fieldStream = this.meta.getFieldStream();
        if (inputFieldTypes.size() == 0 || fieldStream == null || inputFieldTypes == null || inputFieldLength == null) {
            return BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.NoInputStream", (String[])new String[0]);
        }
        System.out.println("fieldStream length is " + fieldStream.length);
        for (int i = 0; i < fieldStream.length; ++i) {
            int type = inputFieldTypes.get(fieldStream[i]);
            int len = inputFieldLength.get(fieldStream[i]);
            tableSchema.addField(fieldStream[i], type, len);
        }
        DefineSchema dataConnector = this.getDataConnector(isPreview);
        DefineSchema ddlOptions = this.getDdlOptions(isPreview, hiddenPassword);
        DefineSchema updateOptions = this.getUpdateOptions(isPreview, hiddenPassword);
        String dropTables = this.getDropTables(isPreview);
        String loadCommand = null;
        ApplyClause cmdApply = new ApplyClause();
        switch (this.meta.getActionType()) {
            case 0: {
                cmdApply.addClause(this.quote(this.createInsertCommand(isPreview)));
                loadCommand = this.createStep("Load_Table", cmdApply.toString(), this.toSelectOperator("UPDATE_OPERATOR[2]", "ACCESS_MODULE_READER[2]"));
                break;
            }
            case 1: {
                cmdApply.addClause(this.createUpsertCommand(isPreview));
                loadCommand = this.createStep("Upsert_Table", cmdApply.toString() + this.addMissingOptions(), this.toSelectOperator("UPDATE_OPERATOR[2]", "ACCESS_MODULE_READER[2]"));
            }
        }
        String script = this.teradataJob(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.Script.Name", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.Script.Description", (String[])new String[0]), (tableSchema != null ? tableSchema.toString() : "") + (ddlOptions != null ? ddlOptions.toString() : "") + (dataConnector != null ? dataConnector.toString() : "") + (updateOptions != null ? updateOptions.toString() : "") + (dropTables != null ? dropTables : "") + loadCommand);
        if (this.scriptFilePrintStream != null) {
            this.scriptFilePrintStream.print(script);
        }
        return script;
    }

    @VisibleForTesting
    String getDropTables(boolean isPreview) {
        String dropTables = null;
        boolean drop = false;
        ApplyClause dropClauses = new ApplyClause();
        if (this.meta.getDropLogTable()) {
            dropClauses.addClause(this.quote(this.dropTable(isPreview, isPreview ? this.meta.getLogTable() : this.parent.environmentSubstitute(this.meta.getLogTable()), "")));
            drop = true;
        }
        if (this.meta.getDropWorkTable()) {
            dropClauses.addClause(this.quote(this.dropTable(isPreview, isPreview ? this.meta.getWorkTable() : this.parent.environmentSubstitute(this.meta.getWorkTable()), "WT")));
            drop = true;
        }
        if (this.meta.getDropErrorTable()) {
            dropClauses.addClause(this.quote(this.dropTable(isPreview, isPreview ? this.meta.getErrorTable() : this.parent.environmentSubstitute(this.meta.getErrorTable()), "ET")));
            drop = true;
        }
        if (this.meta.getDropErrorTable2()) {
            dropClauses.addClause(this.quote(this.dropTable(isPreview, isPreview ? this.meta.getErrorTable2() : this.parent.environmentSubstitute(this.meta.getErrorTable2()), "UV")));
            drop = true;
        }
        if (drop) {
            dropTables = this.createStep("Setup_tables", dropClauses.toString(), this.toSelectOperator("DDL_OPERATOR", null));
        }
        return dropTables;
    }

    @VisibleForTesting
    DefineSchema getDataConnector(boolean isPreview) {
        DefineSchema dataConnector = new DefineSchema("ACCESS_MODULE_READER", "DATACONNECTOR PRODUCER", isPreview ? this.meta.getSchemaName() : this.parent.environmentSubstitute(this.meta.getSchemaName()));
        dataConnector.addField("PrivateLogName", isPreview ? this.meta.getAccessLogFile() : this.parent.environmentSubstitute(this.meta.getAccessLogFile()));
        dataConnector.addField("AccessModuleName", "np_axsmod.so");
        dataConnector.addField("AccessModuleInitStr", null);
        dataConnector.addField("FileName", this.parent != null ? this.parent.data.fifoFilename : this.meta.getFifoFileName());
        dataConnector.addField("Format", "Unformatted");
        dataConnector.addField("OpenMode", "Read");
        return dataConnector;
    }

    @VisibleForTesting
    DefineSchema getDdlOptions(boolean isPreview, String hiddenPassword) {
        DefineSchema ddlOptions = new DefineSchema("DDL_OPERATOR", "DDL", null);
        ddlOptions.addField("TdpId             ", this.meta.getDatabaseMeta().getHostname());
        ddlOptions.addField("UserName          ", this.meta.getDatabaseMeta().getUsername());
        ddlOptions.addField("UserPassword      ", isPreview ? hiddenPassword : this.meta.getDatabaseMeta().getPassword());
        ddlOptions.addField("ErrorList         ", "3807");
        return ddlOptions;
    }

    @VisibleForTesting
    DefineSchema getUpdateOptions(boolean isPreview, String hiddenPassword) {
        DefineSchema updateOptions = new DefineSchema("UPDATE_OPERATOR", "UPDATE", "*");
        updateOptions.addField("TdpId             ", this.meta.getDatabaseMeta().getHostname());
        updateOptions.addField("PrivateLogName    ", isPreview ? this.meta.getUpdateLogFile() : this.parent.environmentSubstitute(this.meta.getUpdateLogFile()));
        updateOptions.addField("UserName          ", this.meta.getDatabaseMeta().getUsername());
        updateOptions.addField("UserPassword      ", isPreview ? hiddenPassword : this.meta.getDatabaseMeta().getPassword());
        updateOptions.addField("LogTable          ", isPreview ? this.meta.getLogTable() : this.parent.environmentSubstitute(this.meta.getLogTable()));
        updateOptions.addField("TargetTable       ", this.getTargetSchema(isPreview) + "." + (isPreview ? this.meta.getTableName() : this.parent.environmentSubstitute(this.meta.getTableName())));
        updateOptions.addField("WorkTable         ", isPreview ? this.meta.getWorkTable() : this.parent.environmentSubstitute(this.meta.getWorkTable()));
        updateOptions.addField("ErrorTable1       ", isPreview ? this.meta.getErrorTable() : this.parent.environmentSubstitute(this.meta.getErrorTable()));
        updateOptions.addField("ErrorTable2       ", isPreview ? this.meta.getErrorTable2() : this.parent.environmentSubstitute(this.meta.getErrorTable2()));
        return updateOptions;
    }

    private String resolveFileName(String fileName) throws KettleException {
        FileObject fileObject = KettleVFS.getFileObject((String)this.parent.environmentSubstitute(fileName));
        return KettleVFS.getFilename((FileObject)fileObject);
    }

    static byte[] convertChar(ValueMetaInterface valueMeta, Object valueData) throws KettleValueException {
        String string = valueMeta.getString(valueData);
        if (string != null) {
            return string.getBytes();
        }
        return null;
    }

    static byte[] convertVarchar(String string) {
        ByteBuffer b = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        short strlen = 0;
        if (string == null) {
            b = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
            b.putShort((short)0);
            return b.array();
        }
        strlen = (short)string.length();
        b.putShort(strlen);
        byte[] result = new byte[2 + strlen];
        System.arraycopy(b.array(), 0, result, 0, 2);
        System.arraycopy(string.getBytes(), 0, result, 2, strlen);
        return result;
    }

    static byte[] convertLong(Long integer) {
        ByteBuffer b = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        b.putLong(integer != null ? integer : 0L);
        return b.array();
    }

    static byte[] convertFloat(Double d) {
        ByteBuffer b = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        b.putDouble(d != null ? d : 0.0);
        return b.array();
    }

    static byte[] convertBignum(BigDecimal d) {
        if (d != null) {
            return TeraDataBulkLoaderRoutines.convertFloat(d.doubleValue());
        }
        return TeraDataBulkLoaderRoutines.convertFloat(new Double(0.0));
    }

    static byte[] convertDateTime(Date ts) {
        if (ts != null) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
            String fmtdate = fmt.format(ts);
            return fmtdate.getBytes();
        }
        byte[] result = new byte[26];
        System.arraycopy("0001-01-01 00:00:00.000000".getBytes(), 0, result, 0, 26);
        return result;
    }

    static byte[] convertBoolean(Boolean val) {
        byte[] b = new byte[]{val != null && val != false ? (byte)1 : 0};
        return b;
    }

    @VisibleForTesting
    class DefineSchema {
        static final int TYPE_SCHEMA = 1;
        static final int TYPE_OPERATOR = 2;
        private int type = 0;
        private String name;
        private List<String> fieldList = new ArrayList<String>();
        private String typeName;
        private String schemaName;

        DefineSchema(String operatorName, String typeName, String schemaName) {
            this.name = operatorName;
            this.typeName = typeName;
            this.schemaName = schemaName;
            this.type = 2;
        }

        DefineSchema(String tableName) {
            this.name = tableName;
            this.type = 1;
        }

        private void addField(String name, String value) {
            StringBuffer item = new StringBuffer("VARCHAR " + name);
            if (value != null && !value.equals("")) {
                item.append(" = '" + value + "'");
                this.fieldList.add(item.toString());
            }
        }

        private void addField(String name, int valueType, int len) throws KettleException {
            String type = null;
            switch (valueType) {
                case 2: {
                    type = "VARCHAR(" + len + ")";
                    break;
                }
                case 5: {
                    type = "BIGINT";
                    break;
                }
                case 6: {
                    type = "FLOAT";
                    break;
                }
                case 3: {
                    type = "TIMESTAMP(6)";
                    break;
                }
                case 1: {
                    type = "FLOAT";
                    break;
                }
                case 4: {
                    type = "BYTEINT";
                    break;
                }
                default: {
                    throw new KettleException(BaseMessages.getString((Class)PKG, (String)"TeraDataBulkLoaderMeta.Exception.UnhandledType", (String[])new String[0]));
                }
            }
            this.fieldList.add(name + "     " + type);
        }

        public String toString() {
            StringBuffer cmd = new StringBuffer();
            switch (this.type) {
                case 1: {
                    cmd.append("DEFINE SCHEMA " + this.name);
                    break;
                }
                case 2: {
                    cmd.append("DEFINE OPERATOR " + this.name + "\nTYPE " + this.typeName + (this.schemaName != null ? "\nSCHEMA " + this.schemaName : "") + "\nATTRIBUTES");
                }
            }
            cmd.append("\n  (\n");
            for (int i = 0; i < this.fieldList.size(); ++i) {
                cmd.append("     " + this.fieldList.get(i));
                if (i < this.fieldList.size() - 1) {
                    cmd.append(",");
                }
                cmd.append("\n");
            }
            cmd.append("  );\n");
            return cmd.toString();
        }
    }

    private class ApplyClause {
        private List<String> fieldList = new ArrayList<String>();

        ApplyClause() {
        }

        private void addClause(String c) {
            if (!Const.isEmpty((String)c)) {
                this.fieldList.add(c);
            }
        }

        public String toString() {
            StringBuffer cmd = new StringBuffer("APPLY \n");
            for (int i = 0; i < this.fieldList.size(); ++i) {
                cmd.append("     " + TeraDataBulkLoaderRoutines.this.paren(this.fieldList.get(i)));
                if (i < this.fieldList.size() - 1) {
                    cmd.append(",");
                }
                cmd.append("\n");
            }
            return cmd.toString();
        }
    }
}

