/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.annotation;

import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.refinery.publish.util.ObjectUtils;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.annotation.ModelAnnotationMeta;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.trans.steps.annotation.BaseAnnotationStepDialog;
import org.pentaho.di.ui.trans.steps.annotation.WarningDialog;
import org.pentaho.di.ui.trans.steps.common.LocalLinkedComposite;
import org.pentaho.di.ui.trans.steps.common.ModelAnnotationEvent;
import org.pentaho.di.ui.trans.steps.common.ModelAnnotationsTableComposite;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public class ModelAnnotationDialog
extends BaseAnnotationStepDialog {
    private static final Class<?> PKG = ModelAnnotationMeta.class;
    private ModelAnnotationMeta input;
    private Button wHelp;
    private LocalLinkedComposite wLocalLinked;
    private ModelAnnotationsTableComposite tableComposite;
    private Button bLocal;
    private Button bLinked;
    private Listener lsLinked;
    private Listener lsLocal;

    public ModelAnnotationDialog(Shell parent, Object in, TransMeta transMeta, String stepname) {
        super(parent, (StepMetaInterface)in, transMeta, stepname);
        this.input = (ModelAnnotationMeta)this.baseStepMeta;
    }

    @Override
    protected void initializeListeners() {
        super.initializeListeners();
        this.lsLinked = new Listener(){

            public void handleEvent(Event event) {
                ModelAnnotationDialog.this.bLocal.setSelection(false);
                ModelAnnotationDialog.this.getWGroups().setEditable(true);
                ModelAnnotationDialog.this.setShareEnabled(true);
                if (ModelAnnotationDialog.this.tableComposite.getTable().getItemCount() > 0) {
                    ModelAnnotationDialog.this.getWGroups().setText("");
                    ModelAnnotationDialog.this.getWGroups().getCComboWidget().setFocus();
                    ModelAnnotationDialog.this.getWGroups().getCComboWidget().setSelection(new Point(0, 0));
                } else if (ModelAnnotationDialog.this.getWGroups().getItemCount() > 0) {
                    ModelAnnotationDialog.this.getWGroups().select(0);
                    ModelAnnotationDialog.this.populateTableFromMetastore();
                    ModelAnnotationDialog.this.onModelAnnotationDirty();
                    ModelAnnotationDialog.this.wLocalLinked.setEnableAddCopyButtons(true);
                }
            }
        };
        this.lsLocal = new Listener(){

            public void handleEvent(Event event) {
                ModelAnnotationDialog.this.bLocal.setSelection(false);
                Listener lsWarningYes = new Listener(){

                    public void handleEvent(Event event) {
                        ModelAnnotationDialog.this.bLocal.setSelection(true);
                        ModelAnnotationDialog.this.bLinked.setSelection(false);
                        ModelAnnotationDialog.this.wLocalLinked.setEnabled(false);
                        ModelAnnotationDialog.this.populateCategories(null, false);
                        ModelAnnotationDialog.this.onModelAnnotationDirty();
                        ModelAnnotationDialog.this.tableComposite.getData().setSharedDimension(false);
                        ModelAnnotationDialog.this.setAnnotationsEditEnabled(true);
                    }
                };
                Listener lsWarningNo = new Listener(){

                    public void handleEvent(Event event) {
                        ModelAnnotationDialog.this.setShareEnabled(true);
                    }
                };
                LinkedHashMap<String, Listener> listenerMap = new LinkedHashMap<String, Listener>();
                listenerMap.put(BaseMessages.getString((Class)PKG, (String)"System.Button.No", (String[])new String[0]), lsWarningNo);
                listenerMap.put(BaseMessages.getString((Class)PKG, (String)"ModelAnnotation.LocalWarning.Yes", (String[])new String[0]), lsWarningYes);
                WarningDialog warningDialog = new WarningDialog(ModelAnnotationDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"ModelAnnotation.LocalWarning.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"ModelAnnotation.LocalWarning.Message", (String[])new String[0]), listenerMap);
                warningDialog.open();
            }
        };
    }

    private Control createLocalLinked(Control topWidget) {
        this.wLocalLinked = new LocalLinkedComposite((Composite)this.shell, 0);
        this.wLocalLinked.setLocalizationPkg(PKG);
        this.wLocalLinked.setLog(this.log);
        this.wLocalLinked.setVariables((VariableSpace)this.transMeta);
        this.wLocalLinked.createWidgets();
        this.bLocal = this.wLocalLinked.getbLocal();
        this.bLinked = this.wLocalLinked.getbShared();
        this.bLinked.addListener(13, this.lsLinked);
        this.bLocal.addListener(13, this.lsLocal);
        this.wLocalLinked.setAddGroupListener(this.lsAddGroup);
        this.wLocalLinked.setCopyGroupListener(this.lsCopyGroup);
        this.getWGroups().getCComboWidget().addListener(13, this.lsGroups);
        this.getWGroups().getCComboWidget().addListener(16, this.lsCheckForVariables);
        this.getWGroups().getCComboWidget().addListener(2, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 13) {
                    ModelAnnotationDialog.this.wDescription.setFocus();
                }
            }
        });
        this.getWGroups().getCComboWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (StringUtils.equals((String)ModelAnnotationDialog.this.getWGroups().getText(), (String)ModelAnnotationDialog.this.getTableComposite().getData().getName())) {
                    ModelAnnotationDialog.this.wLocalLinked.setEnableAddCopyButtons(true);
                } else {
                    ModelAnnotationDialog.this.wLocalLinked.setEnableAddCopyButtons(false);
                }
            }
        });
        this.positionControl(this.wLocalLinked, topWidget);
        return this.wLocalLinked;
    }

    private void positionControl(Composite composite, Control topWidget) {
        FormData fData = new FormData();
        fData.top = new FormAttachment(topWidget, 17, 128);
        fData.left = new FormAttachment(0, 12);
        fData.right = new FormAttachment(topWidget, 0, 131072);
        composite.setLayoutData((Object)fData);
        this.props.setLook((Control)composite);
    }

    private void createFieldsTable(Control topWidget) {
        this.tableComposite = new ModelAnnotationsTableComposite((Composite)this.shell, topWidget, (Control)this.wBottomHorizontalSeparator){

            @Override
            protected void onDelete() {
                ModelAnnotationDialog.this.deleteAnnotation();
            }

            @Override
            protected void onEdit() {
                ModelAnnotationDialog.this.editAnnotation();
            }

            @Override
            protected void onGetFields() {
                ModelAnnotationDialog.this.getFields();
            }

            @Override
            protected void onItemSelect() {
                this.toggleDeleteEditButtons();
            }

            @Override
            protected void onItemDoubleClick() {
                ModelAnnotationDialog.this.editAnnotation();
            }

            @Override
            protected boolean supportsCalculatedMeasure() {
                return Boolean.TRUE;
            }

            @Override
            protected void onCreateCalculatedMeasure() {
                ModelAnnotationDialog.this.createCalculatedMeasure();
            }
        };
        this.tableComposite.setLocalizationPkg(PKG);
        this.tableComposite.setLog(this.log);
        this.tableComposite.createWidgets();
    }

    public void createCalculatedMeasure() {
        final ModelAnnotationGroup groupCopy = ObjectUtils.deepClone(this.getTableComposite().getData());
        this.getTableComposite().createCalculatedMeasure(this.shell, this.input, this.transMeta, this.stepname, this.getMetaStore(), new Listener(){

            public void handleEvent(Event event) {
                if (event instanceof ModelAnnotationEvent) {
                    ModelAnnotationEvent e = (ModelAnnotationEvent)event;
                    if (!ModelAnnotationDialog.this.modelAnnotationDirty) {
                        ModelAnnotationDialog.this.setDirtyFlag(groupCopy, e.getModelAnnotations());
                    }
                    ModelAnnotationDialog.this.populateTable(e.getModelAnnotations());
                }
            }
        });
    }

    @Override
    protected Button createHelpButton(Shell shell, StepMeta stepMeta, PluginInterface plugin) {
        this.wHelp = super.createHelpButton(shell, stepMeta, plugin);
        FormData fdHelp = new FormData();
        fdHelp.bottom = new FormAttachment(100, -10);
        fdHelp.left = new FormAttachment(0, 10);
        this.wHelp.setLayoutData((Object)fdHelp);
        return this.wHelp;
    }

    @Override
    protected void createContent(Control topWidget) {
        Control top = topWidget;
        top = this.createLocalLinked(top);
        top = this.createDescription(top);
        this.createFieldsTable(top);
        this.resizeSummaryColumn(this.tableComposite);
    }

    @Override
    protected ModelAnnotationManager getModelAnnotationManger() {
        return new ModelAnnotationManager();
    }

    @Override
    protected ModelAnnotationsTableComposite getTableComposite() {
        return this.tableComposite;
    }

    @Override
    protected ComboVar getWGroups() {
        return this.wLocalLinked.getwGroups();
    }

    @Override
    protected String getSelectedModelAnnotationGroupName() {
        return this.getWGroups().getText();
    }

    @Override
    protected void afterOpen() {
        this.populateCategories(this.envSub(this.input.getModelAnnotationCategory()), false);
        if (StringUtils.isBlank((String)this.envSub(this.input.getModelAnnotationCategory()))) {
            this.populateTable(this.input.getModelAnnotations());
            this.wLocalLinked.setEnableAddCopyButtons(false);
        } else {
            this.populateTableFromMetastore();
            if (StringUtil.isVariable((String)this.input.getModelAnnotationCategory())) {
                this.setAnnotationsEditEnabled(false);
                this.wLocalLinked.setEnableAddCopyButtons(false);
            } else {
                this.wLocalLinked.setEnableAddCopyButtons(true);
                this.getWGroups().setEditable(true);
            }
        }
        this.wApply.setEnabled(false);
    }

    @Override
    protected void populateCategories(String selectedCategory, boolean sharedDimensions) {
        boolean isShared = selectedCategory != null;
        this.bLocal.setSelection(!isShared);
        this.bLinked.setSelection(isShared);
        this.setShareEnabled(isShared);
        super.populateCategories(selectedCategory, sharedDimensions);
    }

    @Override
    protected void onModelAnnotationDirty() {
        super.onModelAnnotationDirty();
        this.wLocalLinked.setEnableAddCopyButtons(false);
        if (StringUtils.equals((String)this.getWGroups().getText(), (String)this.input.getModelAnnotationCategory())) {
            this.getWGroups().setEditable(false);
        }
    }

    @Override
    protected boolean applyChanges() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return false;
        }
        if (this.bLinked.getSelection() && StringUtils.isBlank((String)this.getWGroups().getText())) {
            this.showError(BaseMessages.getString(PKG, (String)"ModelAnnotation.ModelAnnotationGroupMissingName.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ModelAnnotation.ModelAnnotationGroupMissingName.Message", (String[])new String[0]));
            return false;
        }
        try {
            if (this.bLinked.getSelection()) {
                this.input.checkValidName(this.getWGroups().getText());
            }
        }
        catch (Exception e) {
            this.showError(BaseMessages.getString(PKG, (String)"ModelAnnotation.MetaStoreSaveError.Title", (String[])new String[0]), e.getLocalizedMessage());
            return false;
        }
        boolean prevChanged = this.input.hasChanged();
        String prevStepName = this.wStepname.getText();
        ModelAnnotationGroup prevAnnotations = ObjectUtils.deepClone(this.input.getModelAnnotations());
        this.input.setChanged(this.input.hasChanged() || this.changed || !this.stepname.equals(this.wStepname.getText()) || !this.input.getModelAnnotations().equals((Object)this.tableComposite.getData()) || !StringUtils.equals((String)this.input.getModelAnnotations().getDescription(), (String)this.wDescription.getText()));
        this.stepname = this.wStepname.getText();
        this.input.setModelAnnotations(this.tableComposite.getData());
        this.input.getModelAnnotations().setName(this.getWGroups().getText());
        this.input.getModelAnnotations().setDescription(this.wDescription.getText());
        if (this.bLinked.getSelection()) {
            String prevCategory = this.input.getModelAnnotationCategory();
            this.input.setModelAnnotationCategory(this.getWGroups().getText());
            if (!StringUtil.isVariable((String)this.getWGroups().getText())) {
                try {
                    this.input.saveToMetaStore(this.getMetaStore());
                }
                catch (Exception e) {
                    this.showError(BaseMessages.getString(PKG, (String)"ModelAnnotation.MetaStoreSaveError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ModelAnnotation.MetaStoreSaveError.Message", (String[])new String[]{e.getLocalizedMessage()}));
                    this.input.setChanged(prevChanged);
                    this.stepname = prevStepName;
                    this.input.setModelAnnotations(prevAnnotations);
                    this.input.setModelAnnotationCategory(prevCategory);
                    return false;
                }
                this.wLocalLinked.setEnableAddCopyButtons(true);
                this.getWGroups().setEditable(true);
            }
            this.deleteStaleGroups(false);
        } else {
            this.input.setModelAnnotationCategory(null);
        }
        return true;
    }

    public void setShareEnabled(boolean enabled) {
        this.wLocalLinked.setEnabled(enabled);
        this.bLinked.setSelection(enabled);
        this.bLocal.setSelection(!enabled);
    }

    @Override
    protected void onLinkAnnotations() {
        this.onModelAnnotationDirty();
        this.setShareEnabled(true);
    }

    @Override
    protected void onDiscardAll() {
        this.onModelAnnotationDirty();
        this.setShareEnabled(true);
    }

    @Override
    protected String getDialogTitle() {
        return BaseMessages.getString(PKG, (String)"ModelAnnotation.Dialog.Title", (String[])new String[0]);
    }

    @Override
    protected String getStepName() {
        return BaseMessages.getString(PKG, (String)"ModelAnnotation.StepName", (String[])new String[0]);
    }

    @Override
    protected Image getImageIcon() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"ModelAnnotation.svg", (int)48, (int)48);
    }

    @Override
    protected String missingMessageKey() {
        return "ModelAnnotation.MissingAnnotationGroup.Message";
    }

    @Override
    protected String missingTitleKey() {
        return "ModelAnnotation.MissingAnnotationGroup.Title";
    }
}

