/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.annotation;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.gui.SpoonInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.refinery.publish.util.ObjectUtils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.annotation.BaseAnnotationMeta;
import org.pentaho.di.trans.steps.annotation.ModelAnnotationMeta;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.common.ModelAnnotationEvent;
import org.pentaho.metastore.api.IMetaStore;

public abstract class ModelAnnotationActionDialog
extends BaseStepDialog
implements StepDialogInterface {
    protected static Class<?> PKG = ModelAnnotationMeta.class;
    protected final int margin = 4;
    protected final int LEFT_MARGIN_OFFSET = 10;
    protected final int RIGHT_MARGIN_OFFSET = -10;
    protected final int SHELL_MIN_WIDTH = 500;
    protected final int SHELL_MIN_HEIGHT = 400;
    protected ModifyListener lsMod;
    protected Label wBottomHorizontalSeparator;
    private Button wPrevious;
    private Button wNext;
    private Button wHelp;
    private Listener lsPrevious;
    private Listener lsNext;
    private Listener lsClose;
    private ModelAnnotation<AnnotationType> modelAnnotation;
    private BaseAnnotationMeta modelAnnotationMeta;
    private ModelAnnotationGroup modelAnnotations;
    private ModelAnnotationGroup modelAnnotationsOrigCopy;
    private int selectionIndex;
    private boolean saved;

    public ModelAnnotationActionDialog(Shell parent, BaseAnnotationMeta baseStepMeta, TransMeta transMeta, String stepname, IMetaStore metaStore) {
        super(parent, (StepMetaInterface)baseStepMeta, transMeta, stepname);
        this.modelAnnotationMeta = baseStepMeta;
        this.setMetaStore(metaStore);
    }

    private void configureShell() {
        this.shell = new Shell(this.getParent(), 68848);
        FormLayout shellLayout = new FormLayout();
        shellLayout.marginWidth = 5;
        shellLayout.marginHeight = 5;
        this.shell.setLayout((Layout)shellLayout);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.modelAnnotationMeta);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ModelAnnotation.ModelAnnotationActionDialog.Title", (String[])new String[0]));
        this.shell.setMinimumSize(500, 400);
        this.shell.setSize(500, 400);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (ModelAnnotationActionDialog.this.lsClose != null) {
                    ModelAnnotationActionDialog.this.lsClose.handleEvent((Event)new ModelAnnotationEvent(ModelAnnotationActionDialog.this.getModelAnnotations(), !ModelAnnotationActionDialog.this.saved));
                }
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent de) {
                if (ModelAnnotationActionDialog.this.lsClose != null) {
                    ModelAnnotationActionDialog.this.lsClose.handleEvent((Event)new ModelAnnotationEvent(ModelAnnotationActionDialog.this.getModelAnnotations(), !ModelAnnotationActionDialog.this.saved));
                }
            }
        });
    }

    protected void initializeListeners() {
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelAnnotationActionDialog.this.modelAnnotationMeta.setChanged();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                ModelAnnotationActionDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                ModelAnnotationActionDialog.this.cancel();
            }
        };
        this.lsPrevious = new Listener(){

            public void handleEvent(Event e) {
                ModelAnnotationActionDialog.this.previous();
            }
        };
        this.lsNext = new Listener(){

            public void handleEvent(Event e) {
                ModelAnnotationActionDialog.this.next();
            }
        };
    }

    private void initializeModel() {
        try {
            this.modelAnnotationsOrigCopy = this.modelAnnotations;
            this.modelAnnotations = ObjectUtils.deepClone(this.modelAnnotations);
            if (this.modelAnnotations == null) {
                this.modelAnnotations = new ModelAnnotationGroup();
            }
            this.modelAnnotation = (ModelAnnotation)this.modelAnnotations.get(this.getSelectionIndex());
            if (this.modelAnnotation == null) {
                throw new Exception("Model Annotation does not exist");
            }
        }
        catch (Exception e) {
            this.modelAnnotation = new ModelAnnotation();
            this.modelAnnotations.add(this.modelAnnotation);
            this.setSelectionIndex(this.modelAnnotations.size());
        }
    }

    public String open() {
        this.initializeModel();
        this.configureShell();
        this.initializeListeners();
        this.createOkCancelButtons();
        this.createWidgets();
        this.populateDialog();
        this.shell.open();
        this.modelAnnotationMeta.setChanged(this.changed);
        while (!this.shell.isDisposed()) {
            if (this.getParent().getDisplay().readAndDispatch()) continue;
            this.getParent().getDisplay().sleep();
        }
        return this.stepname;
    }

    private void previous() {
        try {
            this.persistAnnotationProperties();
            if (this.getSelectionIndex() <= 0) {
                this.setSelectionIndex(this.modelAnnotations.size());
            }
            this.modelAnnotation = (ModelAnnotation)this.modelAnnotations.get(--this.selectionIndex);
            this.populateDialog();
        }
        catch (ModelerException me) {
            this.showError(BaseMessages.getString(PKG, (String)"ModelAnnotation.ModelAnnotationActionDialog.ValidationError.Title", (String[])new String[0]), me.getMessage());
        }
    }

    private void next() {
        try {
            this.persistAnnotationProperties();
            if (this.getSelectionIndex() >= this.modelAnnotations.size() - 1) {
                this.setSelectionIndex(-1);
            }
            this.modelAnnotation = (ModelAnnotation)this.modelAnnotations.get(++this.selectionIndex);
            this.populateDialog();
        }
        catch (ModelerException me) {
            this.showError(BaseMessages.getString(PKG, (String)"ModelAnnotation.ModelAnnotationActionDialog.ValidationError.Title", (String[])new String[0]), me.getMessage());
        }
    }

    private void cancel() {
        this.saved = false;
        this.dispose();
    }

    private void ok() {
        try {
            this.persistAnnotationProperties();
            this.saved = true;
            this.dispose();
        }
        catch (ModelerException me) {
            this.showError(BaseMessages.getString(PKG, (String)"ModelAnnotation.ModelAnnotationActionDialog.ValidationError.Title", (String[])new String[0]), me.getMessage());
        }
    }

    private void createOkCancelButtons() {
        this.wBottomHorizontalSeparator = new Label((Composite)this.shell, 258);
        FormData fdSepator = new FormData();
        fdSepator.left = new FormAttachment(0, 8);
        fdSepator.right = new FormAttachment(100, -10);
        fdSepator.bottom = new FormAttachment((Control)this.wHelp, -10);
        this.wBottomHorizontalSeparator.setLayoutData((Object)fdSepator);
        this.wPrevious = new Button((Composite)this.shell, 8);
        this.wPrevious.setText(BaseMessages.getString(PKG, (String)"ModelAnnotation.ModelAnnotationActionDialog.Button.Previous", (String[])new String[0]));
        FormData fdPrevious = new FormData();
        fdPrevious.top = new FormAttachment((Control)this.wBottomHorizontalSeparator, 10);
        fdPrevious.right = new FormAttachment(50, -2);
        this.wPrevious.setLayoutData((Object)fdPrevious);
        this.wNext = new Button((Composite)this.shell, 8);
        this.wNext.setText(BaseMessages.getString(PKG, (String)"ModelAnnotation.ModelAnnotationActionDialog.Button.Next", (String[])new String[0]));
        FormData fdNext = new FormData();
        fdNext.top = new FormAttachment((Control)this.wBottomHorizontalSeparator, 10);
        fdNext.left = new FormAttachment(50, 2);
        this.wNext.setLayoutData((Object)fdNext);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.setAlignment(0x1000000);
        FormData fdCancel = new FormData();
        fdCancel.top = new FormAttachment((Control)this.wBottomHorizontalSeparator, 10);
        fdCancel.right = new FormAttachment(100, -10);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOK.setAlignment(0x1000000);
        FormData fdOK = new FormData();
        fdOK.top = new FormAttachment((Control)this.wBottomHorizontalSeparator, 10);
        fdOK.right = new FormAttachment((Control)this.wCancel, -4);
        this.wOK.setLayoutData((Object)fdOK);
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.wPrevious.addListener(13, this.lsPrevious);
        this.wNext.addListener(13, this.lsNext);
    }

    protected Button createHelpButton(Shell shell, StepMeta stepMeta, PluginInterface plugin) {
        this.wHelp = super.createHelpButton(shell, stepMeta, plugin);
        return this.wHelp;
    }

    public int getSelectionIndex() {
        return this.selectionIndex;
    }

    public void setSelectionIndex(int selectionIndex) {
        this.selectionIndex = selectionIndex;
    }

    public ModelAnnotationGroup getModelAnnotations() {
        if (this.saved) {
            return this.modelAnnotations;
        }
        return this.modelAnnotationsOrigCopy;
    }

    public ModelAnnotationGroup getModifiedModelAnnotations() {
        return this.modelAnnotations;
    }

    public void setModelAnnotations(ModelAnnotationGroup modelAnnotations) {
        this.modelAnnotations = modelAnnotations;
    }

    public void onClose(Listener listener) {
        this.lsClose = listener;
    }

    public void showInfo(String title, String message) {
        SpoonInterface spoon = this.getSpoon();
        spoon.messageBox(message, title, false, 3);
    }

    public void showError(String title, String message) {
        SpoonInterface spoon = this.getSpoon();
        spoon.messageBox(message, title, false, 2);
    }

    protected SpoonInterface getSpoon() {
        return SpoonFactory.getInstance();
    }

    protected abstract void createWidgets();

    protected abstract void populateDialog();

    protected abstract void persistAnnotationProperties() throws ModelerException;

    protected ModelAnnotation<AnnotationType> getModelAnnotation() {
        return this.modelAnnotation;
    }

    protected void setModelAnnotation(ModelAnnotation<AnnotationType> modelAnnotation) {
        this.modelAnnotation = modelAnnotation;
    }
}

