/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.publish;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.refinery.publish.agilebi.ModelServerPublish;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.publish.JobEntryDatasourcePublish;
import org.pentaho.di.job.entries.publish.PublishService;
import org.pentaho.di.job.entries.publish.exception.DuplicateDataSourceException;

public class DatasourcePublishService
implements PublishService {
    private static Class<?> PKG = JobEntryDatasourcePublish.class;
    private static final String METADATA_EXTENSION = ".xmi";
    private static final String ENCODING = "UTF-8";
    private LogChannelInterface log;

    public DatasourcePublishService(LogChannelInterface log) {
        this.log = log;
    }

    @Override
    public void publishDatabaseMeta(ModelServerPublish modelServerPublish, DatabaseMeta databaseMeta, boolean forceOverride) throws KettleException {
        if (this.isKettleThinLocal(databaseMeta)) {
            throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Publish.LocalPentahoDataService", new String[0]));
        }
        if (this.isKettleThin(databaseMeta)) {
            databaseMeta.setForcingIdentifiersToLowerCase(false);
        }
        modelServerPublish.setDatabaseMeta(databaseMeta);
        DatabaseConnection connection = modelServerPublish.connectionNameExists(databaseMeta.getName());
        try {
            boolean success = forceOverride ? (connection != null ? modelServerPublish.publishDataSource(true, connection.getId()) : modelServerPublish.publishDataSource(false, null)) : modelServerPublish.publishDataSource(false, connection != null ? connection.getId() : null);
            if (!success) {
                throw new Exception(this.getMsg("JobEntryDatasourcePublish.Publish.DBConnection.Failed", databaseMeta.getName()));
            }
        }
        catch (KettleException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        this.log.logBasic(this.getMsg("JobEntryDatasourcePublish.Publish.DBConnection.Success", databaseMeta.getName()));
    }

    protected void deleteDatabaseMeta(ModelServerPublish modelServerPublish, DatabaseMeta databaseMeta) throws KettleException {
        if (this.isKettleThinLocal(databaseMeta)) {
            throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Publish.LocalPentahoDataService", new String[0]));
        }
        DatabaseConnection connection = modelServerPublish.connectionNameExists(databaseMeta.getName());
        try {
            boolean success = true;
            if (connection != null) {
                success = modelServerPublish.deleteConnection(connection.getName());
            }
            if (!success) {
                throw new Exception(this.getMsg("JobEntryDatasourcePublish.Delete.DBConnection.Failed", databaseMeta.getName()));
            }
        }
        catch (KettleException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        this.log.logBasic(this.getMsg("JobEntryDatasourcePublish.Delete.DBConnection.Success", databaseMeta.getName()));
    }

    protected void deleteXMI(ModelServerPublish modelServerPublish, String modelName, String dswFlag) throws KettleException {
        try {
            boolean success = true;
            success = dswFlag != null && dswFlag.equalsIgnoreCase("true") ? modelServerPublish.deleteDSWXmi(this.checkDswId(modelName)) : modelServerPublish.deleteMetadataXmi(modelName);
            if (!success) {
                throw new Exception(this.getMsg("JobEntryDatasourcePublish.Delete.XMI.Failed", modelName));
            }
        }
        catch (KettleException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        this.log.logBasic(this.getMsg("JobEntryDatasourcePublish.Delete.XMI.Success", modelName));
    }

    protected String checkDswId(String modelName) {
        if (!modelName.endsWith(METADATA_EXTENSION)) {
            if (StringUtils.endsWithIgnoreCase((String)modelName, (String)METADATA_EXTENSION)) {
                modelName = StringUtils.removeEndIgnoreCase((String)modelName, (String)METADATA_EXTENSION);
            }
            modelName = modelName + METADATA_EXTENSION;
        }
        return modelName;
    }

    @Override
    public void publishMondrianSchema(String modelName, String mondrianSchema, String mondrianDatasource, ModelServerPublish modelServerPublish, boolean forceOverride) throws KettleException {
        if (mondrianSchema == null || mondrianDatasource == null) {
            return;
        }
        ByteArrayInputStream mondrianInputStream = null;
        try {
            mondrianInputStream = new ByteArrayInputStream(mondrianSchema.getBytes(ENCODING));
            modelServerPublish.setForceOverwrite(forceOverride);
            int status = modelServerPublish.publishMondrianSchema(mondrianInputStream, modelName, mondrianDatasource, forceOverride);
            if (status != 3) {
                throw new Exception(this.getMsg("JobEntryDatasourcePublish.Publish.Mondrian.Failed", modelName));
            }
        }
        catch (Exception e) {
            try {
                throw new KettleException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(mondrianInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)mondrianInputStream);
        this.log.logBasic(this.getMsg("JobEntryDatasourcePublish.Publish.Mondrian.Success", modelName));
    }

    @Override
    public void publishMetadataXmi(String modelName, String xmiString, ModelServerPublish modelServerPublish, boolean forceOverride) throws KettleException {
        if (xmiString == null) {
            return;
        }
        ByteArrayInputStream xmiInputStream = null;
        try {
            xmiInputStream = new ByteArrayInputStream(xmiString.getBytes(ENCODING));
            modelServerPublish.setForceOverwrite(forceOverride);
            int status = modelServerPublish.publishMetaDataFile(xmiInputStream, modelName);
            if (status != 3) {
                throw new Exception(this.getMsg("JobEntryDatasourcePublish.Publish.Metadata.Failed", modelName));
            }
        }
        catch (Exception e) {
            try {
                throw new KettleException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(xmiInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)xmiInputStream);
        this.log.logBasic(this.getMsg("JobEntryDatasourcePublish.Publish.Metadata.Success", modelName));
    }

    @Override
    public void publishDswXmi(String modelName, String xmiString, ModelServerPublish modelServerPublish, boolean forceOverride) throws KettleException {
        if (xmiString == null) {
            return;
        }
        InputStream xmiInputStream = null;
        try {
            xmiInputStream = IOUtils.toInputStream((String)xmiString, (String)ENCODING);
            modelServerPublish.setForceOverwrite(forceOverride);
            int status = modelServerPublish.publishDsw(xmiInputStream, this.checkDswId(modelName));
            if (status == 4) {
                throw new DuplicateDataSourceException(this.getMsg("JobEntryDatasourcePublish.Publish.Dsw.Conflict", modelName));
            }
            if (status != 3) {
                throw new Exception(this.getMsg("JobEntryDatasourcePublish.Publish.Dsw.Failed", modelName));
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)xmiInputStream);
        }
        this.log.logBasic(this.getMsg("JobEntryDatasourcePublish.Publish.Dsw.Success", modelName));
    }

    private boolean isKettleThinLocal(DatabaseMeta databaseMeta) {
        return this.isKettleThin(databaseMeta) && "true".equals(databaseMeta.getExtraOptions().get("KettleThin.local"));
    }

    private boolean isKettleThin(DatabaseMeta databaseMeta) {
        return "KettleThin".equals(databaseMeta.getDatabaseInterface().getPluginId());
    }

    private String getMsg(String key, String ... parameters) {
        return BaseMessages.getString(PKG, (String)key, (String[])parameters);
    }
}

