/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery.publish.util;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Logger;

public class ObjectUtils {
    private static Logger logger = Logger.getLogger(ObjectUtils.class.getName());

    public static <T> T deepClone(T object) {
        T ret;
        if (object == null) {
            return null;
        }
        if (object instanceof Serializable && (ret = ObjectUtils.cloneSerialize(object)) != null) {
            return ret;
        }
        try {
            String xml = ObjectUtils.toXml(object);
            return (T)ObjectUtils.fromXml(xml);
        }
        catch (Exception ex) {
            logger.severe(ex.getMessage());
            throw new RuntimeException(ex);
        }
    }

    protected static Object fromXml(String xml) {
        ByteArrayInputStream is = null;
        try (XMLDecoder decoder = null;){
            is = new ByteArrayInputStream(xml.getBytes());
            decoder = new XMLDecoder(is);
            Object ret = decoder.readObject();
            is.close();
            Object object = ret;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> T cloneSerialize(T object) {
        ByteArrayInputStream is = null;
        ObjectInputStream ois = null;
        ObjectOutputStream oos = null;
        ByteArrayOutputStream out = null;
        try {
            Object ret;
            out = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(out);
            oos.writeObject(object);
            oos.flush();
            is = new ByteArrayInputStream(out.toByteArray());
            ois = new ObjectInputStream(is);
            Object object2 = ret = ois.readObject();
            return (T)object2;
        }
        catch (IOException | ClassNotFoundException | RuntimeException ex) {
            logger.severe(ex.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex) {
                logger.severe("Unalbe to close resource");
            }
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception ex) {
                logger.severe("Unalbe to close resource");
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex) {
                logger.severe("Unalbe to close resource");
            }
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception ex) {
                logger.severe("Unalbe to close resource");
            }
        }
        return null;
    }

    public static String toXml(Object object) {
        try (XMLEncoder encoder = null;){
            if (object != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                encoder = new XMLEncoder(out);
                encoder.writeObject(object);
                encoder.flush();
                out.close();
                String string = out.toString();
                return string;
            }
        }
        return null;
    }

    public static void logInfo(Object object) {
        if (object != null) {
            try {
                logger.info(ObjectUtils.toXml(object));
            }
            catch (RuntimeException ex) {
                logger.info(object.toString());
            }
        }
    }
}

