/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery.publish.agilebi;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import javax.ws.rs.ext.Providers;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.service.DatabaseDialectService;
import org.pentaho.database.util.DatabaseTypeHelper;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.refinery.publish.agilebi.BiServerConnection;

public class ModelServerAction {
    protected BiServerConnection biServerConnection;
    private Client _client = null;
    protected DatabaseMeta databaseMeta;

    public ModelServerAction() {
    }

    public ModelServerAction(BiServerConnection serverConnection) {
        this.setBiServerConnection(serverConnection);
    }

    protected Client getClient() {
        if (this._client == null) {
            ClassLoader orig = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(Providers.class.getClassLoader());
                DefaultClientConfig clientConfig = new DefaultClientConfig();
                clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
                this._client = Client.create((ClientConfig)clientConfig);
            }
            finally {
                Thread.currentThread().setContextClassLoader(orig);
            }
        }
        return this._client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IDatabaseType getDatabaseType(DatabaseInterface databaseInterface) {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        IDatabaseType dbType = null;
        try {
            Thread.currentThread().setContextClassLoader(IDatabaseDialect.class.getClassLoader());
            DatabaseDialectService dds = new DatabaseDialectService(false);
            DatabaseTypeHelper dth = new DatabaseTypeHelper(dds.getDatabaseTypes());
            dbType = dth.getDatabaseTypeByShortName(databaseInterface.getPluginId());
            return dbType;
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
            return dbType;
        }
    }

    protected ClientResponse httpPut(WebResource.Builder builder) {
        return (ClientResponse)builder.put(ClientResponse.class);
    }

    protected ClientResponse httpPost(WebResource.Builder builder) {
        return (ClientResponse)builder.post(ClientResponse.class);
    }

    protected ClientResponse httpGet(WebResource.Builder builder) {
        return (ClientResponse)builder.get(ClientResponse.class);
    }

    protected ClientResponse httpDelete(WebResource.Builder builder) {
        return (ClientResponse)builder.delete(ClientResponse.class);
    }

    protected String getUrl(String path) {
        return this.biServerConnection.getUrl() + path;
    }

    protected WebResource getResource(String path) {
        return this.getClient().resource(this.getUrl(path));
    }

    public void setBiServerConnection(BiServerConnection biServerConnection) {
        this.biServerConnection = biServerConnection;
        this.setupClient(this.getClient(), biServerConnection);
    }

    protected void setupClient(Client client, BiServerConnection biServerConnection) {
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(biServerConnection.getUserId(), biServerConnection.getPassword()));
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public boolean isSuccess(ClientResponse response) {
        return response.getStatus() >= 200 && response.getStatus() < 300;
    }
}

