/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.pentaho.agilebi.modeler.BaseModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.geo.GeoContext;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.MainModelNode;
import org.pentaho.agilebi.modeler.nodes.RelationalModelNode;
import org.pentaho.agilebi.modeler.strategy.AutoModelStrategy;
import org.pentaho.agilebi.modeler.strategy.SimpleAutoModelStrategy;
import org.pentaho.agilebi.modeler.util.ModelerWorkspaceHelper;

public class RefineryModelerWorkspaceHelper
extends BaseModelerWorkspaceHelper
implements IModelerWorkspaceHelper {
    final ModelerWorkspaceHelper helper = new ModelerWorkspaceHelper("en_US");
    final GeoContext geoContext;

    public RefineryModelerWorkspaceHelper(GeoContext geoContext) {
        super("en_US");
        this.geoContext = geoContext;
        this.helper.setAutoModelStrategy((AutoModelStrategy)new SimpleAutoModelStrategy("en_US", this.geoContext));
    }

    public void autoModelFlat(ModelerWorkspace workspace) throws ModelerException {
        workspace.setGeoContext(this.geoContext);
        AutoModelStrategy strategy = this.getAutoModelStrategy();
        strategy.autoModelOlap(workspace, workspace.getModel());
        strategy.autoModelRelational(workspace, workspace.getRelationalModel());
    }

    public void autoModelFlatInBackground(ModelerWorkspace workspace) throws ModelerException {
        workspace.setGeoContext(this.geoContext);
        final ModelerWorkspace ws = workspace;
        final AutoModelStrategy strategy = this.getAutoModelStrategy();
        final Display display = Display.findDisplay((Thread)Thread.currentThread());
        Runnable worker = new Runnable(){

            @Override
            public void run() {
                final boolean prevChangeState = ws.isModelChanging();
                try {
                    MainModelNode node = ws.getModel();
                    node.setSupressEvents(true);
                    strategy.autoModelOlap(ws, node);
                }
                catch (ModelerException modelerException) {
                    // empty catch block
                }
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ws.getModel().setSupressEvents(false);
                        ws.setModelIsChanging(prevChangeState, true);
                        ws.setSelectedNode((AbstractMetaDataModelNode)ws.getModel());
                    }
                });
            }
        };
        new Thread(worker).start();
    }

    public void autoModelRelationalFlat(ModelerWorkspace workspace) throws ModelerException {
        this.helper.autoModelRelationalFlat(workspace);
    }

    public void autoModelRelationalFlatInBackground(final ModelerWorkspace workspace) throws ModelerException {
        final AutoModelStrategy strategy = this.getAutoModelStrategy();
        final Display display = Display.findDisplay((Thread)Thread.currentThread());
        Runnable worker = new Runnable(){

            @Override
            public void run() {
                final boolean prevChangeState = workspace.isModelChanging();
                try {
                    RelationalModelNode node = workspace.getRelationalModel();
                    node.setSupressEvents(true);
                    strategy.autoModelRelational(workspace, node);
                }
                catch (ModelerException modelerException) {
                    // empty catch block
                }
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        workspace.getRelationalModel().setSupressEvents(false);
                        workspace.setRelationalModelIsChanging(prevChangeState, true);
                        workspace.setSelectedRelationalNode((AbstractMetaDataModelNode)workspace.getRelationalModel());
                    }
                });
            }
        };
        new Thread(worker).start();
    }

    protected MainModelNode getMainModelNode(ModelerWorkspace workspace) {
        return new MainModelNode();
    }

    protected RelationalModelNode getRelationalModelNode(ModelerWorkspace workspace) {
        return new RelationalModelNode();
    }

    public void sortFields(List<AvailableField> availableFields) {
        Collections.sort(availableFields, new Comparator<AvailableField>(){

            @Override
            public int compare(AvailableField o1, AvailableField o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                String name1 = o1.getDisplayName();
                String name2 = o2.getDisplayName();
                if (name1 == null && name2 == null) {
                    return 0;
                }
                if (name1 == null) {
                    return -1;
                }
                if (name2 == null) {
                    return 1;
                }
                return name1.compareToIgnoreCase(name2);
            }
        });
    }

    public AutoModelStrategy getAutoModelStrategy() {
        AutoModelStrategy strategy = super.getAutoModelStrategy();
        if (strategy instanceof SimpleAutoModelStrategy) {
            ((SimpleAutoModelStrategy)strategy).setGeoContext(this.geoContext);
        }
        return strategy;
    }
}

