/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery.model;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.refinery.publish.agilebi.BiServerConnection;
import org.pentaho.di.core.refinery.publish.agilebi.ModelServerAction;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.util.XmiParser;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ModelServerFetcher
extends ModelServerAction {
    public ModelServerFetcher() {
    }

    public ModelServerFetcher(BiServerConnection serverConnection) {
        super(serverConnection);
    }

    public List<String> fetchDswList() throws AuthorizationException, ServerException {
        return this.fetchDatasourceIds(DataSourceType.DSW.getListPath());
    }

    public List<String> fetchAnalysisList() throws AuthorizationException, ServerException {
        return this.fetchDatasourceIds(DataSourceType.ANALYSIS.getListPath());
    }

    protected List<String> fetchDatasourceIds(String path) throws AuthorizationException, ServerException {
        WebResource listGet = this.getResource(path);
        ClientResponse response = this.httpGet(listGet.type("application/xml"));
        if (this.isSuccess(response)) {
            ArrayList<String> arrayList;
            InputStream input = null;
            try {
                input = (InputStream)response.getEntity(InputStream.class);
                InputSource source = new InputSource(input);
                if (Thread.currentThread().getContextClassLoader() == null) {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                }
                XPath xpath = XPathFactory.newInstance().newXPath();
                NodeList items = (NodeList)xpath.evaluate("/List/Item/text()", source, XPathConstants.NODESET);
                ArrayList<String> result = new ArrayList<String>(items.getLength());
                for (int i = 0; i < items.getLength(); ++i) {
                    result.add(items.item(i).getNodeValue());
                }
                arrayList = result;
            }
            catch (XPathExpressionException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)input);
            return arrayList;
        }
        switch (response.getStatus()) {
            case 401: {
                throw new AuthorizationException();
            }
        }
        throw new ServerException();
    }

    public String downloadAnalysisFile(String analysisId) throws KettleException, AuthorizationException, ServerException, UnsupportedEncodingException {
        String encodedId;
        try {
            encodedId = new URI(null, null, analysisId, null).getRawPath();
        }
        catch (URISyntaxException e) {
            throw new KettleException((Throwable)e);
        }
        ClientResponse response = (ClientResponse)this.getResource(DataSourceType.ANALYSIS.getDownloadPath(encodedId)).get(ClientResponse.class);
        if (this.isSuccess(response)) {
            if (response.getType().toString().equals("application/zip")) {
                String string;
                block15: {
                    ZipInputStream zipInputStream = this.extractFromZip("schema.xml", response);
                    try {
                        string = IOUtils.toString((InputStream)zipInputStream);
                        if (zipInputStream == null) break block15;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (zipInputStream != null) {
                                try {
                                    zipInputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new KettleException((Throwable)e);
                        }
                    }
                    zipInputStream.close();
                }
                return string;
            }
            return (String)response.getEntity(String.class);
        }
        switch (response.getStatus()) {
            case 401: {
                throw new AuthorizationException();
            }
        }
        throw new ServerException();
    }

    public Domain downloadDswFile(String dswId) throws KettleException, AuthorizationException, ServerException, UnsupportedEncodingException {
        String encodedId;
        try {
            encodedId = new URI(null, null, dswId, null).getRawPath();
        }
        catch (URISyntaxException e) {
            throw new KettleException((Throwable)e);
        }
        ClientResponse response = (ClientResponse)this.getResource(DataSourceType.DSW.getDownloadPath(encodedId)).get(ClientResponse.class);
        if (this.isSuccess(response)) {
            Domain domain;
            block14: {
                ZipInputStream zipInputStream = this.extractFromZip(dswId, response);
                try {
                    XmiParser parser = new XmiParser();
                    domain = parser.parseXmi((InputStream)zipInputStream);
                    if (zipInputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (zipInputStream != null) {
                            try {
                                zipInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new KettleException((Throwable)e);
                    }
                }
                zipInputStream.close();
            }
            return domain;
        }
        switch (response.getStatus()) {
            case 401: {
                throw new AuthorizationException();
            }
        }
        throw new ServerException();
    }

    private ZipInputStream extractFromZip(String fileName, ClientResponse response) throws KettleException {
        try {
            InputStream input = (InputStream)response.getEntity(InputStream.class);
            ZipInputStream zipin = new ZipInputStream(input);
            ZipEntry entry = zipin.getNextEntry();
            while (entry != null) {
                if (entry.getName().equals(fileName)) {
                    return zipin;
                }
                entry = zipin.getNextEntry();
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        throw new KettleException("file not found");
    }

    public static class AuthorizationException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static class ServerException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    private static final class DataSourceType
    extends Enum<DataSourceType> {
        public static final /* enum */ DataSourceType ANALYSIS = new DataSourceType("analysis");
        public static final /* enum */ DataSourceType DSW = new DataSourceType("dsw");
        private static final String DATASOURCE_PATH = "plugin/data-access/api/datasource";
        private final String listPath;
        private final String downloadPath;
        private static final /* synthetic */ DataSourceType[] $VALUES;

        public static DataSourceType[] values() {
            return (DataSourceType[])$VALUES.clone();
        }

        public static DataSourceType valueOf(String name) {
            return Enum.valueOf(DataSourceType.class, name);
        }

        private DataSourceType(String basePath) {
            this.listPath = StringUtils.join((Object[])new String[]{DATASOURCE_PATH, basePath, "ids"}, (String)"/");
            this.downloadPath = StringUtils.join((Object[])new String[]{DATASOURCE_PATH, basePath, "%s", "download"}, (String)"/");
        }

        public String getDownloadPath(String dataSourceId) {
            assert (!StringUtils.isEmpty((String)dataSourceId));
            return String.format(this.downloadPath, dataSourceId);
        }

        public String getListPath() {
            return this.listPath;
        }

        static {
            $VALUES = new DataSourceType[]{ANALYSIS, DSW};
        }
    }
}

