/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery.model;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.pentaho.di.core.ProvidesDatabaseConnectionInformation;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.build.JobEntryBuildModel;
import org.pentaho.di.job.entry.JobEntryBase;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class AnalysisModeler {
    private static final Class<?> PKG = JobEntryBuildModel.class;
    private JobEntryBase jobEntry;
    private ProvidesDatabaseConnectionInformation connectionInfo;
    private static Map<String, List<Integer>> analysisTypeMapping = new HashMap<String, List<Integer>>();

    public AnalysisModeler(JobEntryBase jobEntry, ProvidesDatabaseConnectionInformation connectionInfo) {
        this.jobEntry = jobEntry;
        this.connectionInfo = connectionInfo;
    }

    public String replaceTableAndSchemaNames(String schema, String modelName) throws KettleException {
        try {
            this.validateSDRSchema(schema);
            return this.transformSchema(schema, modelName, this.getTablename());
        }
        catch (TransformerConfigurationException e) {
            throw new KettleException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new KettleException((Throwable)e);
        }
    }

    private String transformSchema(String schema, String modelName, String tableName) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslt = new StreamSource(new StringReader(this.constructXsltForSwap(modelName, tableName)));
        Transformer transformer = factory.newTransformer(xslt);
        StreamSource text = new StreamSource(new StringReader(schema));
        StringWriter writer = new StringWriter();
        transformer.transform(text, new StreamResult(writer));
        return writer.toString();
    }

    private String constructXsltForSwap(String modelName, String tableName) {
        return "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:fn=\"http://www.w3.org/2005/xpath-functions\"><xsl:template match=\"@*|node()\">\n<xsl:copy>\n    <xsl:apply-templates select=\"@*|node()\"/>\n  </xsl:copy></xsl:template><xsl:template match=\"Table/@name\">    <xsl:attribute name=\"name\">" + tableName + "</xsl:attribute></xsl:template><xsl:template match=\"Schema/@name\">    <xsl:attribute name=\"name\">" + modelName + "</xsl:attribute></xsl:template><xsl:template match=\"Cube/@name\">    <xsl:attribute name=\"name\">" + modelName + "</xsl:attribute></xsl:template></xsl:stylesheet>";
    }

    private void validateSDRSchema(String schema) throws KettleException {
        try {
            this.validateSingleTable(schema);
            this.validateSingleCube(schema);
            this.validateColumns(schema);
        }
        catch (XPathException e) {
            throw new KettleException((Throwable)e);
        }
    }

    private void validateColumns(String schema) throws XPathExpressionException, KettleException {
        ArrayList<String> notFound = new ArrayList<String>();
        ArrayList<String> incompatibleTypes = new ArrayList<String>();
        List<ValueMetaInterface> fieldsInDatabase = this.getFieldsInDatabase();
        NodeList levelColumnAttributes = this.getNodeList(schema, "//Level | //Measure");
        for (int i = 0; i < levelColumnAttributes.getLength(); ++i) {
            Node node = levelColumnAttributes.item(i);
            Node schemaColumnNode = node.getAttributes().getNamedItem("column");
            String schemaColumn = schemaColumnNode.getTextContent();
            boolean foundColumn = false;
            for (ValueMetaInterface valueMetaInterface : fieldsInDatabase) {
                List<Integer> validTypes;
                if (!valueMetaInterface.getName().equals(schemaColumn)) continue;
                foundColumn = true;
                Node type = node.getAttributes().getNamedItem("type");
                if (type == null || (validTypes = analysisTypeMapping.get(type.getTextContent())).contains(valueMetaInterface.getType())) continue;
                incompatibleTypes.add(schemaColumnNode.getTextContent());
            }
            if (foundColumn) continue;
            notFound.add(schemaColumnNode.getTextContent());
        }
        if (!notFound.isEmpty() || !incompatibleTypes.isEmpty()) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AnalysisModeler.ColumnValidation", (String[])new String[]{this.msgIfNotEmpty(notFound, "AnalysisModeler.SelectModelColumnNotFound"), this.msgIfNotEmpty(incompatibleTypes, "AnalysisModeler.SelectModelColumnTypeMismatch")}));
        }
    }

    private String msgIfNotEmpty(ArrayList<String> notFound, String msgKey) {
        if (notFound.isEmpty()) {
            return "";
        }
        return BaseMessages.getString(PKG, (String)msgKey, (String[])new String[]{notFound.toString()});
    }

    private void validateSingleTable(String schema) throws XPathExpressionException, KettleException {
        NodeList tableNameAttributes = this.getNodeList(schema, "//Table/@name");
        if (!this.modelTablesAreSupported(tableNameAttributes)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AnalysisModeler.SelectModelErrorMultipleTables", (String[])new String[0]));
        }
    }

    private void validateSingleCube(String schema) throws XPathExpressionException, KettleException {
        NodeList tableNameAttributes = this.getNodeList(schema, "//Cube");
        if (tableNameAttributes.getLength() != 1) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AnalysisModeler.SelectModelErrorMultipleCubes", (String[])new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ValueMetaInterface> getFieldsInDatabase() throws KettleDatabaseException {
        Database database = new Database((LoggingObjectInterface)this.jobEntry, this.connectionInfo.getDatabaseMeta());
        try {
            database.connect();
            RowMetaInterface tableFields = database.getTableFields(this.getTablename());
            List list = tableFields.getValueMetaList();
            return list;
        }
        finally {
            database.disconnect();
        }
    }

    private String getTablename() {
        return this.jobEntry.environmentSubstitute(this.connectionInfo.getTableName());
    }

    private NodeList getNodeList(String schema, String xPathExpression) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        return (NodeList)xpath.compile(xPathExpression).evaluate(new InputSource(new StringReader(schema)), XPathConstants.NODESET);
    }

    private boolean modelTablesAreSupported(NodeList tableNameAttributes) {
        int length = tableNameAttributes.getLength();
        if (length <= 0) {
            return false;
        }
        String uniqueTableName = tableNameAttributes.item(0).getTextContent();
        for (int i = 1; i < length; ++i) {
            if (tableNameAttributes.item(i).getTextContent().equals(uniqueTableName)) continue;
            return false;
        }
        return true;
    }

    static {
        analysisTypeMapping.put("String", Arrays.asList(2));
        analysisTypeMapping.put("Numeric", Arrays.asList(6, 5, 1));
        analysisTypeMapping.put("Boolean", Arrays.asList(4));
        analysisTypeMapping.put("Date", Arrays.asList(3));
        analysisTypeMapping.put("Time", Arrays.asList(3, 9));
        analysisTypeMapping.put("Timestamp", Arrays.asList(9));
    }
}

