/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.cluster.tests.kafka;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.pentaho.big.data.impl.cluster.tests.ClusterRuntimeTestEntry;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.hadoop.shim.api.cluster.ClusterInitializationException;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterServiceLocator;
import org.pentaho.hadoop.shim.api.jaas.JaasConfigService;
import org.pentaho.runtime.test.i18n.MessageGetter;
import org.pentaho.runtime.test.i18n.MessageGetterFactory;
import org.pentaho.runtime.test.result.RuntimeTestEntrySeverity;
import org.pentaho.runtime.test.result.RuntimeTestResultEntry;
import org.pentaho.runtime.test.result.RuntimeTestResultSummary;
import org.pentaho.runtime.test.result.org.pentaho.runtime.test.result.impl.RuntimeTestResultSummaryImpl;
import org.pentaho.runtime.test.test.impl.BaseRuntimeTest;
import org.pentaho.runtime.test.test.impl.RuntimeTestResultEntryImpl;

public class KafkaConnectTest
extends BaseRuntimeTest {
    public static final String KAFKA_CONNECT_TEST = "KafkaConnectTest";
    public static final String KAFKA_CONNECT_TEST_NAME = "KafkaConnectTest.Name";
    public static final String KAFKA_CONNECT_TEST_MALFORMED_URL_DESC = "KafkaConnectTest.MalformedUrl.Desc";
    public static final String KAFKA_CONNECT_TEST_MALFORMED_URL_MESSAGE = "KafkaConnectTest.MalformedUrl.Message";
    public static final String KAFKA_CONNECT_TEST_SUCCESS_DESC = "KafkaConnectTest.Success.Desc";
    public static final String KAFKA_CONNECT_TEST_SUCCESS_MESSAGE = "KafkaConnectTest.Success.Message";
    public static final String KAFKA_CONNECT_TEST_EMPTY_DESC = "KafkaConnectTest.Empty.Desc";
    public static final String KAFKA_CONNECT_TEST_EMPTY_MESSAGE = "KafkaConnectTest.Empty.Message";
    private final MessageGetter messageGetter;
    Function<Map<String, Object>, Consumer> consumerFunction;
    static final Class<?> PKG = KafkaConnectTest.class;
    protected final MessageGetterFactory messageGetterFactory;
    private NamedClusterServiceLocator namedClusterServiceLocator;

    public KafkaConnectTest(MessageGetterFactory messageGetterFactory, NamedClusterServiceLocator namedClusterServiceLocator) {
        this(messageGetterFactory, KafkaConsumer::new, namedClusterServiceLocator);
    }

    KafkaConnectTest(MessageGetterFactory messageGetterFactory, Function<Map<String, Object>, Consumer> consumerFunction, NamedClusterServiceLocator namedClusterServiceLocator) {
        super(NamedCluster.class, "Kafka", KAFKA_CONNECT_TEST, messageGetterFactory.create(PKG).getMessage(KAFKA_CONNECT_TEST_NAME, new String[0]), Collections.emptySet());
        this.messageGetterFactory = messageGetterFactory;
        this.namedClusterServiceLocator = namedClusterServiceLocator;
        this.messageGetter = messageGetterFactory.create(PKG);
        this.consumerFunction = consumerFunction;
    }

    public RuntimeTestResultSummary runTest(Object objectUnderTest) {
        RuntimeTestResultSummaryImpl runtimeTestResultSummaryImpl;
        block12: {
            NamedCluster namedCluster = (NamedCluster)objectUnderTest;
            Variables variables = new Variables();
            variables.initializeVariablesFrom(null);
            String bootstrapServers = variables.environmentSubstitute(namedCluster.getKafkaBootstrapServers());
            if (StringUtils.isBlank((String)bootstrapServers)) {
                return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, (RuntimeTestResultEntry)new RuntimeTestResultEntryImpl(RuntimeTestEntrySeverity.SKIPPED, this.messageGetter.getMessage(KAFKA_CONNECT_TEST_EMPTY_DESC, new String[0]), this.messageGetter.getMessage(KAFKA_CONNECT_TEST_EMPTY_MESSAGE, new String[0])), ClusterRuntimeTestEntry.DocAnchor.KAFKA));
            }
            HashMap<String, Object> configs = new HashMap<String, Object>();
            configs.put("bootstrap.servers", bootstrapServers);
            configs.put("value.deserializer", StringDeserializer.class);
            configs.put("key.deserializer", StringDeserializer.class);
            configs.put("request.timeout.ms", 10000);
            configs.put("session.timeout.ms", 9000);
            try {
                JaasConfigService jaasConfigService = (JaasConfigService)this.namedClusterServiceLocator.getService(namedCluster, JaasConfigService.class);
                if (jaasConfigService != null && jaasConfigService.isKerberos()) {
                    configs.put("sasl.jaas.config", jaasConfigService.getJaasConfig());
                    configs.put("security.protocol", "SASL_PLAINTEXT");
                }
            }
            catch (ClusterInitializationException jaasConfigService) {
                // empty catch block
            }
            Consumer consumer = this.consumerFunction.apply(configs);
            try {
                consumer.listTopics();
                runtimeTestResultSummaryImpl = new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, (RuntimeTestResultEntry)new RuntimeTestResultEntryImpl(RuntimeTestEntrySeverity.INFO, this.messageGetter.getMessage(KAFKA_CONNECT_TEST_SUCCESS_DESC, new String[0]), this.messageGetter.getMessage(KAFKA_CONNECT_TEST_SUCCESS_MESSAGE, new String[0])), ClusterRuntimeTestEntry.DocAnchor.KAFKA));
                if (consumer == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (consumer != null) {
                        try {
                            consumer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return new RuntimeTestResultSummaryImpl((RuntimeTestResultEntry)new ClusterRuntimeTestEntry(this.messageGetterFactory, (RuntimeTestResultEntry)new RuntimeTestResultEntryImpl(RuntimeTestEntrySeverity.ERROR, this.messageGetter.getMessage(KAFKA_CONNECT_TEST_MALFORMED_URL_DESC, new String[0]), this.messageGetter.getMessage(KAFKA_CONNECT_TEST_MALFORMED_URL_MESSAGE, new String[]{bootstrapServers})), ClusterRuntimeTestEntry.DocAnchor.KAFKA));
                }
            }
            consumer.close();
        }
        return runtimeTestResultSummaryImpl;
    }
}

