/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.mapreduce.converter;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.hadoop.mapreduce.converter.TypeConversionException;
import org.pentaho.hadoop.mapreduce.converter.converters.BytesWritableToByteArrayConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.DoubleWritableToDoubleConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.DoubleWritableToLongConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.ImmutableBytesWritablePassThroughConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.IntWritableToLongConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.KettleTypeToBooleanWritableConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.KettleTypeToBytesWritableConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.KettleTypeToDoubleWritableConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.KettleTypeToIntWritableConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.KettleTypeToLongWritableConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.KettleTypeToTextConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.LongWritableToLongConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.LongWritableToTextConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.NullConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.NullWritableConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.ObjectToStringConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.ResultPassThroughConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.TextToIntegerConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.TextToLongConverter;
import org.pentaho.hadoop.mapreduce.converter.converters.TextToStringConverter;
import org.pentaho.hadoop.mapreduce.converter.spi.ITypeConverter;

public class TypeConverterFactory {
    static ITypeConverter[] CONVERTERS = new ITypeConverter[]{new BytesWritableToByteArrayConverter(), new DoubleWritableToDoubleConverter(), new DoubleWritableToLongConverter(), new ImmutableBytesWritablePassThroughConverter(), new IntWritableToLongConverter(), new KettleTypeToBooleanWritableConverter(), new KettleTypeToBytesWritableConverter(), new KettleTypeToDoubleWritableConverter(), new KettleTypeToIntWritableConverter(), new KettleTypeToLongWritableConverter(), new KettleTypeToTextConverter(), new LongWritableToLongConverter(), new LongWritableToTextConverter(), new NullConverter(), new NullWritableConverter(), new ObjectToStringConverter(), new ResultPassThroughConverter(), new TextToIntegerConverter(), new TextToLongConverter(), new TextToStringConverter()};
    private Map<Key, ITypeConverter<?, ?>> cache = new HashMap();

    public static boolean isKettleType(Class<?> type) {
        return type != null && (CharSequence.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || byte[].class.equals(type) || Boolean.class.equals(type) || Date.class.equals(type));
    }

    public Class<?> getJavaClass(ValueMetaInterface vmi) {
        Class metaClass = null;
        switch (vmi.getType()) {
            case 6: {
                metaClass = BigDecimal.class;
                break;
            }
            case 8: {
                metaClass = byte[].class;
                break;
            }
            case 4: {
                metaClass = Boolean.class;
                break;
            }
            case 3: {
                metaClass = Date.class;
                break;
            }
            case 5: {
                metaClass = Long.class;
                break;
            }
            case 1: {
                metaClass = Double.class;
                break;
            }
            case 2: {
                metaClass = String.class;
                break;
            }
            case 7: {
                metaClass = Object.class;
            }
        }
        return metaClass;
    }

    public static Class<? extends Writable> getWritableForKettleType(ValueMetaInterface kettleType) {
        if (kettleType == null) {
            return NullWritable.class;
        }
        switch (kettleType.getType()) {
            case 2: 
            case 3: 
            case 6: {
                return Text.class;
            }
            case 5: {
                return LongWritable.class;
            }
            case 1: {
                return DoubleWritable.class;
            }
            case 4: {
                return BooleanWritable.class;
            }
            case 8: {
                return BytesWritable.class;
            }
        }
        return Text.class;
    }

    protected <F, T> ITypeConverter<F, T> findConverter(Class<F> from, Class<T> to) throws TypeConversionException {
        try {
            for (ITypeConverter tc : CONVERTERS) {
                if (!tc.canConvert(from, to)) continue;
                return tc;
            }
        }
        catch (ServiceConfigurationError ex) {
            throw new TypeConversionException("Error instantiating type converter", ex);
        }
        return null;
    }

    public <F, T> void registerConverter(Class<F> from, Class<T> to, ITypeConverter<F, T> converter) {
        this.cache.put(new Key(from, to), converter);
    }

    public <F, T> ITypeConverter<F, T> getConverter(Class<F> from, Class<T> to) throws TypeConversionException {
        ITypeConverter<Object, Object> converter = this.cache.get(new Key(from, to));
        if (converter == null) {
            converter = this.findConverter(from, to);
            this.registerConverter(from, to, converter);
        }
        if (converter == null) {
            throw new TypeConversionException("Can't convert from " + from.getName() + " to " + to.getName());
        }
        return converter;
    }

    public <F> ITypeConverter<F, ?> getConverter(Class<F> from, ValueMetaInterface vmi) throws TypeConversionException {
        Class<?> to = this.getJavaClass(vmi);
        return to == null ? null : this.getConverter(from, to);
    }

    private static class Key {
        private Class from;
        private Class to;

        private Key(Class from, Class to) {
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.from != null ? !this.from.equals(key.from) : key.from != null) {
                return false;
            }
            return !(this.to != null ? !this.to.equals(key.to) : key.to != null);
        }

        public int hashCode() {
            int result = this.from != null ? this.from.hashCode() : 0;
            result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
            return result;
        }
    }
}

