/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cassandra.driver.datastax;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.NotImplementedException;
import org.pentaho.cassandra.driver.datastax.DriverKeyspace;
import org.pentaho.cassandra.spi.CQLRowHandler;
import org.pentaho.cassandra.spi.ITableMetaData;
import org.pentaho.cassandra.spi.Keyspace;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.StepInterface;

public class DriverCQLRowHandler
implements CQLRowHandler {
    private final Session session;
    DriverKeyspace keyspace;
    ResultSet result;
    ColumnDefinitions columns;
    private int batchInsertTimeout;
    private int ttlSec;
    private boolean unloggedBatch = true;
    private boolean expandCollection = true;
    private int primaryCollectionOutputIndex = -1;

    public DriverCQLRowHandler(DriverKeyspace keyspace, Session session, boolean expandCollection) {
        this.keyspace = keyspace;
        this.session = session;
        this.expandCollection = expandCollection;
    }

    public DriverCQLRowHandler(DriverKeyspace keyspace) {
        this(keyspace, keyspace.getConnection().getSession(keyspace.getName()), true);
    }

    public boolean supportsCQLVersion(int cqMajorlVersion) {
        return cqMajorlVersion >= 3 && cqMajorlVersion <= 3;
    }

    @Override
    public void setOptions(Map<String, String> options) {
        this.keyspace.setOptions(options);
        if (options.containsKey("batchTimeout")) {
            this.batchInsertTimeout = Integer.parseInt(options.get("batchTimeout"));
        }
        if (options.containsKey("TTL")) {
            this.ttlSec = Integer.parseInt(options.get("TTL"));
        }
    }

    @Override
    public void setKeyspace(Keyspace keyspace) {
        this.keyspace = (DriverKeyspace)keyspace;
    }

    @Override
    public void newRowQuery(StepInterface requestingStep, String tableName, String cqlQuery, String compress, String consistencyLevel, LogChannelInterface log) throws Exception {
        this.result = this.getSession().execute(cqlQuery);
        this.columns = this.result.getColumnDefinitions();
        if (this.expandCollection) {
            for (int i = 0; i < this.columns.size(); ++i) {
                if (!this.columns.getType(i).isCollection()) continue;
                if (this.primaryCollectionOutputIndex < 0) {
                    this.primaryCollectionOutputIndex = i;
                    continue;
                }
                if (this.keyspace.getTableMetaData(tableName).getValueMetaForColumn(this.columns.getName(i)).isString()) continue;
                throw new KettleException(BaseMessages.getString(DriverCQLRowHandler.class, (String)"DriverCQLRowHandler.Error.CantHandleAdditionalCollectionsThatAreNotOfTypeText", (String[])new String[0]));
            }
        }
    }

    @Override
    public Object[][] getNextOutputRow(RowMetaInterface outputRowMeta, Map<String, Integer> outputFormatMap) throws Exception {
        if (this.result == null || this.result.isExhausted()) {
            this.result = null;
            this.columns = null;
            return null;
        }
        Row row = this.result.one();
        Object[][] outputRowData = new Object[1][];
        Object[] baseOutputRowData = RowDataUtil.allocateRowData((int)Math.max(outputRowMeta.size(), this.columns.size()));
        for (int i = 0; i < this.columns.size(); ++i) {
            baseOutputRowData[i] = DriverCQLRowHandler.readValue(outputRowMeta.getValueMeta(i), row, i);
        }
        outputRowData[0] = baseOutputRowData;
        if (this.primaryCollectionOutputIndex > 0) {
            Collection collection = (Collection)row.getObject(this.primaryCollectionOutputIndex);
            if (collection != null && !collection.isEmpty()) {
                outputRowData = new Object[collection.size()][];
                int i = 0;
                for (Object obj : collection) {
                    outputRowData[i] = Arrays.copyOf(baseOutputRowData, baseOutputRowData.length);
                    outputRowData[i++][this.primaryCollectionOutputIndex] = obj;
                }
            } else {
                outputRowData[0][this.primaryCollectionOutputIndex] = null;
            }
        }
        return outputRowData;
    }

    public static Object readValue(ValueMetaInterface meta, Row row, int i) {
        if (row.isNull(i)) {
            return null;
        }
        switch (meta.getType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                ColumnDefinitions cdef = row.getColumnDefinitions();
                switch (cdef.getType(i).getName()) {
                    case BIGINT: 
                    case COUNTER: {
                        return row.getLong(i);
                    }
                    case SMALLINT: {
                        return (long)row.getShort(i);
                    }
                    case TINYINT: {
                        return (long)row.getByte(i);
                    }
                    case INT: {
                        return (long)row.getInt(i);
                    }
                    case FLOAT: {
                        return (double)row.getFloat(i);
                    }
                    case DOUBLE: {
                        return row.getDouble(i);
                    }
                    case DECIMAL: {
                        return row.getDecimal(i);
                    }
                    case VARINT: {
                        return new BigDecimal(row.getVarint(i));
                    }
                    case BOOLEAN: {
                        return row.getBool(i);
                    }
                    case DATE: {
                        return new Date(row.getDate(i).getMillisSinceEpoch());
                    }
                    case TIMESTAMP: {
                        return row.getTimestamp(i);
                    }
                    case TIME: {
                        return row.getTime(i);
                    }
                    case BLOB: {
                        return row.getBytes(i).array();
                    }
                }
                return row.getObject(i);
            }
        }
        return row.getObject(i);
    }

    public void batchInsert(RowMetaInterface inputMeta, Iterable<Object[]> rows, ITableMetaData tableMeta, String consistencyLevel, boolean insertFieldsNotInMetadata, LogChannelInterface log) throws Exception {
        Batch batch;
        String[] columnNames = this.getColumnNames(inputMeta);
        Batch batch2 = batch = this.unloggedBatch ? QueryBuilder.unloggedBatch((RegularStatement[])new RegularStatement[0]) : QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
        if (!Utils.isEmpty((CharSequence)consistencyLevel)) {
            try {
                batch.setConsistencyLevel(ConsistencyLevel.valueOf((String)consistencyLevel));
            }
            catch (Exception e) {
                log.logError(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        if (!insertFieldsNotInMetadata) {
            for (int i = 0; i < columnNames.length; ++i) {
                if (tableMeta.columnExistsInSchema(columnNames[i])) continue;
                toRemove.add(i);
            }
            if (toRemove.size() > 0) {
                columnNames = DriverCQLRowHandler.copyExcluding(columnNames, new String[columnNames.length - toRemove.size()], toRemove);
            }
        }
        for (Object[] row : rows) {
            Object[] values = toRemove.size() == 0 ? Arrays.copyOf(row, columnNames.length) : DriverCQLRowHandler.copyExcluding(row, new Object[columnNames.length], toRemove);
            Insert insert = QueryBuilder.insertInto((String)this.keyspace.getName(), (String)tableMeta.getTableName());
            insert = this.ttlSec > 0 ? insert.using(QueryBuilder.ttl((int)this.ttlSec)).values(columnNames, values) : insert.values(columnNames, values);
            batch.add((RegularStatement)insert);
        }
        if (this.batchInsertTimeout > 0) {
            try {
                this.getSession().executeAsync((Statement)batch).getUninterruptibly((long)this.batchInsertTimeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                log.logError(BaseMessages.getString(DriverCQLRowHandler.class, (String)"DriverCQLRowHandler.Error.TimeoutReached", (String[])new String[0]));
            }
        } else {
            this.getSession().execute((Statement)batch);
        }
    }

    protected static <T> T[] copyExcluding(T[] source, T[] target, List<Integer> toRemove) {
        int removed = toRemove.size();
        int start = 0;
        int dest = 0;
        int removeCount = 0;
        for (int idx : toRemove) {
            int len = idx - start;
            if (len > 0) {
                System.arraycopy(source, start, target, dest, len);
                dest += len;
            }
            start = idx + 1;
            if (++removeCount != removed || dest >= target.length) continue;
            System.arraycopy(source, start, target, dest, target.length - dest);
        }
        return target;
    }

    private String[] getColumnNames(RowMetaInterface inputMeta) {
        String[] columns = new String[inputMeta.size()];
        for (int i = 0; i < inputMeta.size(); ++i) {
            columns[i] = inputMeta.getValueMeta(i).getName();
        }
        return columns;
    }

    @Override
    public void commitCQLBatch(StepInterface requestingStep, StringBuilder batch, String compress, String consistencyLevel, LogChannelInterface log) throws Exception {
        throw new NotImplementedException();
    }

    public void setUnloggedBatch(boolean unloggedBatch) {
        this.unloggedBatch = unloggedBatch;
    }

    public boolean isUnloggedBatch() {
        return this.unloggedBatch;
    }

    private Session getSession() {
        return this.session;
    }

    public void setTtlSec(int ttl) {
        this.ttlSec = ttl;
    }
}

