/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.palo.dimoutput;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.palo.core.PaloDimensionLevel;
import org.pentaho.di.palo.core.PaloNameComparator;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.steps.palo.dimoutput.PaloDimOutputData;
import org.pentaho.di.trans.steps.palo.dimoutput.PaloDimOutputMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.palo.cellinput.PaloCellInputDialog;

public class PaloDimOutputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = PaloDimOutputMeta.class;
    private final PaloDimOutputMeta meta;
    private Text textStepName;
    private Combo comboDimension;
    private Combo comboElementType;
    private TableView tableViewFields;
    private ColumnInfo[] colinf;
    private Button buttonOk;
    private Button buttonCancel;
    private Button buttonCreateDimension;
    private Label labelCreateDimension;
    private Button buttonClearDimension;
    private Label labelClearDimension;
    private Button buttonClearConsolidations;
    private Label labelClearConsolidations;
    private Button buttonEnableElementCache;
    private Label labelEnableElementCache;
    private Button buttonPreloadElementCache;
    private Label labelPreloadElementCache;
    private Button buttonRecreateDimension;
    private Label labelRecreateDimension;
    private Label labelDimension;
    private Label labelElementType;
    private Button buttonClearLevels;
    private Button buttonGetLevels;
    private Label labelStepName;
    private CCombo addConnectionLine;

    public static void main(String[] args) {
        try {
            PaloDimOutputDialog window = new PaloDimOutputDialog(null, (Object)new PaloDimOutputMeta(), null, "noname");
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PaloDimOutputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.meta = (PaloDimOutputMeta)((Object)in);
    }

    public String open() {
        Display display = this.getParent().getDisplay();
        this.shell = new Shell(this.getParent(), 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.meta);
        this.setShellImage(this.shell, this.meta);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        int middle = this.props.getMiddlePct();
        int margin = 4;
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                for (int i = 0; i < ((PaloDimOutputDialog)PaloDimOutputDialog.this).tableViewFields.table.getItemCount(); ++i) {
                    PaloDimOutputDialog.this.tableViewFields.setText(String.valueOf(i), 1, i);
                }
            }
        };
        this.labelStepName = new Label((Composite)this.shell, 131072);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        this.labelStepName.setLayoutData((Object)fd);
        this.textStepName = new Text((Composite)this.shell, 18436);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, margin);
        this.textStepName.setLayoutData((Object)fd);
        this.addConnectionLine = this.addConnectionLine((Composite)this.shell, (Control)this.textStepName, 35, margin);
        this.labelCreateDimension = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.labelCreateDimension.setLayoutData((Object)fd);
        this.buttonCreateDimension = new Button((Composite)this.shell, 32);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.buttonCreateDimension.setLayoutData((Object)fd);
        this.labelRecreateDimension = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.buttonCreateDimension, margin);
        this.labelRecreateDimension.setLayoutData((Object)fd);
        this.buttonRecreateDimension = new Button((Composite)this.shell, 32);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.buttonCreateDimension, margin);
        this.buttonRecreateDimension.setLayoutData((Object)fd);
        this.labelClearDimension = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.buttonRecreateDimension, margin);
        this.labelClearDimension.setLayoutData((Object)fd);
        this.buttonClearDimension = new Button((Composite)this.shell, 32);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.buttonRecreateDimension, margin);
        this.buttonClearDimension.setLayoutData((Object)fd);
        this.labelClearConsolidations = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.buttonClearDimension, margin);
        this.labelClearConsolidations.setLayoutData((Object)fd);
        this.buttonClearConsolidations = new Button((Composite)this.shell, 32);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.buttonClearDimension, margin);
        this.buttonClearConsolidations.setLayoutData((Object)fd);
        this.labelEnableElementCache = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.buttonClearConsolidations, margin);
        this.labelEnableElementCache.setLayoutData((Object)fd);
        this.buttonEnableElementCache = new Button((Composite)this.shell, 32);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.buttonClearConsolidations, margin);
        this.buttonEnableElementCache.setLayoutData((Object)fd);
        this.labelPreloadElementCache = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.buttonEnableElementCache, margin);
        this.labelPreloadElementCache.setLayoutData((Object)fd);
        this.buttonPreloadElementCache = new Button((Composite)this.shell, 32);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.buttonEnableElementCache, margin);
        this.buttonPreloadElementCache.setLayoutData((Object)fd);
        this.labelDimension = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.buttonPreloadElementCache, margin);
        this.labelDimension.setLayoutData((Object)fd);
        this.comboDimension = new Combo((Composite)this.shell, 68);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.buttonPreloadElementCache, margin);
        this.comboDimension.setLayoutData((Object)fd);
        this.labelElementType = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.comboDimension, margin);
        this.labelElementType.setLayoutData((Object)fd);
        this.comboElementType = new Combo((Composite)this.shell, 12);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.comboDimension, margin);
        this.comboElementType.setLayoutData((Object)fd);
        this.colinf = new ColumnInfo[]{new ColumnInfo(this.getLocalizedColumn(0), 1, false, true), new ColumnInfo(this.getLocalizedColumn(1), 1, false, false), new ColumnInfo(this.getLocalizedColumn(2), 2, new String[0], true), new ColumnInfo(this.getLocalizedColumn(3), 2, new String[0], true)};
        this.tableViewFields = new TableView(null, (Composite)this.shell, 2052, this.colinf, 10, true, lsMod, this.props);
        this.tableViewFields.setSize(477, 105);
        this.tableViewFields.setBounds(5, 250, 477, 105);
        this.tableViewFields.setReadonly(false);
        this.tableViewFields.table.removeAll();
        this.tableViewFields.setSortable(false);
        fd = new FormData();
        fd.left = new FormAttachment(0, margin);
        fd.top = new FormAttachment((Control)this.comboElementType, 3 * margin);
        fd.right = new FormAttachment(100, -150);
        fd.bottom = new FormAttachment(100, -50);
        this.tableViewFields.setLayoutData((Object)fd);
        this.buttonGetLevels = new Button((Composite)this.shell, 0x1000000);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.tableViewFields, margin);
        fd.top = new FormAttachment((Control)this.comboElementType, 3 * margin);
        fd.right = new FormAttachment(100, 0);
        this.buttonGetLevels.setLayoutData((Object)fd);
        this.buttonClearLevels = new Button((Composite)this.shell, 0x1000000);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.tableViewFields, margin);
        fd.top = new FormAttachment((Control)this.buttonGetLevels, margin);
        fd.right = new FormAttachment(100, 0);
        this.buttonClearLevels.setLayoutData((Object)fd);
        this.buttonOk = new Button((Composite)this.shell, 0x1000000);
        this.buttonCancel = new Button((Composite)this.shell, 0x1000000);
        this.buttonOk.setText(BaseMessages.getString((String)"System.Button.OK"));
        this.buttonCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        this.setButtonPositions(new Button[]{this.buttonOk, this.buttonCancel}, margin, null);
        this.addConnectionLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloDimOutputDialog.this.doSelectConnection(false);
            }
        });
        this.buttonGetLevels.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloDimOutputDialog.this.doGetFields();
            }
        });
        this.buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloDimOutputDialog.this.ok();
            }
        });
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloDimOutputDialog.this.cancel();
            }
        });
        this.buttonClearLevels.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloDimOutputDialog.this.doClearFields();
            }
        });
        this.comboDimension.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloDimOutputDialog.this.doSelectDimension();
            }
        });
        this.buttonRecreateDimension.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PaloDimOutputDialog.this.buttonClearDimension.setEnabled(!PaloDimOutputDialog.this.buttonRecreateDimension.getSelection());
                PaloDimOutputDialog.this.buttonClearConsolidations.setEnabled(!PaloDimOutputDialog.this.buttonRecreateDimension.getSelection());
            }
        });
        this.buttonClearDimension.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PaloDimOutputDialog.this.buttonClearConsolidations.setEnabled(!PaloDimOutputDialog.this.buttonClearDimension.getSelection());
            }
        });
        this.buttonEnableElementCache.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PaloDimOutputDialog.this.buttonPreloadElementCache.setEnabled(PaloDimOutputDialog.this.buttonEnableElementCache.getSelection());
            }
        });
        this.fillLocalizedData();
        this.fillStoredData();
        this.doSelectConnection(false);
        try {
            this.fillPreviousFieldTableViewColumn();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.props.setLook((Control)this.textStepName);
        this.props.setLook((Control)this.comboDimension);
        this.props.setLook((Control)this.comboElementType);
        this.props.setLook((Control)this.tableViewFields);
        this.props.setLook((Control)this.buttonOk);
        this.props.setLook((Control)this.buttonCancel);
        this.props.setLook((Control)this.labelDimension);
        this.props.setLook((Control)this.labelElementType);
        this.props.setLook((Control)this.buttonClearLevels);
        this.props.setLook((Control)this.buttonGetLevels);
        this.props.setLook((Control)this.labelStepName);
        this.props.setLook((Control)this.addConnectionLine);
        this.props.setLook((Control)this.buttonCreateDimension);
        this.props.setLook((Control)this.labelCreateDimension);
        this.props.setLook((Control)this.buttonClearDimension);
        this.props.setLook((Control)this.labelClearDimension);
        this.props.setLook((Control)this.buttonClearConsolidations);
        this.props.setLook((Control)this.labelClearConsolidations);
        this.props.setLook((Control)this.buttonRecreateDimension);
        this.props.setLook((Control)this.labelRecreateDimension);
        this.props.setLook((Control)this.buttonEnableElementCache);
        this.props.setLook((Control)this.labelEnableElementCache);
        this.props.setLook((Control)this.buttonPreloadElementCache);
        this.props.setLook((Control)this.labelPreloadElementCache);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                PaloDimOutputDialog.this.cancel();
            }
        });
        this.meta.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        PaloCellInputDialog.showPaloLibWarningDialog(this.shell);
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void doSelectDimension() {
    }

    private void doSelectConnection(boolean clearCurrentData) {
        try {
            DatabaseMeta dbMeta;
            if (clearCurrentData) {
                this.tableViewFields.table.removeAll();
                this.comboDimension.removeAll();
            }
            if (this.addConnectionLine.getText() != null && (dbMeta = this.transMeta.findDatabase(this.addConnectionLine.getText())) != null) {
                PaloDimOutputData data = new PaloDimOutputData(dbMeta);
                data.helper.connect();
                List dimensions = data.helper.getDimensionsNames();
                Collections.sort(dimensions, new PaloNameComparator());
                for (String dimensionName : dimensions) {
                    if (this.comboDimension.indexOf(dimensionName) != -1) continue;
                    this.comboDimension.add(dimensionName);
                }
                data.helper.disconnect();
            }
        }
        catch (Exception ex) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.RetreiveDimensionsErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.RetreiveDimensionsError", (String[])new String[0]), ex);
        }
    }

    private void fillPreviousFieldTableViewColumn() throws KettleException {
        RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
        if (r != null) {
            String[] fieldNames = r.getFieldNames();
            this.colinf[2] = new ColumnInfo(this.getLocalizedColumn(2), 2, fieldNames, true);
            String[] fieldTypes = r.getFieldNamesAndTypes(0);
            ArrayList<String> intFields = new ArrayList<String>();
            intFields.add(BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.ConsolidationFactorDefault", (String[])new String[0]));
            for (int i = 0; i < fieldNames.length; ++i) {
                if (fieldTypes[i].toLowerCase().indexOf("integer") < 0 && fieldTypes[i].toLowerCase().indexOf("number") <= 0) continue;
                intFields.add(fieldNames[i]);
            }
            String[] fieldNamesDefault = intFields.toArray(new String[intFields.size()]);
            this.colinf[3] = new ColumnInfo(this.getLocalizedColumn(3), 2, fieldNamesDefault, true);
        }
    }

    private void doGetFields() {
        try {
            if (this.comboDimension.getText() != null) {
                DatabaseMeta dbMeta;
                if (this.addConnectionLine.getText() != null && (dbMeta = this.transMeta.findDatabase(this.addConnectionLine.getText())) != null) {
                    PaloDimOutputData data = new PaloDimOutputData(dbMeta);
                    this.tableViewFields.table.removeAll();
                    data.helper.connect();
                    List levels = data.helper.getDimensionLevels(this.comboDimension.getText());
                    for (PaloDimensionLevel level : levels) {
                        this.tableViewFields.add(new String[]{String.valueOf(level.getLevelNumber()), level.getLevelName(), level.getFieldName()});
                    }
                    this.tableViewFields.removeEmptyRows();
                    this.tableViewFields.setRowNums();
                    this.tableViewFields.optWidth(true);
                    data.helper.disconnect();
                }
            } else {
                new ErrorDialog(this.shell, BaseMessages.getString((String)"System.Dialog.GetFieldsFailed.Title"), BaseMessages.getString((String)"System.Dialog.GetFieldsFailed.Message"), new Exception(BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.SelectDimensionsFirstError", (String[])new String[0])));
            }
            this.fillPreviousFieldTableViewColumn();
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString((String)"System.Dialog.GetFieldsFailed.Title"), BaseMessages.getString((String)"System.Dialog.GetFieldsFailed.Message"), (Exception)((Object)ke));
            this.tableViewFields.add(new String[0]);
        }
    }

    private void doClearFields() {
        this.tableViewFields.table.removeAll();
        this.tableViewFields.add(new String[0]);
    }

    private String getLocalizedColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.ColumnLevelNumber", (String[])new String[0]);
            }
            case 1: {
                return BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.ColumnLevelName", (String[])new String[0]);
            }
            case 2: {
                return BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.ColumnField", (String[])new String[0]);
            }
            case 3: {
                return BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.ColumnConsolidationFactor", (String[])new String[0]);
            }
        }
        return "";
    }

    private void fillStoredData() {
        int indexType;
        int index;
        if (this.stepname != null) {
            this.textStepName.setText(this.stepname);
        }
        if ((index = this.addConnectionLine.indexOf(this.meta.getDatabaseMeta() != null ? this.meta.getDatabaseMeta().getName() : "")) >= 0) {
            this.addConnectionLine.select(index);
        }
        this.tableViewFields.table.removeAll();
        if (this.meta.getLevels().size() > 0) {
            for (PaloDimensionLevel level : this.meta.getLevels()) {
                String consolidationFactor = level.getConsolidationFieldName();
                if (consolidationFactor == null) {
                    consolidationFactor = BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.ConsolidationFactorDefault", (String[])new String[0]);
                }
                this.tableViewFields.add(new String[]{String.valueOf(level.getLevelNumber()), level.getLevelName(), level.getFieldName(), consolidationFactor});
            }
            this.tableViewFields.setRowNums();
            this.tableViewFields.optWidth(true);
        }
        if (this.meta.getDimension() != null) {
            this.comboDimension.add(this.meta.getDimension());
            this.comboDimension.select(0);
        }
        if (this.meta.getElementType() != null) {
            this.comboElementType.add(this.meta.getElementType());
            this.comboElementType.select(0);
        }
        this.comboElementType.setItems(new String[]{"Numeric", "String"});
        this.comboElementType.select(0);
        if (this.meta.getElementType() != null && (indexType = this.comboElementType.indexOf(this.meta.getElementType())) >= 0) {
            this.comboElementType.select(indexType);
        }
        this.buttonCreateDimension.setSelection(this.meta.getCreateNewDimension());
        this.buttonClearDimension.setSelection(this.meta.getClearDimension());
        this.buttonClearConsolidations.setSelection(this.meta.getClearConsolidations());
        this.buttonEnableElementCache.setSelection(this.meta.getEnableElementCache());
        this.buttonPreloadElementCache.setSelection(this.meta.getPreloadElementCache());
        this.buttonRecreateDimension.setSelection(this.meta.getRecreateDimension());
        this.buttonClearDimension.setEnabled(!this.buttonRecreateDimension.getSelection());
        this.buttonClearConsolidations.setEnabled(!this.buttonRecreateDimension.getSelection());
        this.buttonPreloadElementCache.setEnabled(this.buttonEnableElementCache.getSelection());
        if (this.buttonClearDimension.getEnabled()) {
            this.buttonClearConsolidations.setEnabled(!this.buttonClearDimension.getSelection());
        }
    }

    private void fillLocalizedData() {
        this.buttonGetLevels.setText(BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.GetLevels", (String[])new String[0]));
        this.buttonClearLevels.setText(BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.ClearLevels", (String[])new String[0]));
        this.labelStepName.setText(BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.StepName", (String[])new String[0]));
        this.shell.setText(BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.PaloDimOutput", (String[])new String[0]));
        this.labelDimension.setText(BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.SelectDimension", (String[])new String[0]));
        this.labelElementType.setText(BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.SelectElementType", (String[])new String[0]));
        this.labelCreateDimension.setText(BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.CreateNewDimension", (String[])new String[0]));
        this.labelClearDimension.setText(BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.ClearDimension", (String[])new String[0]));
        this.labelClearConsolidations.setText(BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.ClearConsolidations", (String[])new String[0]));
        this.labelRecreateDimension.setText(BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.RecreateDimension", (String[])new String[0]));
        this.labelEnableElementCache.setText(BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.EnableElementCache", (String[])new String[0]));
        this.labelPreloadElementCache.setText(BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.PreloadElementCache", (String[])new String[0]));
    }

    private void cancel() {
        this.stepname = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        try {
            this.getInfo(this.meta);
            this.dispose();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.FailedToSaveDataErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.FailedToSaveDataError", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void getInfo(PaloDimOutputMeta myMeta) throws KettleException {
        this.stepname = this.textStepName.getText();
        ArrayList<PaloDimensionLevel> levels = new ArrayList<PaloDimensionLevel>();
        this.tableViewFields.removeEmptyRows();
        for (int i = 0; i < this.tableViewFields.table.getItemCount(); ++i) {
            String consolidationFactor = this.tableViewFields.table.getItem(i).getText(4);
            if (consolidationFactor.equals(BaseMessages.getString(PKG, (String)"PaloDimOutputDialog.ConsolidationFactorDefault", (String[])new String[0]))) {
                consolidationFactor = null;
            }
            PaloDimensionLevel level = new PaloDimensionLevel(this.tableViewFields.table.getItem(i).getText(2), i, this.tableViewFields.table.getItem(i).getText(3), "String", consolidationFactor);
            levels.add(level);
        }
        myMeta.setDatabaseMeta(this.transMeta.findDatabase(this.addConnectionLine.getText()));
        myMeta.setLevels(levels);
        myMeta.setCreateNewDimension(this.buttonCreateDimension.getSelection());
        myMeta.setClearDimension(this.buttonClearDimension.getSelection());
        if (this.buttonClearDimension.getSelection()) {
            myMeta.setClearConsolidations(false);
        } else {
            myMeta.setClearConsolidations(this.buttonClearConsolidations.getSelection());
        }
        myMeta.setEnableElementCache(this.buttonEnableElementCache.getSelection());
        if (!this.buttonEnableElementCache.getSelection()) {
            myMeta.setPreloadElementCache(false);
        } else {
            myMeta.setPreloadElementCache(this.buttonPreloadElementCache.getSelection());
        }
        myMeta.setRecreateDimension(this.buttonRecreateDimension.getSelection());
        myMeta.setDimension(this.comboDimension.getText());
        myMeta.setElementType(this.comboElementType.getText());
        myMeta.setChanged(true);
    }
}

