/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.palo.JobEntryCubeDelete;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.palo.core.PaloHelper;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@JobEntry(id="PALO_CUBE_DELETE", i18nPackageName="org.pentaho.di.job.entries.palo.JobEntryCubeDelete", image="ui/images/deprecated.svg", name="PaloCubeDelete.JobName", description="PaloCubeDelete.JobDescription", documentationUrl="http://wiki.pentaho.com/display/EAI/Palo+Cube+Delete", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.Deprecated")
public class PaloCubeDelete
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private DatabaseMeta databaseMeta;
    private String cubeName = "";

    public PaloCubeDelete(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public PaloCubeDelete() {
        this("");
    }

    public Object clone() {
        PaloCubeDelete je = (PaloCubeDelete)super.clone();
        return je;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", (String)(this.getDatabaseMeta() == null ? "" : this.getDatabaseMeta().getName())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"cubeName", (String)this.getCubeName()));
        return retval.toString();
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.setDatabaseMeta(DatabaseMeta.findDatabase(databases, (String)XMLHandler.getTagValue((Node)entrynode, (String)"connection")));
            this.setCubeName(XMLHandler.getTagValue((Node)entrynode, (String)"cubeName"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load file exists job entry from XML node", (Throwable)xe);
        }
    }

    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromJobEntryAttribute(id_jobentry, "connection", "id_database", databases);
            this.setCubeName(rep.getStepAttributeString(id_jobentry, "cubeName"));
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry for type file exists from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveDatabaseMetaJobEntryAttribute(id_job, this.getObjectId(), "connection", "id_database", this.databaseMeta);
            rep.saveStepAttribute(id_job, this.getObjectId(), "cubeName", this.getCubeName());
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("unable to save jobentry of type 'file exists' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result prevResult, int nr) throws KettleException {
        Result result = new Result(nr);
        result.setResult(false);
        this.logDetailed(this.toString(), new Object[]{"Start of processing"});
        String realCubeName = this.environmentSubstitute(this.getCubeName());
        PaloHelper database = new PaloHelper(this.getDatabaseMeta(), this.getLogLevel());
        try {
            database.connect();
            int cubesremoved = database.removeCube(realCubeName);
            result.setResult(true);
            result.setNrLinesOutput((long)cubesremoved);
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            e.printStackTrace();
            this.logError(this.toString(), new Object[]{"Error processing Palo Cube Delete : " + e.getMessage()});
        }
        finally {
            database.disconnect();
        }
        return result;
    }

    public boolean evaluates() {
        return true;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    public String getCubeName() {
        return this.cubeName;
    }
}

