/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.util.iterators;

import com.tinkerpop.pipes.util.FastNoSuchElementException;
import com.tinkerpop.pipes.util.iterators.ExpandableIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ExpandableMultiIterator<T>
implements Iterator<T> {
    private final ExpandableIterator<Iterator<T>> iterators = new ExpandableIterator();
    private Iterator<T> currentIterator = null;

    public ExpandableMultiIterator(Iterator<T> ... iterators) {
        this(Arrays.asList(iterators));
    }

    public ExpandableMultiIterator(List<Iterator<T>> iterators) {
        for (Iterator<T> itty : iterators) {
            this.iterators.add(itty);
        }
    }

    public ExpandableMultiIterator() {
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void addIterator(Iterator<T> itty) {
        this.iterators.add(itty);
    }

    @Override
    public T next() {
        while (true) {
            if (null != this.currentIterator && this.currentIterator.hasNext()) {
                return this.currentIterator.next();
            }
            if (!this.iterators.hasNext()) break;
            this.currentIterator = this.iterators.next();
        }
        throw FastNoSuchElementException.instance();
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (null != this.currentIterator && this.currentIterator.hasNext()) {
                return true;
            }
            if (!this.iterators.hasNext()) break;
            this.currentIterator = this.iterators.next();
        }
        return false;
    }
}

