/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.Servlet;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.CartePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.DefaultWebServerShutdownHandler;
import org.pentaho.di.www.GetRootServlet;
import org.pentaho.di.www.IWebServerShutdownHandler;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.SslConfiguration;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebServerShutdownHook;

public class WebServer {
    private static final int DEFAULT_DETECTION_TIMER = 20000;
    public static final String DEFAULT_ROLE = "default";
    public static final String SERVICE_NAME = "Kettle";
    private static Class<?> PKG = WebServer.class;
    private LogChannelInterface log;
    public static final int PORT = 80;
    private Server server;
    private TransformationMap transformationMap;
    private JobMap jobMap;
    private List<SlaveServerDetection> detections;
    private SocketRepository socketRepository;
    private String hostname;
    private int port;
    private Timer slaveMonitoringTimer;
    private String passwordFile;
    private WebServerShutdownHook webServerShutdownHook;
    private IWebServerShutdownHandler webServerShutdownHandler = new DefaultWebServerShutdownHandler();
    private SslConfiguration sslConfig;

    public WebServer(LogChannelInterface log, TransformationMap transformationMap, JobMap jobMap, SocketRepository socketRepository, List<SlaveServerDetection> detections, String hostname, int port, boolean join, String passwordFile) throws Exception {
        this(log, transformationMap, jobMap, socketRepository, detections, hostname, port, join, passwordFile, null);
    }

    public WebServer(LogChannelInterface log, TransformationMap transformationMap, JobMap jobMap, SocketRepository socketRepository, List<SlaveServerDetection> detections, String hostname, int port, boolean join, String passwordFile, SslConfiguration sslConfig) throws Exception {
        this.log = log;
        this.transformationMap = transformationMap;
        this.jobMap = jobMap;
        this.socketRepository = socketRepository;
        this.detections = detections;
        this.hostname = hostname;
        this.port = port;
        this.passwordFile = passwordFile;
        this.sslConfig = sslConfig;
        this.startServer();
        this.startSlaveMonitoring();
        this.webServerShutdownHook = new WebServerShutdownHook(this);
        Runtime.getRuntime().addShutdownHook(this.webServerShutdownHook);
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)log, (String)KettleExtensionPoint.CarteStartup.id, (Object)this);
        }
        catch (KettleException e) {
            log.logError("Error calling extension point CarteStartup", (Throwable)e);
        }
        if (join) {
            this.server.join();
        }
    }

    public WebServer(LogChannelInterface log, TransformationMap transformationMap, JobMap jobMap, SocketRepository socketRepository, List<SlaveServerDetection> slaveServers, String hostname, int port) throws Exception {
        this(log, transformationMap, jobMap, socketRepository, slaveServers, hostname, port, true);
    }

    public WebServer(LogChannelInterface log, TransformationMap transformationMap, JobMap jobMap, SocketRepository socketRepository, List<SlaveServerDetection> detections, String hostname, int port, boolean join) throws Exception {
        this(log, transformationMap, jobMap, socketRepository, detections, hostname, port, join, null, null);
    }

    public Server getServer() {
        return this.server;
    }

    public void startServer() throws Exception {
        this.server = new Server();
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        if (System.getProperty("loginmodulename") != null && System.getProperty("java.security.auth.login.config") != null) {
            JAASLoginService jaasLoginService = new JAASLoginService(SERVICE_NAME);
            jaasLoginService.setLoginModuleName(System.getProperty("loginmodulename"));
            securityHandler.setLoginService((LoginService)jaasLoginService);
        } else {
            HashLoginService hashLoginService;
            roles.add(DEFAULT_ROLE);
            SlaveServer slaveServer = this.transformationMap.getSlaveServerConfig().getSlaveServer();
            if (!Utils.isEmpty((CharSequence)slaveServer.getPassword())) {
                hashLoginService = new HashLoginService(SERVICE_NAME);
                UserStore userStore = new UserStore();
                userStore.addUser(slaveServer.getUsername(), (Credential)new Password(slaveServer.getPassword()), new String[]{DEFAULT_ROLE});
                hashLoginService.setUserStore(userStore);
            } else {
                if (Utils.isEmpty((CharSequence)this.passwordFile)) {
                    File homePwdFile = new File(Const.getKettleCartePasswordFile());
                    this.passwordFile = homePwdFile.exists() ? Const.getKettleCartePasswordFile() : Const.getKettleLocalCartePasswordFile();
                }
                hashLoginService = new HashLoginService(SERVICE_NAME, this.passwordFile){

                    protected String[] loadRoleInfo(AbstractLoginService.UserPrincipal user) {
                        ArrayList<String> newRoles = new ArrayList<String>();
                        newRoles.add(WebServer.DEFAULT_ROLE);
                        String[] roles = super.loadRoleInfo(user);
                        if (null != roles) {
                            Collections.addAll(newRoles, roles);
                        }
                        return newRoles.toArray(new String[0]);
                    }
                };
            }
            securityHandler.setLoginService((LoginService)hashLoginService);
        }
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(roles.toArray(new String[0]));
        constraint.setAuthenticate(true);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        securityHandler.setConstraintMappings(new ConstraintMapping[]{constraintMapping});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        GetRootServlet rootServlet = new GetRootServlet();
        rootServlet.setJettyMode(true);
        root.addServlet(new ServletHolder((Servlet)rootServlet), "/*");
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        List plugins = pluginRegistry.getPlugins(CartePluginType.class);
        for (PluginInterface plugin : plugins) {
            CartePluginInterface servlet = (CartePluginInterface)pluginRegistry.loadClass(plugin, CartePluginInterface.class);
            servlet.setup(this.transformationMap, this.jobMap, this.socketRepository, this.detections);
            servlet.setJettyMode(true);
            ServletContextHandler servletContext = new ServletContextHandler((HandlerContainer)contexts, this.getContextPath(servlet), 1);
            ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
            servletContext.addServlet(servletHolder, "/*");
        }
        ServletHolder jerseyServletHolder = new ServletHolder(ServletContainer.class);
        jerseyServletHolder.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        jerseyServletHolder.setInitParameter("com.sun.jersey.config.property.packages", "org.pentaho.di.www.jaxrs");
        root.addServlet(jerseyServletHolder, "/api/*");
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase("temp");
        ServletHolder staticHolder = new ServletHolder("static", DefaultServlet.class);
        staticHolder.setInitParameter("resourceBase", "./static/");
        staticHolder.setInitParameter("dirAllowed", "true");
        staticHolder.setInitParameter("pathInfoOnly", "true");
        root.addServlet(staticHolder, "/static/*");
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{resourceHandler, contexts});
        securityHandler.setHandler((Handler)handlers);
        this.server.setHandler((Handler)securityHandler);
        this.createListeners();
        this.server.start();
    }

    public String getContextPath(CartePluginInterface servlet) {
        String contextPath = servlet.getContextPath();
        if (!contextPath.startsWith("/kettle")) {
            contextPath = "/kettle" + contextPath;
        }
        return contextPath;
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public void stopServer() {
        this.webServerShutdownHook.setShuttingDown(true);
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.CarteShutdown.id, (Object)this);
        }
        catch (KettleException e) {
            this.log.logError("Error calling extension point CarteStartup", (Throwable)e);
        }
        try {
            if (this.server != null) {
                if (this.slaveMonitoringTimer != null) {
                    this.slaveMonitoringTimer.cancel();
                    this.slaveMonitoringTimer = null;
                }
                this.socketRepository.closeAll();
                this.server.stop();
                KettleEnvironment.shutdown();
                if (this.webServerShutdownHandler != null) {
                    this.webServerShutdownHandler.shutdownWebServer();
                }
            }
        }
        catch (Exception e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"WebServer.Error.FailedToStop.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"WebServer.Error.FailedToStop.Msg", (String[])new String[]{"" + e})});
        }
    }

    private void createListeners() {
        ServerConnector serverConnector = this.getServerConnector();
        serverConnector.setPort(this.port);
        serverConnector.setHost(this.hostname);
        serverConnector.setName(BaseMessages.getString(PKG, (String)"WebServer.Log.KettleHTTPListener", (String[])new String[]{this.hostname}));
        this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.CreateListener", (String[])new String[]{this.hostname, "" + this.port}));
        this.server.setConnectors(new Connector[]{serverConnector});
    }

    private ServerConnector getServerConnector() {
        ServerConnector serverConnector = null;
        int jettyAcceptors = -1;
        if (this.validProperty("KETTLE_CARTE_JETTY_ACCEPTORS")) {
            jettyAcceptors = Integer.parseInt(System.getProperty("KETTLE_CARTE_JETTY_ACCEPTORS"));
            this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.ConfigOptions", (Object[])new Object[]{"acceptors", jettyAcceptors}));
        }
        if (this.sslConfig != null) {
            this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.SslModeUsing", (String[])new String[0]));
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(this.sslConfig.getKeyStore());
            sslContextFactory.setKeyStorePassword(this.sslConfig.getKeyStorePassword());
            sslContextFactory.setKeyManagerPassword(this.sslConfig.getKeyPassword());
            sslContextFactory.setKeyStoreType(this.sslConfig.getKeyStoreType());
            HttpConfiguration https = new HttpConfiguration();
            https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            serverConnector = new ServerConnector(this.server, jettyAcceptors, -1, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https)});
        } else {
            serverConnector = new ServerConnector(this.server, jettyAcceptors, -1);
        }
        if (this.validProperty("KETTLE_CARTE_JETTY_ACCEPT_QUEUE_SIZE")) {
            serverConnector.setAcceptQueueSize(Integer.parseInt(System.getProperty("KETTLE_CARTE_JETTY_ACCEPT_QUEUE_SIZE")));
            this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.ConfigOptions", (Object[])new Object[]{"acceptQueueSize", serverConnector.getAcceptQueueSize()}));
        }
        if (this.validProperty("KETTLE_CARTE_JETTY_RES_MAX_IDLE_TIME")) {
            LowResourceMonitor lowResourceMonitor = new LowResourceMonitor(this.server);
            lowResourceMonitor.setLowResourcesIdleTimeout(Integer.parseInt(System.getProperty("KETTLE_CARTE_JETTY_RES_MAX_IDLE_TIME")));
            this.server.addBean((Object)lowResourceMonitor);
            this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.ConfigOptions", (Object[])new Object[]{"lowResourcesMaxIdleTime", lowResourceMonitor.getLowResourcesIdleTimeout()}));
        }
        return serverConnector;
    }

    private boolean validProperty(String property) {
        boolean isValid = false;
        if (System.getProperty(property) != null && System.getProperty(property).length() > 0) {
            try {
                Integer.parseInt(System.getProperty(property));
                isValid = true;
            }
            catch (NumberFormatException nmbfExc) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.ConfigOptionsInvalid", (String[])new String[]{property, System.getProperty(property)}));
            }
        }
        return isValid;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public List<SlaveServerDetection> getDetections() {
        return this.detections;
    }

    private void startSlaveMonitoring() {
        this.slaveMonitoringTimer = new Timer("WebServer Timer");
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                for (SlaveServerDetection slaveServerDetection : WebServer.this.detections) {
                    SlaveServer slaveServer = slaveServerDetection.getSlaveServer();
                    try {
                        slaveServer.getStatus();
                        slaveServerDetection.setActive(true);
                        slaveServerDetection.setLastActiveDate(new Date());
                    }
                    catch (Exception e) {
                        slaveServerDetection.setActive(false);
                        slaveServerDetection.setLastInactiveDate(new Date());
                    }
                }
            }
        };
        int detectionTime = this.defaultDetectionTimer();
        this.slaveMonitoringTimer.schedule(timerTask, detectionTime, (long)detectionTime);
    }

    public SocketRepository getSocketRepository() {
        return this.socketRepository;
    }

    public void setSocketRepository(SocketRepository socketRepository) {
        this.socketRepository = socketRepository;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public LogChannelInterface getLog() {
        return this.log;
    }

    public void setLog(LogChannelInterface log) {
        this.log = log;
    }

    public TransformationMap getTransformationMap() {
        return this.transformationMap;
    }

    public void setTransformationMap(TransformationMap transformationMap) {
        this.transformationMap = transformationMap;
    }

    public JobMap getJobMap() {
        return this.jobMap;
    }

    public void setJobMap(JobMap jobMap) {
        this.jobMap = jobMap;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Timer getSlaveMonitoringTimer() {
        return this.slaveMonitoringTimer;
    }

    public void setSlaveMonitoringTimer(Timer slaveMonitoringTimer) {
        this.slaveMonitoringTimer = slaveMonitoringTimer;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public void setDetections(List<SlaveServerDetection> detections) {
        this.detections = detections;
    }

    public void setWebServerShutdownHandler(IWebServerShutdownHandler webServerShutdownHandler) {
        this.webServerShutdownHandler = webServerShutdownHandler;
    }

    public int defaultDetectionTimer() {
        String sDetectionTimer = System.getProperty("KETTLE_SLAVE_DETECTION_TIMER");
        if (sDetectionTimer != null) {
            return Integer.parseInt(sDetectionTimer);
        }
        return 20000;
    }
}

