/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.xerces.dom.DeferredTextImpl;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.www.BaseJobServlet;
import org.pentaho.di.www.WebResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RegisterTransServlet
extends BaseJobServlet {
    private static final long serialVersionUID = 468054102740138751L;
    public static final String CONTEXT_PATH = "/kettle/registerTrans";

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    @Override
    WebResult generateBody(HttpServletRequest request, HttpServletResponse response, boolean useXML) throws IOException, KettleException {
        String xml = IOUtils.toString((InputStream)request.getInputStream());
        try {
            this.validateTransformation(new ByteArrayInputStream(xml.getBytes()));
            TransConfiguration transConfiguration = TransConfiguration.fromXML(xml);
            Trans trans = this.createTrans(transConfiguration);
            String message = "Transformation '" + trans.getName() + "' was added to Carte with id " + trans.getContainerObjectId();
            return new WebResult("OK", message, trans.getContainerObjectId());
        }
        catch (KettleXMLException | SAXException ex) {
            response.setStatus(400);
            return new WebResult("ERROR", ex.getMessage(), "");
        }
        catch (Exception ex) {
            response.setStatus(500);
            return new WebResult("ERROR", ex.getMessage(), "");
        }
    }

    public void validateTransformation(InputStream is) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
        df.setFeature("http://xml.org/sax/features/external-general-entities", false);
        df.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder builder = df.newDocumentBuilder();
        Document doc = builder.parse(is);
        if (!doc.getDocumentElement().getNodeName().equals("transformation_configuration")) {
            throw new SAXException("Invalid Transformation - Missing transformation_configuration tag");
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xPath.evaluate("/transformation_configuration/transformation/info/name", doc, XPathConstants.NODE);
        if (node == null || node.getChildNodes().getLength() > 1 || !(node.getFirstChild() instanceof DeferredTextImpl)) {
            throw new SAXException("Invalid Transformation Name");
        }
    }
}

