/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.UUIDUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.www.BaseJobServlet;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;
import org.pentaho.di.www.service.zip.ZipService;
import org.pentaho.di.www.service.zip.ZipServiceKettle;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RegisterPackageServlet
extends BaseJobServlet {
    private static Class<?> PKG = RegisterPackageServlet.class;
    public static final String CONTEXT_PATH = "/kettle/registerPackage";
    private static final long serialVersionUID = -7582587179862317791L;
    public static final String PARAMETER_LOAD = "load";
    public static final String PARAMETER_TYPE = "type";
    public static final String TYPE_JOB = "job";
    public static final String TYPE_TRANS = "trans";
    private static ZipService zipService;

    @Override
    public void setup(TransformationMap transformationMap, JobMap jobMap, SocketRepository socketRepository, List<SlaveServerDetection> detections) {
        super.setup(transformationMap, jobMap, socketRepository, detections);
        RegisterPackageServlet.setZipService(new ZipServiceKettle());
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    @Override
    WebResult generateBody(HttpServletRequest request, HttpServletResponse response, boolean useXML) throws KettleException {
        String archiveUrl = this.copyRequestToDirectory(request, this.createTempDirString());
        String load = request.getParameter(PARAMETER_LOAD);
        String zipBaseUrl = this.extract(archiveUrl);
        if (!Utils.isEmpty((CharSequence)load)) {
            String resultId;
            String fileUrl = this.getStartFileUrl(zipBaseUrl, load);
            if (this.isJob(request)) {
                Node node = this.getConfigNode(zipBaseUrl, "__job_execution_configuration__.xml", "job_execution_configuration");
                JobExecutionConfiguration jobExecutionConfiguration = new JobExecutionConfiguration(node);
                JobMeta jobMeta = new JobMeta(fileUrl, jobExecutionConfiguration.getRepository());
                JobConfiguration jobConfiguration = new JobConfiguration(jobMeta, jobExecutionConfiguration);
                Job job = this.createJob(jobConfiguration);
                resultId = job.getContainerObjectId();
            } else {
                Node node = this.getConfigNode(zipBaseUrl, "__job_execution_configuration__.xml", "transformation_execution_configuration");
                TransExecutionConfiguration transExecutionConfiguration = new TransExecutionConfiguration(node);
                TransMeta transMeta = new TransMeta(fileUrl, transExecutionConfiguration.getRepository());
                TransConfiguration transConfiguration = new TransConfiguration(transMeta, transExecutionConfiguration);
                Trans trans = this.createTrans(transConfiguration);
                resultId = trans.getContainerObjectId();
            }
            this.deleteArchive(archiveUrl);
            return new WebResult("OK", fileUrl, resultId);
        }
        return null;
    }

    protected boolean isJob(HttpServletRequest request) {
        return this.isJob(request.getParameter(PARAMETER_TYPE));
    }

    protected boolean isJob(String parameterTypeValue) {
        return TYPE_JOB.equalsIgnoreCase(parameterTypeValue);
    }

    @Override
    protected boolean useXML(HttpServletRequest request) {
        return true;
    }

    protected String getStartFileUrl(String archiveUrl, String requestLoad) {
        return this.concat(archiveUrl, requestLoad);
    }

    protected String concat(String basePath, String relativePath) {
        return FilenameUtils.concat((String)basePath, (String)relativePath);
    }

    protected Node getConfigNode(String archiveUrl, String fileName, String xmlTag) throws KettleXMLException {
        String configUrl = this.concat(archiveUrl, fileName);
        Document configDoc = XMLHandler.loadXMLFile((String)configUrl);
        return XMLHandler.getSubNode((Node)configDoc, (String)xmlTag);
    }

    protected String createTempDirString() {
        return this.createTempDirString(System.getProperty("java.io.tmpdir"));
    }

    protected String createTempDirString(String baseDirectory) {
        return this.concat(baseDirectory, UUIDUtil.getUUIDAsString());
    }

    protected String createTempDirString(String baseDirectory, String folderName) {
        return this.concat(baseDirectory, folderName);
    }

    protected String copyRequestToDirectory(HttpServletRequest request, String directory) throws KettleException {
        try {
            return this.copyRequestToDirectory((InputStream)request.getInputStream(), directory);
        }
        catch (IOException ioe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RegisterPackageServlet.Exception.CopyRequest", (String[])new String[]{directory}), (Throwable)ioe);
        }
    }

    protected String copyRequestToDirectory(InputStream inputStream, String directory) throws KettleException {
        String copiedFilePath;
        try {
            FileObject foDirectory = KettleVFS.getFileObject((String)directory);
            if (!foDirectory.exists()) {
                foDirectory.createFolder();
            }
            FileObject tempZipFile = KettleVFS.createTempFile((String)"export", (String)".zip", (String)directory);
            OutputStream outputStream = KettleVFS.getOutputStream((FileObject)tempZipFile, (boolean)false);
            this.copyAndClose(inputStream, outputStream);
            copiedFilePath = tempZipFile.getName().getPath();
        }
        catch (IOException ioe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RegisterPackageServlet.Exception.CopyRequest", (String[])new String[]{directory}), (Throwable)ioe);
        }
        return copiedFilePath;
    }

    protected void copyAndClose(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        outputStream.flush();
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    protected String extract(String zipFilePath) throws KettleException {
        File fileZip = new File(zipFilePath);
        File parentDir = fileZip.getParentFile();
        this.extract(fileZip.getPath(), parentDir.getPath());
        return parentDir.toString();
    }

    protected void extract(String zipFilePath, String destinationDirectory) throws KettleException {
        RegisterPackageServlet.getZipService().extract(zipFilePath, destinationDirectory);
    }

    protected void deleteArchive(String file) {
        FileUtils.deleteQuietly((File)new File(file));
    }

    protected static void setZipService(ZipService aZipService) {
        zipService = aZipService;
    }

    protected static ZipService getZipService() {
        return zipService;
    }
}

