/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.encoder.Encode;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.pentaho.di.www.SlaveServerStatus;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.pentaho.di.www.StatusServletUtils;
import org.pentaho.di.www.TransformationMap;

public class GetStatusServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static final Class<?> PKG = GetStatusServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/status";

    public GetStatusServlet() {
    }

    public GetStatusServlet(TransformationMap transformationMap, JobMap jobMap) {
        super(transformationMap, jobMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetStatusServlet.StatusRequested", (String[])new String[0]));
        }
        response.setStatus(200);
        String root = request.getRequestURI() == null ? "/pentaho" : request.getRequestURI().substring(0, request.getRequestURI().indexOf(CONTEXT_PATH));
        String prefix = this.isJettyMode() ? "/static" : root + "/content/common-ui/resources/themes";
        prefix = this.encodeUriComponents(prefix);
        root = this.encodeUriComponents(root);
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        boolean useLightTheme = "Y".equalsIgnoreCase(request.getParameter("useLightTheme"));
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
        PrintWriter out = response.getWriter();
        List<CarteObjectEntry> transEntries = this.getTransformationMap().getTransformationObjects();
        List<CarteObjectEntry> jobEntries = this.getJobMap().getJobObjects();
        if (useXML) {
            String status;
            out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            SlaveServerStatus serverStatus = new SlaveServerStatus();
            serverStatus.setStatusDescription("Online");
            GetStatusServlet.getSystemInfo(serverStatus);
            for (CarteObjectEntry entry : transEntries) {
                Trans trans = this.getTransformationMap().getTransformation(entry);
                if (trans == null) continue;
                status = trans.getStatus();
                SlaveServerTransStatus sstatus = new SlaveServerTransStatus(entry.getName(), entry.getId(), status);
                sstatus.setLogDate(trans.getLogDate());
                sstatus.setPaused(trans.isPaused());
                serverStatus.getTransStatusList().add(sstatus);
            }
            for (CarteObjectEntry entry : jobEntries) {
                Job job = this.getJobMap().getJob(entry);
                if (job == null) continue;
                status = job.getStatus();
                SlaveServerJobStatus jobStatus = new SlaveServerJobStatus(entry.getName(), entry.getId(), status);
                jobStatus.setLogDate(job.getLogDate());
                serverStatus.getJobStatusList().add(jobStatus);
            }
            try {
                out.println(serverStatus.getXML());
            }
            catch (KettleException e) {
                throw new ServletException("Unable to get the server status in XML format", (Throwable)e);
            }
        }
        out.println("<HTML>");
        out.println("<HEAD><TITLE>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.KettleSlaveServerStatus", (String[])new String[0]) + "</TITLE>");
        out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        int tableBorder = 1;
        if (!useLightTheme) {
            if (this.isJettyMode()) {
                out.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/css/carte.css\" />");
            } else {
                out.print(StatusServletUtils.getPentahoStyles(root));
                out.println("<style>");
                out.println(".pentaho-table td, tr.cellTableRow, td.gwt-MenuItem, .toolbar-button:not(.toolbar-button-disabled) {");
                out.println("  cursor: pointer;");
                out.println("}");
                out.println(".toolbar-button-disabled {");
                out.println("  opacity: 0.4;");
                out.println("}");
                out.println("div#messageDialogBody:first-letter {");
                out.println("  text-transform: capitalize;");
                out.println("}");
                out.println("</style>");
            }
            tableBorder = 0;
        }
        out.println("</HEAD>");
        out.println("<BODY class=\"pentaho-page-background dragdrop-dropTarget dragdrop-boundary\" style=\"overflow: auto;\">");
        out.println("<div id=\"selectedTableItem\">");
        out.println("<value></value>");
        out.println("</div>");
        out.println("<div class=\"row\" id=\"pucHeader\">");
        String htmlClass = useLightTheme ? "h1" : "div";
        out.println("<" + htmlClass + " class=\"workspaceHeading\" style=\"padding: 0px 0px 0px 10px;\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TopStatus", (String[])new String[0]) + "</" + htmlClass + ">");
        out.println("</div>");
        String run = BaseMessages.getString(PKG, (String)"CarteStatusServlet.Run", (String[])new String[0]);
        String stop = BaseMessages.getString(PKG, (String)"CarteStatusServlet.StopTrans", (String[])new String[0]);
        String view = BaseMessages.getString(PKG, (String)"CarteStatusServlet.ViewTransDetails", (String[])new String[0]);
        String remove = BaseMessages.getString(PKG, (String)"CarteStatusServlet.RemoveTrans", (String[])new String[0]);
        String runJ = BaseMessages.getString(PKG, (String)"CarteStatusServlet.Run", (String[])new String[0]);
        String stopJ = BaseMessages.getString(PKG, (String)"CarteStatusServlet.StopJob", (String[])new String[0]);
        String viewJ = BaseMessages.getString(PKG, (String)"CarteStatusServlet.ViewJobDetails", (String[])new String[0]);
        String removeJ = BaseMessages.getString(PKG, (String)"CarteStatusServlet.RemoveJob", (String[])new String[0]);
        try {
            out.println("<div class=\"row\" style=\"padding: 0px 0px 0px 30px\">");
            htmlClass = useLightTheme ? "h2" : "div";
            out.println("<div class=\"row\" style=\"padding: 25px 30px 75px 0px;\">");
            out.println("<" + htmlClass + " class=\"workspaceHeading\" style=\"padding: 0px 0px 0px 0px;\">Transformations</" + htmlClass + ">");
            out.println("<table id=\"trans-table\" cellspacing=\"0\" cellpadding=\"0\"><tbody><tr><td align=\"left\" width=\"100%\" style=\"vertical-align:middle;\">");
            out.println("<table cellspacing=\"0\" cellpadding=\"0\" class=\"toolbar\" style=\"width: 100%; height: 26px; margin-bottom: 2px; border: 0;\">");
            out.println("<tbody><tr>");
            out.println("<td align=\"left\" style=\"vertical-align: middle; width: 100%\" id=\"trans-align\"></td>");
            out.println("<td " + this.setupIconEnterLeaveJavascript("run-pause") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"runPauseFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"run-pause\"><img style=\"width: 22px; height: 22px\" src=\"" + prefix + "/images/run.svg\" title=\"" + run + "\"/></div></td>");
            out.println("<td " + this.setupIconEnterLeaveJavascript("stop") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"stopFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"stop\"><img style=\"width: 22px; height: 22px\"src=\"" + prefix + "/images/stop.svg\" title=\"" + stop + "\"/></div></td>");
            out.println("<td " + this.setupIconEnterLeaveJavascript("view") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"viewFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"view\"><img style=\"width: 22px; height: 22px\" src=\"" + prefix + "/images/view.svg\" title=\"" + view + "\"/></div></td>");
            out.println("<td " + this.setupIconEnterLeaveJavascript("close") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px; margin-right: 10px;\" onClick=\"removeFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"close\"><img style=\"width: 22px; height: 22px\" src=\"" + prefix + "/images/close.svg\" title=\"" + remove + "\"/></div></td>");
            out.println("</tr></tbody></table>");
            out.println("<div id=\"stopActions\" class=\"custom-dropdown-popup\" style=\"visibility: hidden; overflow: visible; position: fixed;\" onLoad=\"repositionActions( this, document.getElementById( 'stop' ) )\" onMouseLeave=\"this.style='visibility: hidden; overflow: visible; position: fixed;'\"><div class=\"popupContent\"><div style=\"padding: 0;\" class=\"gwt-MenuBar gwt-MenuBar-vertical\"><table><tbody><tr><td class=\"gwt-MenuItem\" onClick=\"stopTransSelector( this )\" onMouseEnter=\"this.className='gwt-MenuItem gwt-MenuItem-selected'\" onMouseLeave=\"this.className='gwt-MenuItem'\">Stop transformation</td></tr><tr><td class=\"gwt-MenuItem\" onClick=\"stopTransSelector( this )\" onMouseEnter=\"this.className='gwt-MenuItem gwt-MenuItem-selected'\" onMouseLeave=\"this.className='gwt-MenuItem'\">Stop input processing</td></tr></tbody></table></div></div></div>");
            out.println(this.messageDialog());
            out.println("<table class=\"pentaho-table\" border=\"" + tableBorder + "\">");
            out.print("<tr> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TransName", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.CarteId", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Status", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.LastLogDate", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.LastLogTime", (String[])new String[0]) + "</th> </tr>");
            Comparator transComparator = (o1, o2) -> {
                int logDateCompare;
                Trans t1 = this.getTransformationMap().getTransformation((CarteObjectEntry)o1);
                Trans t2 = this.getTransformationMap().getTransformation((CarteObjectEntry)o2);
                if (t1 == null && t2 == null) {
                    return 0;
                }
                if (t1 == null) {
                    return 1;
                }
                if (t2 == null) {
                    return -1;
                }
                Date d1 = t1.getLogDate();
                Date d2 = t2.getLogDate();
                if (d1 != null && d2 != null && (logDateCompare = d2.compareTo(d1)) != 0) {
                    return logDateCompare;
                }
                return o1.compareTo((CarteObjectEntry)o2);
            };
            Collections.sort(transEntries, transComparator);
            boolean evenRow = true;
            for (int i = 0; i < transEntries.size(); ++i) {
                String name = Encode.forHtml((String)transEntries.get(i).getName());
                String id = Encode.forHtml((String)transEntries.get(i).getId());
                Trans trans = this.getTransformationMap().getTransformation(transEntries.get(i));
                if (trans == null) continue;
                String status = Encode.forHtml((String)trans.getStatus());
                String trClass = evenRow ? "cellTableEvenRow" : "cellTableOddRow";
                String tdClass = evenRow ? "cellTableEvenRowCell" : "cellTableOddRowCell";
                evenRow = !evenRow;
                out.print("<tr onMouseEnter=\"mouseEnterFunction( this, '" + trClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + trClass + "' )\" onClick=\"clickFunction( this, '" + trClass + "' )\" id=\"cellTableRow_" + i + "\" class=\"" + trClass + "\">");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"cellTableFirstCell_" + i + "\" class=\"cellTableCell cellTableFirstColumn " + tdClass + "\">" + name + "</td>");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"cellTableCell_" + i + "\" class=\"cellTableCell " + tdClass + "\">" + id + "</td>");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"cellTableCellStatus_" + i + "\" class=\"cellTableCell " + tdClass + "\">" + status + "</td>");
                String dateStr = XMLHandler.date2string((Date)trans.getLogDate());
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"cellTableCell_" + i + "\" class=\"cellTableCell " + tdClass + "\">" + (trans.getLogDate() == null ? "-" : dateStr.substring(0, dateStr.indexOf(32))) + "</td>");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"cellTableLastCell_" + i + "\" class=\"cellTableCell cellTableLastColumn " + tdClass + "\">" + (trans.getLogDate() == null ? "-" : dateStr.substring(dateStr.indexOf(32), dateStr.length())) + "</td>");
                out.print("</tr>");
            }
            out.print("</table></table>");
            out.print("</div>");
            out.println("<div class=\"row\" style=\"padding: 0px 30px 75px 0px;\">");
            out.println("<" + htmlClass + " class=\"workspaceHeading\" style=\"padding: 0px 0px 0px 0px;\">Jobs</" + htmlClass + ">");
            out.println("<table cellspacing=\"0\" cellpadding=\"0\"><tbody><tr><td align=\"left\" width=\"100%\" style=\"vertical-align:middle;\">");
            out.println("<table cellspacing=\"0\" cellpadding=\"0\" class=\"toolbar\" style=\"width: 100%; height: 26px; margin-bottom: 2px; border: 0;\">");
            out.println("<tbody><tr>");
            out.println("<td align=\"left\" style=\"vertical-align: middle; width: 100%\"></td>");
            out.println("<td " + this.setupIconEnterLeaveJavascript("j-run-pause") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"runPauseFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"j-run-pause\"><img style=\"width: 22px; height: 22px\" src=\"" + prefix + "/images/run.svg\" title=\"" + runJ + "\"/></div></td>");
            out.println("<td " + this.setupIconEnterLeaveJavascript("j-stop") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"stopFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"j-stop\"><img style=\"width: 22px; height: 22px\"src=\"" + prefix + "/images/stop.svg\" title=\"" + stopJ + "\"/></div></td>");
            out.println("<td " + this.setupIconEnterLeaveJavascript("j-view") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"viewFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"j-view\"><img style=\"width: 22px; height: 22px\" src=\"" + prefix + "/images/view.svg\" title=\"" + viewJ + "\"/></div></td>");
            out.println("<td " + this.setupIconEnterLeaveJavascript("j-close") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px; margin-right: 10px;\" onClick=\"removeFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"j-close\"><img style=\"width: 22px; height: 22px\" src=\"" + prefix + "/images/close.svg\" title=\"" + removeJ + "\"/></div></td>");
            out.println("</tr></tbody></table>");
            out.println("<table class=\"pentaho-table\" border=\"" + tableBorder + "\">");
            out.print("<tr> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.JobName", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.CarteId", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Status", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.LastLogDate", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.LastLogTime", (String[])new String[0]) + "</th> </tr>");
            Comparator jobComparator = (o1, o2) -> {
                int logDateCompare;
                Job t1 = this.getJobMap().getJob((CarteObjectEntry)o1);
                Job t2 = this.getJobMap().getJob((CarteObjectEntry)o2);
                if (t1 == null && t2 == null) {
                    return 0;
                }
                if (t1 == null) {
                    return 1;
                }
                if (t2 == null) {
                    return -1;
                }
                Date d1 = t1.getLogDate();
                Date d2 = t2.getLogDate();
                if (d1 != null && d2 != null && (logDateCompare = d2.compareTo(d1)) != 0) {
                    return logDateCompare;
                }
                return o1.compareTo((CarteObjectEntry)o2);
            };
            Collections.sort(jobEntries, jobComparator);
            evenRow = true;
            for (int i = 0; i < jobEntries.size(); ++i) {
                String name = Encode.forHtml((String)jobEntries.get(i).getName());
                String id = Encode.forHtml((String)jobEntries.get(i).getId());
                Job job = this.getJobMap().getJob(jobEntries.get(i));
                if (job == null) continue;
                String status = Encode.forHtml((String)job.getStatus());
                String trClass = evenRow ? "cellTableEvenRow" : "cellTableOddRow";
                String tdClass = evenRow ? "cellTableEvenRowCell" : "cellTableOddRowCell";
                evenRow = !evenRow;
                out.print("<tr onMouseEnter=\"mouseEnterFunction( this, '" + trClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + trClass + "' )\" onClick=\"clickFunction( this, '" + trClass + "' )\" id=\"j-cellTableRow_" + i + "\" class=\"cellTableCell " + trClass + "\">");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"j-cellTableFirstCell_" + i + "\" class=\"cellTableCell cellTableFirstColumn " + tdClass + "\">" + name + "</a></td>");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"j-cellTableCell_" + i + "\" class=\"cellTableCell " + tdClass + "\">" + id + "</td>");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"j-cellTableCell_" + i + "\" class=\"cellTableCell " + tdClass + "\">" + status + "</td>");
                String dateStr = XMLHandler.date2string((Date)job.getLogDate());
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"j-cellTableCell_" + i + "\" class=\"cellTableCell " + tdClass + "\">" + (job.getLogDate() == null ? "-" : dateStr.substring(0, dateStr.indexOf(32))) + "</td>");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"j-cellTableLastCell_" + i + "\" class=\"cellTableCell cellTableLastColumn " + tdClass + "\">" + (job.getLogDate() == null ? "-" : dateStr.substring(dateStr.indexOf(32), dateStr.length())) + "</td>");
                out.print("</tr>");
            }
            out.print("</table></table>");
            out.print("</div>");
        }
        catch (Exception ex) {
            out.println("<pre>");
            ex.printStackTrace(out);
            out.println("</pre>");
        }
        out.println("<div class=\"row\" style=\"padding: 0px 0px 30px 0px;\">");
        htmlClass = useLightTheme ? "h3" : "div";
        out.println("<div><" + htmlClass + " class=\"workspaceHeading\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ConfigurationDetails.Title", (String[])new String[0]) + "</" + htmlClass + "></div>");
        out.println("<table border=\"" + tableBorder + "\">");
        SlaveServerConfig serverConfig = this.getTransformationMap().getSlaveServerConfig();
        if (serverConfig != null) {
            String repositoryName;
            String maxLines = "";
            maxLines = serverConfig.getMaxLogLines() == 0 ? BaseMessages.getString(PKG, (String)"GetStatusServlet.NoLimit", (String[])new String[0]) : serverConfig.getMaxLogLines() + BaseMessages.getString(PKG, (String)"GetStatusServlet.Lines", (String[])new String[0]);
            out.print("<tr style=\"font-size: 12;\"> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableFirstColumn\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.MaxLogLines", (String[])new String[0]) + "</td> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableLastColumn\">" + maxLines + "</td> </tr>");
            String maxAge = "";
            maxAge = serverConfig.getMaxLogTimeoutMinutes() == 0 ? BaseMessages.getString(PKG, (String)"GetStatusServlet.NoLimit", (String[])new String[0]) : serverConfig.getMaxLogTimeoutMinutes() + BaseMessages.getString(PKG, (String)"GetStatusServlet.Minutes", (String[])new String[0]);
            out.print("<tr style=\"font-size: 12;\"> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableFirstColumn\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.MaxLogLinesAge", (String[])new String[0]) + "</td> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableLastColumn\">" + maxAge + "</td> </tr>");
            String maxObjAge = "";
            maxObjAge = serverConfig.getObjectTimeoutMinutes() == 0 ? BaseMessages.getString(PKG, (String)"GetStatusServlet.NoLimit", (String[])new String[0]) : serverConfig.getObjectTimeoutMinutes() + BaseMessages.getString(PKG, (String)"GetStatusServlet.Minutes", (String[])new String[0]);
            out.print("<tr style=\"font-size: 12;\"> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableFirstColumn\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.MaxObjectsAge", (String[])new String[0]) + "</td> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableLastColumn\">" + maxObjAge + "</td> </tr>");
            try {
                repositoryName = serverConfig.getRepository() != null ? serverConfig.getRepository().getName() : "";
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.RepositoryName.UnableToConnect", (String[])new String[]{serverConfig.getRepositoryId()}), e);
                repositoryName = BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.RepositoryName.UnableToConnect", (String[])new String[]{serverConfig.getRepositoryId()});
            }
            out.print("<tr style=\"font-size: 12;\"> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableFirstColumn\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.RepositoryName", (String[])new String[0]) + "</td> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableLastColumn\">" + repositoryName + "</td> </tr>");
            out.print("</table>");
            String filename = serverConfig.getFilename();
            if (filename == null) {
                filename = BaseMessages.getString(PKG, (String)"GetStatusServlet.ConfigurationDetails.UsingDefaults", (String[])new String[0]);
            }
            out.println("</div>");
            out.print("<div class=\"row\">");
            out.println("<i>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ConfigurationDetails.Advice", (String[])new String[]{filename}) + "</i>");
            out.print("</div>");
            out.print("</div>");
            out.print("</div>");
        }
        out.println("<script type=\"text/javascript\">");
        out.println("if (!String.prototype.endsWith) {");
        out.println("  String.prototype.endsWith = function(suffix) {");
        out.println("    return this.indexOf(suffix, this.length - suffix.length) !== -1;");
        out.println("  };");
        out.println("}");
        out.println("if (!String.prototype.startsWith) {");
        out.println("  String.prototype.startsWith = function(searchString, position) {");
        out.println("    position = position || 0;");
        out.println("    return this.indexOf(searchString, position) === position;");
        out.println("  };");
        out.println("}");
        out.println("var selectedTransRowIndex = -1;");
        out.println("var selectedJobRowIndex = -1;");
        out.println("var removeElement = null;");
        out.println("var selectedTransName = \"\";");
        out.println("var selectedJobName = \"\";");
        out.println("function repositionActions( element, elementFrom ) {");
        out.println("element.style.left = ( 10 + elementFrom.getBoundingClientRect().left ) + 'px';");
        out.println("}");
        out.println("function runPauseFunction( element ) {");
        out.println("if( !element.classList.contains('toolbar-button-disabled') ) {");
        out.println("if( element.id.startsWith( 'j-' ) && selectedJobRowIndex != -1 ) {");
        out.println(this.setupAjaxCall(this.setupJobURI(this.convertContextPath("/kettle/startJob")), BaseMessages.getString(PKG, (String)"GetStatusServlet.StartJob.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheJob.Label", (String[])new String[0]) + " ' + selectedJobName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StartJob.Success.Body", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheJob.Label", (String[])new String[0]) + " ' + selectedJobName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StartJob.Failure.Body", (String[])new String[0]) + "'"));
        out.println("} else if ( !element.id.startsWith( 'j-' ) && selectedTransRowIndex != -1 && document.getElementById( 'cellTableCellStatus_' + selectedTransRowIndex ).innerHTML == 'Running') {");
        out.println(this.setupAjaxCall(this.setupTransURI(this.convertContextPath("/kettle/pauseTrans")), BaseMessages.getString(PKG, (String)"GetStatusServlet.PauseTrans.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheTransformation.Label", (String[])new String[0]) + " ' + selectedTransName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.PauseTrans.Success.Body", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheTransformation.Label", (String[])new String[0]) + " ' + selectedTransName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.PauseTrans.Failure.Body", (String[])new String[0]) + "'"));
        out.println("} else if( !element.id.startsWith( 'j-' ) && selectedTransRowIndex != -1 && document.getElementById( 'cellTableCellStatus_' + selectedTransRowIndex ).innerHTML == 'Paused') {");
        out.println(this.setupAjaxCall(this.setupTransURI(this.convertContextPath("/kettle/pauseTrans")), BaseMessages.getString(PKG, (String)"GetStatusServlet.ResumeTrans.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheTransformation.Label", (String[])new String[0]) + " ' + selectedTransName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.ResumeTrans.Success.Body", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheTransformation.Label", (String[])new String[0]) + " ' + selectedTransName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.ResumeTrans.Failure.Body", (String[])new String[0]) + "'"));
        out.println("} else if( !element.id.startsWith( 'j-' ) && selectedTransRowIndex != -1 ){");
        out.println(this.setupAjaxCall(this.setupTransURI(this.convertContextPath("/kettle/startTrans")), BaseMessages.getString(PKG, (String)"GetStatusServlet.StartTrans.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheTransformation.Label", (String[])new String[0]) + " ' + selectedTransName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StartTrans.Success.Body", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheTransformation.Label", (String[])new String[0]) + " ' + selectedTransName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StartTrans.Failure.Body", (String[])new String[0]) + "'"));
        out.println("}");
        out.println("}");
        out.println("}");
        out.println("function stopFunction( element ) {");
        out.println("if( !element.classList.contains('toolbar-button-disabled') ) {");
        out.println("if( element.id.startsWith( 'j-' ) && selectedJobRowIndex != -1 ) {");
        out.println(this.setupAjaxCall(this.setupJobURI(this.convertContextPath("/kettle/stopJob")), BaseMessages.getString(PKG, (String)"GetStatusServlet.StopJob.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopJob.Success.Body1", (String[])new String[0]) + " " + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheJob.Label", (String[])new String[0]) + " ' + selectedJobName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopJob.Success.Body2", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheJob.Label", (String[])new String[0]) + " ' + selectedJobName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopJob.Failure.Body", (String[])new String[0]) + "'"));
        out.println("} else if ( !element.id.startsWith( 'j-' ) && selectedTransRowIndex != -1 ) {");
        out.println("repositionActions( document.getElementById( 'stopActions' ), element );");
        out.println("document.getElementById( 'stopActions' ).style.visibility = 'visible';");
        out.println("}");
        out.println("}");
        out.println("}");
        out.println("function stopTransSelector( element ) {");
        out.println("if( element.innerHTML == 'Stop transformation' ) {");
        out.println(this.setupAjaxCall(this.setupTransURI(this.convertContextPath("/kettle/stopTrans")), BaseMessages.getString(PKG, (String)"GetStatusServlet.StopTrans.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopTrans.Success.Body1", (String[])new String[0]) + " " + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheTransformation.Label", (String[])new String[0]) + " ' + selectedTransName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopTrans.Success.Body2", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheTransformation.Label", (String[])new String[0]) + " ' + selectedTransName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopTrans.Failure.Body", (String[])new String[0]) + "'"));
        out.println("} else if( element.innerHTML == 'Stop input processing' ) {");
        out.println(this.setupAjaxCall(this.setupTransURI(this.convertContextPath("/kettle/stopTrans")) + " + '&inputOnly=Y'", BaseMessages.getString(PKG, (String)"GetStatusServlet.StopInputTrans.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopInputTrans.Success.Body1", (String[])new String[0]) + " " + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheTransformation.Label", (String[])new String[0]) + " ' + selectedTransName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopInputTrans.Success.Body2", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheTransformation.Label", (String[])new String[0]) + " ' + selectedTransName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopInputTrans.Failure.Body", (String[])new String[0]) + "'"));
        out.println("}");
        out.println("document.getElementById( 'stopActions' ).style.visibility = 'hidden';");
        out.println("}");
        out.println("function viewFunction( element ) {");
        out.println("if( !element.classList.contains('toolbar-button-disabled') ) {");
        out.println("if( element.id.startsWith( 'j-' ) && selectedJobRowIndex != -1 ) {");
        out.println("window.location.replace( '" + this.convertContextPath("/kettle/jobStatus") + "' + '?name=' + encodeURIComponent(document.getElementById( 'j-cellTableFirstCell_' + selectedJobRowIndex ).innerText) + '&id=' + document.getElementById( 'j-cellTableCell_' + selectedJobRowIndex ).innerHTML + '&from=9999999' );");
        out.println("} else if ( selectedTransRowIndex != -1 ) {");
        out.println("window.location.replace( '" + this.convertContextPath("/kettle/transStatus") + "' + '?name=' + encodeURIComponent(document.getElementById( 'cellTableFirstCell_' + selectedTransRowIndex ).innerText) + '&id=' + document.getElementById( 'cellTableCell_' + selectedTransRowIndex ).innerText );");
        out.println("}");
        out.println("}");
        out.println("}");
        out.println("function removeFunction( element ) {");
        out.println("if( !element.classList.contains('toolbar-button-disabled') ) {");
        out.println("removeElement = element;");
        out.println("if( element.id.startsWith( 'j-' ) && selectedJobRowIndex != -1 ) {");
        out.println("openMessageDialog( '" + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemoveJob.Title", (String[])new String[0]) + "','" + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemoveJob.Confirm.Body", (String[])new String[0]) + " " + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheJob.Label", (String[])new String[0]) + " ' + selectedJobName + '?', false );");
        out.println("} else if ( selectedTransRowIndex != -1 ) {");
        out.println("openMessageDialog( '" + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemoveTrans.Title", (String[])new String[0]) + "','" + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemoveTrans.Confirm.Body", (String[])new String[0]) + " " + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheTransformation.Label", (String[])new String[0]) + " ' + selectedTransName + '?', false );");
        out.println("}");
        out.println("}");
        out.println("}");
        out.println("function clickFunction( element, tableClass ) {");
        out.println("var prefix = element.id.startsWith( 'j-' ) ? 'j-' : '';");
        out.println("var rowNum = getRowNum( element.id );");
        out.println("if( tableClass.endsWith( 'Row' ) ) {");
        out.println("element.className='cellTableRow ' + tableClass + ' cellTableSelectedRow';");
        out.println("} else {");
        out.println("document.getElementById( prefix + 'cellTableFirstCell_' + rowNum ).className='cellTableCell cellTableFirstColumn ' + tableClass + ' cellTableSelectedRowCell';");
        out.println("element.className='cellTableCell ' + tableClass + ' cellTableSelectedRowCell';");
        out.println("}");
        out.println("if( element.id.startsWith( 'j-' ) ) {");
        out.println("document.getElementById( \"j-run-pause\" ).classList.remove( \"toolbar-button-disabled\" )");
        out.println("document.getElementById( \"j-stop\" ).classList.remove( \"toolbar-button-disabled\" )");
        out.println("document.getElementById( \"j-view\" ).classList.remove( \"toolbar-button-disabled\" )");
        out.println("document.getElementById( \"j-close\" ).classList.remove( \"toolbar-button-disabled\" )");
        out.println("if( selectedJobRowIndex != -1 && rowNum != selectedJobRowIndex ) {");
        out.println("document.getElementById( prefix + 'cellTableRow_' + selectedJobRowIndex ).className='cellTableRow ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableFirstCell_' + selectedJobRowIndex ).className='cellTableCell cellTableFirstColumn ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableCell_' + selectedJobRowIndex ).className='cellTableCell ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableLastCell_' + selectedJobRowIndex ).className='cellTableCell cellTableLastColumn ' + tableClass;");
        out.println("}");
        out.println("selectedJobRowIndex = rowNum;");
        out.println("} else {");
        out.println("document.getElementById( \"run-pause\" ).classList.remove( \"toolbar-button-disabled\" )");
        out.println("document.getElementById( \"stop\" ).classList.remove( \"toolbar-button-disabled\" )");
        out.println("document.getElementById( \"view\" ).classList.remove( \"toolbar-button-disabled\" )");
        out.println("document.getElementById( \"close\" ).classList.remove( \"toolbar-button-disabled\" )");
        out.println("if( selectedTransRowIndex != -1 && rowNum != selectedTransRowIndex ) {");
        out.println("document.getElementById( prefix + 'cellTableRow_' + selectedTransRowIndex ).className='cellTableRow ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableFirstCell_' + selectedTransRowIndex ).className='cellTableCell cellTableFirstColumn ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableCell_' + selectedTransRowIndex ).className='cellTableCell ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableLastCell_' + selectedTransRowIndex ).className='cellTableCell cellTableLastColumn ' + tableClass;");
        out.println("}");
        out.println("selectedTransRowIndex = rowNum;");
        out.println("if( document.getElementById( 'cellTableCellStatus_' + selectedTransRowIndex ).innerHTML == 'Running' ) {");
        out.println("document.getElementById( 'run-pause' ).innerHTML = '<img style=\"width: 22px; height: 22px\" src=\"" + prefix + "/images/pause.svg\"/ title=\"" + BaseMessages.getString(PKG, (String)"GetStatusServlet.PauseTrans", (String[])new String[0]) + "\">';");
        out.println("} else if( document.getElementById( 'cellTableCellStatus_' + selectedTransRowIndex ).innerHTML == 'Paused' ) {");
        out.println("document.getElementById( 'run-pause' ).innerHTML = '<img style=\"width: 22px; height: 22px\" src=\"" + prefix + "/images/pause.svg\" title=\"" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ResumeTrans", (String[])new String[0]) + "\"/>';");
        out.println("} else {");
        out.println("document.getElementById( 'run-pause' ).innerHTML = '<img style=\"width: 22px; height: 22px\" src=\"" + prefix + "/images/run.svg\" title=\"" + run + "\"/>';");
        out.println("}");
        out.println("}");
        out.println("setSelectedNames();");
        out.println("}");
        out.println("function setSelectedNames() {");
        out.println("  selectedJobName = selectedTransName = \"\";");
        out.println("  var selectedElementNames = document.getElementsByClassName( \"cellTableFirstColumn cellTableSelectedRowCell\" );");
        out.println("  if( selectedElementNames ) {");
        out.println("    for(var i = 0; i < selectedElementNames.length; i++) {");
        out.println("      if(selectedElementNames[i].id.startsWith(\"j-\")) {");
        out.println("        selectedJobName = selectedElementNames[i].innerHTML;");
        out.println("      } else {");
        out.println("        selectedTransName = selectedElementNames[i].innerHTML;");
        out.println("      }");
        out.println("    }");
        out.println("  }");
        out.println("}");
        out.println("function mouseEnterFunction( element, tableClass ) {");
        out.println("var prefix = '';");
        out.println("var rowNum = getRowNum( element.id );");
        out.println("var selectedIndex = selectedTransRowIndex;");
        out.println("if( element.id.startsWith( 'j-' ) ) {");
        out.println("prefix = 'j-';");
        out.println("selectedIndex = selectedJobRowIndex;");
        out.println("}");
        out.println("if( rowNum != selectedIndex ) {");
        out.println("if( tableClass.endsWith( 'Row' ) ) {");
        out.println("element.className='cellTableRow ' + tableClass + ' cellTableHoveredRow';");
        out.println("} else {");
        out.println("document.getElementById( prefix + 'cellTableFirstCell_' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell cellTableFirstColumn ' + tableClass + ' cellTableHoveredRowCell';");
        out.println("document.getElementById( prefix + 'cellTableCell_' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell ' + tableClass + ' cellTableHoveredRowCell';");
        out.println("document.getElementById( prefix + 'cellTableLastCell_' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell cellTableLastColumn ' + tableClass + ' cellTableHoveredRowCell';");
        out.println("}");
        out.println("}");
        out.println("}");
        out.println("function mouseLeaveFunction( element, tableClass ) {");
        out.println("var prefix = '';");
        out.println("var rowNum = getRowNum( element.id );");
        out.println("var selectedIndex = selectedTransRowIndex;");
        out.println("if( element.id.startsWith( 'j-' ) ) {");
        out.println("prefix = 'j-';");
        out.println("selectedIndex = selectedJobRowIndex;");
        out.println("}");
        out.println("if( rowNum != selectedIndex ) {");
        out.println("if( tableClass.endsWith( 'Row' ) ) {");
        out.println("element.className='cellTableRow ' + tableClass;");
        out.println("} else {");
        out.println("document.getElementById( prefix + 'cellTableFirstCell_' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell cellTableFirstColumn ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableCell_' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableLastCell_' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell cellTableLastColumn ' + tableClass;");
        out.println("}");
        out.println("}");
        out.println("}");
        out.println("function closeMessageDialog( refresh ) {");
        out.println("  document.getElementById( \"messageDialogBackdrop\" ).style.visibility = 'hidden';");
        out.println("  document.getElementById( \"messageDialog\" ).style.visibility = 'hidden';");
        out.println("  if( refresh ) {");
        out.println("    window.location.reload();");
        out.println("  }");
        out.println("}");
        out.println("function openMessageDialog( title, body, single ) {");
        out.println("  document.getElementById( \"messageDialogBackdrop\" ).style.visibility = 'visible';");
        out.println("  document.getElementById( \"messageDialog\" ).style.visibility = 'visible';");
        out.println("  document.getElementById( \"messageDialogTitle\" ).innerHTML = title;");
        out.println("  document.getElementById( \"messageDialogBody\" ).innerHTML = body;");
        out.println("  if( single ) {");
        out.println("    document.getElementById( \"singleButton\" ).style.display = 'block';");
        out.println("    document.getElementById( \"doubleButton\" ).style.display = 'none';");
        out.println("  } else {");
        out.println("    document.getElementById( \"singleButton\" ).style.display = 'none';");
        out.println("    document.getElementById( \"doubleButton\" ).style.display = 'block';");
        out.println("  }");
        out.println("}");
        out.println("function removeSelection() {");
        out.println("  if( removeElement !== null ) {");
        out.println("    if( removeElement.id.startsWith( 'j-' ) && selectedJobRowIndex != -1 ) {");
        out.println(this.setupAjaxCall(this.setupJobURI(this.convertContextPath("/kettle/removeJob")), BaseMessages.getString(PKG, (String)"GetStatusServlet.RemoveJob.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheJob.Label", (String[])new String[0]) + " ' + selectedJobName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemoveJob.Success.Body", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheJob.Label", (String[])new String[0]) + " ' + selectedJobName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemoveJob.Failure.Body", (String[])new String[0]) + "'"));
        out.println("} else if ( selectedTransRowIndex != -1 ) {");
        out.println(this.setupAjaxCall(this.setupTransURI(this.convertContextPath("/kettle/removeTrans")), BaseMessages.getString(PKG, (String)"GetStatusServlet.RemoveTrans.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheTransformation.Label", (String[])new String[0]) + " ' + selectedTransName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemoveTrans.Success.Body", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheTransformation.Label", (String[])new String[0]) + " ' + selectedTransName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemoveTrans.Failure.Body", (String[])new String[0]) + "'"));
        out.println("    }");
        out.println("  }");
        out.println("}");
        out.println("function getRowNum( id ) {");
        out.println("  return id.substring( id.indexOf('_') + 1, id.length);");
        out.println("}");
        out.println("</script>");
        out.println("</BODY>");
        out.println("</HTML>");
    }

    private String encodeUriComponents(String path) {
        return Arrays.stream(path.split("/")).map(Encode::forUriComponent).collect(Collectors.joining("/"));
    }

    private static void getSystemInfo(SlaveServerStatus serverStatus) {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        int cores = Runtime.getRuntime().availableProcessors();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        String osArch = operatingSystemMXBean.getArch();
        String osName = operatingSystemMXBean.getName();
        String osVersion = operatingSystemMXBean.getVersion();
        double loadAvg = operatingSystemMXBean.getSystemLoadAverage();
        int threadCount = threadMXBean.getThreadCount();
        long allThreadsCpuTime = 0L;
        long[] threadIds = threadMXBean.getAllThreadIds();
        for (int i = 0; i < threadIds.length; ++i) {
            allThreadsCpuTime += threadMXBean.getThreadCpuTime(threadIds[i]);
        }
        long uptime = runtimeMXBean.getUptime();
        serverStatus.setCpuCores(cores);
        serverStatus.setCpuProcessTime(allThreadsCpuTime);
        serverStatus.setUptime(uptime);
        serverStatus.setThreadCount(threadCount);
        serverStatus.setLoadAvg(loadAvg);
        serverStatus.setOsName(osName);
        serverStatus.setOsVersion(osVersion);
        serverStatus.setOsArchitecture(osArch);
        serverStatus.setMemoryFree(freeMemory);
        serverStatus.setMemoryTotal(totalMemory);
    }

    public String toString() {
        return "Status Handler";
    }

    @Override
    public String getService() {
        return "/kettle/status (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    private String setupIconEnterLeaveJavascript(String id) {
        return "onMouseEnter=\"if( !document.getElementById('" + id + "').classList.contains('toolbar-button-disabled') ) { document.getElementById('" + id + "').classList.add('toolbar-button-hovering') }\" onMouseLeave=\"document.getElementById('" + id + "').classList.remove('toolbar-button-hovering')\"";
    }

    private String messageDialog() {
        String retVal = "<div id=\"messageDialogBackdrop\" style=\"visibility: hidden; position: absolute; top: 0; right: 0; bottom: 0; left: 0; opacity: 0.5; background-color: #000; z-index: 1000;\"></div>\n";
        retVal = retVal + "<div class=\"pentaho-dialog\" id=\"messageDialog\" style=\"visibility: hidden; margin: 0; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); -ms-transform: translate(-50%, -50%);-webkit-transform: translate(-50%, -50%); padding: 30px; height: auto; width: 423px; border: 1px solid #CCC; -webkit-box-shadow: none; -moz-box-shadow: none;box-shadow: none; -webkit-box-sizing: border-box; -moz-box-sizing: border-box; box-sizing: border-box; overflow: hidden; line-height: 20px; background-color: #FFF; z-index: 10000;\">\n";
        retVal = retVal + "<div id=\"messageDialogTitle\" class=\"Caption\"></div>\n";
        retVal = retVal + "<div id=\"messageDialogBody\" class=\"dialog-content\"></div>\n";
        retVal = retVal + "<div id=\"singleButton\" style=\"margin-top: 30px;\">\n<button class=\"pentaho-button\" style=\"float: right;\" onclick=\"closeMessageDialog( true );\">\n<span>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Button.OK", (String[])new String[0]) + "</span>\n</button>\n</div>\n";
        retVal = retVal + "<div id=\"doubleButton\" style=\"margin-top: 30px;\">\n<button class=\"pentaho-button\" style=\"float: right; margin-left: 10px;\" onclick=\"closeMessageDialog( false );\">\n<span>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Button.No", (String[])new String[0]) + "</span>\n</button>\n<button class=\"pentaho-button\" style=\"float: right;\" onclick=\"closeMessageDialog( false ); removeSelection();\">\n<span>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Button.YesRemove", (String[])new String[0]) + "</span>\n</button>\n</div>\n";
        retVal = retVal + "</div>\n";
        return retVal;
    }

    private String setupAjaxCall(String uri, String title, String success, String failure) {
        String retVal = "";
        retVal = retVal + "var xhttp = new XMLHttpRequest();\n";
        retVal = retVal + "xhttp.onreadystatechange = function() {\n";
        retVal = retVal + " if ( this.readyState === 4 ) {\n";
        retVal = retVal + "   if ( this.status === 200 ) {\n";
        retVal = retVal + "     openMessageDialog( '" + title + "', " + success + ", true );\n";
        retVal = retVal + "   } else {\n";
        retVal = retVal + "     openMessageDialog( '" + BaseMessages.getString(PKG, (String)"GetStatusServlet.UnableTo.Label", (String[])new String[0]) + " " + title + "', " + failure + ", true );\n";
        retVal = retVal + "   }\n";
        retVal = retVal + " }\n";
        retVal = retVal + "};\n";
        retVal = retVal + "xhttp.open( \"GET\", " + uri + ", true );\n";
        retVal = retVal + "xhttp.send();\n";
        return retVal;
    }

    private String setupTransURI(String context) {
        return "'" + context + "' + '?name=' + encodeURIComponent(document.getElementById( 'cellTableFirstCell_' + selectedTransRowIndex ).innerText) + '&id=' + document.getElementById( 'cellTableCell_' + selectedTransRowIndex ).innerText";
    }

    private String setupJobURI(String context) {
        return "'" + context + "' + '?name=' + encodeURIComponent(document.getElementById( 'j-cellTableFirstCell_' + selectedJobRowIndex ).innerText) + '&id=' + document.getElementById( 'j-cellTableCell_' + selectedJobRowIndex ).innerText";
    }
}

