/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileoutput;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.file.BaseFileOutputMeta;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutput;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputData;
import org.pentaho.di.workarounds.ResolvableResource;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="TextFileOutput.Injection.", groups={"OUTPUT_FIELDS"})
public class TextFileOutputMeta
extends BaseFileOutputMeta
implements StepMetaInterface,
ResolvableResource {
    private static Class<?> PKG = TextFileOutputMeta.class;
    private static final String CONST_STRING_ADD_DATE = "add_date";
    private static final String CONST_STRING_ADD_TIME = "add_time";
    private static final String CONST_STRING_ADD_TO_RESULT_FILENAMES = "add_to_result_filenames";
    private static final String CONST_STRING_APPEND = "append";
    private static final String CONST_STRING_COMPRESSION = "compression";
    private static final String CONST_STRING_CREATE_PARENT_FOLDER = "create_parent_folder";
    private static final String CONST_STRING_CURRENCY = "currency";
    private static final String CONST_STRING_DATE_TIME_FORMAT = "date_time_format";
    private static final String CONST_STRING_DECIMAL = "decimal";
    private static final String CONST_STRING_DO_NOT_OPEN_NEW_FILE_INIT = "do_not_open_new_file_init";
    private static final String CONST_STRING_ENCLOSURE = "enclosure";
    private static final String CONST_STRING_ENCLOSURE_FIX_DISABLED = "enclosure_fix_disabled";
    private static final String CONST_STRING_ENCLOSURE_FORCED = "enclosure_forced";
    private static final String CONST_STRING_ENCODING = "encoding";
    private static final String CONST_STRING_ENDED_LINE = "endedLine";
    private static final String CONST_STRING_EXTENTION = "extention";
    private static final String CONST_STRING_FAST_DUMP = "fast_dump";
    private static final String CONST_STRING_FIELD = "field";
    private static final String CONST_STRING_FIELD_CURRENCY = "field_currency";
    private static final String CONST_STRING_FIELD_DECIMAL = "field_decimal";
    private static final String CONST_STRING_FIELD_FORMAT = "field_format";
    private static final String CONST_STRING_FIELD_GROUP = "field_group";
    private static final String CONST_STRING_FIELD_LENGTH = "field_length";
    private static final String CONST_STRING_FIELD_NAME = "field_name";
    private static final String CONST_STRING_FIELD_NULLIF = "field_nullif";
    private static final String CONST_STRING_FIELD_PRECISION = "field_precision";
    private static final String CONST_STRING_FIELD_TRIM_TYPE = "field_trim_type";
    private static final String CONST_STRING_FIELD_TYPE = "field_type";
    private static final String CONST_STRING_FIELDS = "fields";
    private static final String CONST_STRING_FILE = "file";
    private static final String CONST_STRING_FILE_ADD_DATE = "file_add_date";
    private static final String CONST_STRING_FILE_ADD_PARTNR = "file_add_partnr";
    private static final String CONST_STRING_FILE_ADD_STEPNR = "file_add_stepnr";
    private static final String CONST_STRING_FILE_ADD_TIME = "file_add_time";
    private static final String CONST_STRING_FILE_APPEND = "file_append";
    private static final String CONST_STRING_FILE_EXTENTION = "file_extention";
    private static final String CONST_STRING_FILE_FAST_DUMP = "file_fast_dump";
    private static final String CONST_STRING_FILE_NAME = "file_name";
    private static final String CONST_STRING_FILE_NAME_FIELD = "fileNameField";
    private static final String CONST_STRING_FILE_NAME_IN_FIELD = "fileNameInField";
    private static final String CONST_STRING_FILE_PAD = "file_pad";
    private static final String CONST_STRING_FILE_SERVLET_OUTPUT = "file_servlet_output";
    private static final String CONST_STRING_FILE_SPLIT_ROWS = "file_split_rows";
    private static final String CONST_STRING_FOOTER = "footer";
    private static final String CONST_STRING_FORMAT = "format";
    private static final String CONST_STRING_GROUP = "group";
    private static final String CONST_STRING_HASPARTNO = "haspartno";
    private static final String CONST_STRING_HEADER = "header";
    private static final String CONST_STRING_LENGTH = "length";
    private static final String CONST_STRING_NAME = "name";
    private static final String CONST_STRING_NULLIF = "nullif";
    private static final String CONST_STRING_PAD = "pad";
    private static final String CONST_STRING_PRECISION = "precision";
    private static final String CONST_STRING_SEPARATOR = "separator";
    private static final String CONST_STRING_SERVLET_OUTPUT = "servlet_output";
    private static final String CONST_STRING_SPECIFY_FORMAT = "SpecifyFormat";
    private static final String CONST_STRING_SPLIT = "split";
    private static final String CONST_STRING_SPLITEVERY = "splitevery";
    private static final String CONST_STRING_TRIM_TYPE = "trim_type";
    private static final String CONST_STRING_TYPE = "type";
    private static final String CONST_STRING_ZIPPED = "zipped";
    private static final String CONST_STRING_CR = "CR";
    private static final String CONST_STRING_DOS = "DOS";
    private static final String CONST_STRING_FILE_SPLIT = "file_split";
    private static final String CONST_STRING_NONE = "None";
    private static final String CONST_STRING_TXT = "txt";
    private static final String CONST_STRING_UNIX = "UNIX";
    private static final String CONST_STRING_ZIP = "Zip";
    private static final String NEW_LINE_CR_FORMAT = "\r";
    private static final String NEW_LINE_DOS_FORMAT = "\r\n";
    private static final String NEW_LINE_UNIX_FORMAT = "\n";
    protected static final int FILE_COMPRESSION_TYPE_NONE = 0;
    protected static final int FILE_COMPRESSION_TYPE_ZIP = 1;
    protected static final String[] fileCompressionTypeCodes = new String[]{"None", "Zip"};
    public static final String[] formatMapperLineTerminator = new String[]{"DOS", "UNIX", "CR", "None"};
    @Injection(name="PASS_TO_SERVLET")
    private boolean servletOutput;
    @Injection(name="CREATE_PARENT_FOLDER")
    private boolean createparentfolder = true;
    @Injection(name="SEPARATOR")
    private String separator;
    @Injection(name="ENCLOSURE")
    private String enclosure;
    @Injection(name="FORCE_ENCLOSURE")
    private boolean enclosureForced;
    @Injection(name="DISABLE_ENCLOSURE_FIX")
    private boolean disableEnclosureFix;
    @Injection(name="HEADER")
    private boolean headerEnabled;
    @Injection(name="FOOTER")
    private boolean footerEnabled;
    private String fileFormat;
    @Injection(name="SPLIT_EVERY")
    private String splitEveryRows;
    @Injection(name="APPEND")
    private boolean fileAppended;
    @Injection(name="RIGHT_PAD_FIELDS")
    private boolean padded;
    @Injection(name="FAST_DATA_DUMP")
    private boolean fastDump;
    @InjectionDeep
    private TextFileField[] outputFields;
    @Injection(name="ENCODING")
    private String encoding;
    @Injection(name="ADD_ENDING_LINE")
    private String endedLine;
    @Injection(name="FILENAME_IN_FIELD")
    private boolean fileNameInField;
    @Injection(name="FILENAME_FIELD")
    private String fileNameField;
    @Injection(name="NEW_LINE")
    private String newline;
    @Injection(name="ADD_TO_RESULT")
    private boolean addToResultFilenames;
    @Injection(name="DO_NOT_CREATE_FILE_AT_STARTUP")
    private boolean doNotOpenNewFileInit;
    protected ValueMetaInterface[] metaWithFieldOptions = null;

    public boolean isServletOutput() {
        return this.servletOutput;
    }

    public void setServletOutput(boolean servletOutput) {
        this.servletOutput = servletOutput;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public boolean isEnclosureForced() {
        return this.enclosureForced;
    }

    public void setEnclosureForced(boolean enclosureForced) {
        this.enclosureForced = enclosureForced;
    }

    public boolean isEnclosureFixDisabled() {
        return this.disableEnclosureFix;
    }

    public void setEnclosureFixDisabled(boolean disableEnclosureFix) {
        this.disableEnclosureFix = disableEnclosureFix;
    }

    public boolean isAddToResultFiles() {
        return this.addToResultFilenames;
    }

    public void setAddToResultFiles(boolean addtoresultfilenamesin) {
        this.addToResultFilenames = addtoresultfilenamesin;
    }

    public boolean isFileAppended() {
        return this.fileAppended;
    }

    public void setFileAppended(boolean fileAppended) {
        this.fileAppended = fileAppended;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    @Injection(name="FORMAT")
    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
        this.newline = this.getNewLine(fileFormat);
    }

    public boolean isFooterEnabled() {
        return this.footerEnabled;
    }

    public void setFooterEnabled(boolean footer) {
        this.footerEnabled = footer;
    }

    public boolean isHeaderEnabled() {
        return this.headerEnabled;
    }

    public void setHeaderEnabled(boolean header) {
        this.headerEnabled = header;
    }

    public String getNewline() {
        return this.newline;
    }

    public void setNewline(String newline) {
        this.newline = newline;
    }

    public boolean isPadded() {
        return this.padded;
    }

    public void setPadded(boolean padded) {
        this.padded = padded;
    }

    public boolean isFastDump() {
        return this.fastDump;
    }

    public void setFastDump(boolean fastDump) {
        this.fastDump = fastDump;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean isDoNotOpenNewFileInit() {
        return this.doNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
        this.doNotOpenNewFileInit = doNotOpenNewFileInit;
    }

    @Override
    public int getSplitEvery() {
        return Const.toInt((String)this.splitEveryRows, (int)0);
    }

    @Override
    public int getSplitEvery(VariableSpace varSpace) {
        return Const.toInt((String)(varSpace == null ? this.splitEveryRows : varSpace.environmentSubstitute(this.splitEveryRows)), (int)0);
    }

    public String getSplitEveryRows() {
        return this.splitEveryRows;
    }

    public void setSplitEveryRows(String value) {
        this.splitEveryRows = value;
    }

    public int getFooterShift() {
        return this.isFooterEnabled() ? 1 : 0;
    }

    @Override
    public void setSplitEvery(int splitEvery) {
        this.splitEveryRows = Integer.toString(splitEvery);
    }

    public void setStepNrInFilename(boolean stepNrInFilename) {
        this.stepNrInFilename = stepNrInFilename;
    }

    public void setPartNrInFilename(boolean partNrInFilename) {
        this.partNrInFilename = partNrInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public TextFileField[] getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(TextFileField[] outputFields) {
        this.outputFields = outputFields;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEndedLine() {
        return this.endedLine;
    }

    public void setEndedLine(String endedLine) {
        this.endedLine = endedLine;
    }

    public boolean isFileNameInField() {
        return this.fileNameInField;
    }

    public void setFileNameInField(boolean fileNameInField) {
        this.fileNameInField = fileNameInField;
    }

    public String getFileNameField() {
        return this.fileNameField;
    }

    public void setFileNameField(String fileNameField) {
        this.fileNameField = fileNameField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, metaStore);
    }

    public void allocate(int nrfields) {
        this.outputFields = new TextFileField[nrfields];
    }

    @Override
    public Object clone() {
        TextFileOutputMeta retval = (TextFileOutputMeta)super.clone();
        int nrFields = this.outputFields.length;
        retval.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            retval.outputFields[i] = (TextFileField)this.outputFields[i].clone();
        }
        if (null != this.metaWithFieldOptions) {
            int nrMetas = this.metaWithFieldOptions.length;
            retval.metaWithFieldOptions = new ValueMetaInterface[nrMetas];
            for (int i = 0; i < nrMetas; ++i) {
                retval.metaWithFieldOptions[i] = this.metaWithFieldOptions[i].clone();
            }
        } else {
            retval.metaWithFieldOptions = null;
        }
        return retval;
    }

    protected void readData(Node stepnode, IMetaStore metastore) throws KettleXMLException {
        try {
            this.separator = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_SEPARATOR), (String)"");
            this.enclosure = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_ENCLOSURE), (String)"");
            this.enclosureForced = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_ENCLOSURE_FORCED));
            String sDisableEnclosureFix = XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_ENCLOSURE_FIX_DISABLED);
            this.disableEnclosureFix = sDisableEnclosureFix == null || "Y".equalsIgnoreCase(sDisableEnclosureFix);
            String createParentFolderTagValue = XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_CREATE_PARENT_FOLDER);
            this.createparentfolder = createParentFolderTagValue == null || "Y".equalsIgnoreCase(createParentFolderTagValue);
            this.headerEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_HEADER));
            this.footerEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FOOTER));
            this.fileFormat = XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FORMAT);
            this.setFileCompression(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_COMPRESSION));
            if (this.getFileCompression() == null) {
                if ("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_ZIPPED))) {
                    this.setFileCompression(fileCompressionTypeCodes[1]);
                } else {
                    this.setFileCompression(fileCompressionTypeCodes[0]);
                }
            }
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_ENCODING);
            this.endedLine = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_ENDED_LINE), (String)"");
            this.fileName = this.loadSource(stepnode, metastore);
            this.servletOutput = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_SERVLET_OUTPUT));
            this.doNotOpenNewFileInit = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_DO_NOT_OPEN_NEW_FILE_INIT));
            this.extension = XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_EXTENTION);
            this.fileAppended = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_APPEND));
            this.stepNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_SPLIT));
            this.partNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_HASPARTNO));
            this.dateInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_ADD_DATE));
            this.timeInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_ADD_TIME));
            this.setSpecifyingFormat("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_SPECIFY_FORMAT)));
            this.setDateTimeFormat(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_DATE_TIME_FORMAT));
            String addToResultFiles = XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_ADD_TO_RESULT_FILENAMES);
            this.addToResultFilenames = Utils.isEmpty((CharSequence)addToResultFiles) || "Y".equalsIgnoreCase(addToResultFiles);
            this.padded = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_PAD));
            this.fastDump = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_FAST_DUMP));
            this.splitEveryRows = XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_SPLITEVERY);
            this.newline = this.getNewLine(this.fileFormat);
            this.fileNameInField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE_NAME_IN_FIELD));
            this.fileNameField = XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE_NAME_FIELD);
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)CONST_STRING_FIELDS);
            int nrfields = XMLHandler.countNodes((Node)fields, (String)CONST_STRING_FIELD);
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)CONST_STRING_FIELD, (int)i);
                this.outputFields[i] = new TextFileField();
                this.outputFields[i].setName(XMLHandler.getTagValue((Node)fnode, (String)CONST_STRING_NAME));
                this.outputFields[i].setType(XMLHandler.getTagValue((Node)fnode, (String)CONST_STRING_TYPE));
                this.outputFields[i].setFormat(XMLHandler.getTagValue((Node)fnode, (String)CONST_STRING_FORMAT));
                this.outputFields[i].setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)CONST_STRING_CURRENCY));
                this.outputFields[i].setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)CONST_STRING_DECIMAL));
                this.outputFields[i].setGroupingSymbol(XMLHandler.getTagValue((Node)fnode, (String)CONST_STRING_GROUP));
                this.outputFields[i].setTrimType(ValueMetaString.getTrimTypeByCode((String)XMLHandler.getTagValue((Node)fnode, (String)CONST_STRING_TRIM_TYPE)));
                this.outputFields[i].setNullString(XMLHandler.getTagValue((Node)fnode, (String)CONST_STRING_NULLIF));
                this.outputFields[i].setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)CONST_STRING_LENGTH), (int)-1));
                this.outputFields[i].setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)CONST_STRING_PRECISION), (int)-1));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void readData(Node stepnode) throws KettleXMLException {
        this.readData(stepnode, null);
    }

    public String getNewLine(String fformat) {
        String nl = Const.CR;
        if (fformat != null) {
            if (fformat.equalsIgnoreCase(CONST_STRING_DOS)) {
                nl = NEW_LINE_DOS_FORMAT;
            } else if (fformat.equalsIgnoreCase(CONST_STRING_UNIX)) {
                nl = NEW_LINE_UNIX_FORMAT;
            } else if (fformat.equalsIgnoreCase(CONST_STRING_CR)) {
                nl = NEW_LINE_CR_FORMAT;
            } else if (fformat.equalsIgnoreCase(CONST_STRING_NONE)) {
                nl = "";
            }
        }
        return nl;
    }

    @Override
    public void setDefault() {
        this.createparentfolder = true;
        this.separator = ";";
        this.enclosure = "\"";
        this.setSpecifyingFormat(false);
        this.setDateTimeFormat(null);
        this.enclosureForced = false;
        this.disableEnclosureFix = false;
        this.headerEnabled = true;
        this.footerEnabled = false;
        this.fileFormat = CONST_STRING_DOS;
        this.setFileCompression(fileCompressionTypeCodes[0]);
        this.fileName = CONST_STRING_FILE;
        this.servletOutput = false;
        this.doNotOpenNewFileInit = false;
        this.extension = CONST_STRING_TXT;
        this.stepNrInFilename = false;
        this.partNrInFilename = false;
        this.dateInFilename = false;
        this.timeInFilename = false;
        this.padded = false;
        this.fastDump = false;
        this.addToResultFilenames = true;
        this.fileAppended = false;
        this.newline = this.getNewLine(this.fileFormat);
        this.allocate(0);
        this.metaWithFieldOptions = null;
    }

    public String buildFilename(VariableSpace space, int stepnr, String partnr, int splitnr, boolean ziparchive) {
        return super.buildFilename(space, Integer.toString(stepnr), partnr, Integer.toString(splitnr), ziparchive);
    }

    public String buildFilename(String filename, String extension, VariableSpace space, int stepnr, String partnr, int splitnr, boolean ziparchive, TextFileOutputMeta meta) {
        String realFileName = space.environmentSubstitute(filename);
        String realExtension = space.environmentSubstitute(extension);
        return super.buildFilename(space, realFileName, realExtension, Integer.toString(stepnr), partnr, Integer.toString(splitnr), new Date(), ziparchive, true, meta);
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(800);
        retval.append("    ").append(XMLHandler.addTagValue((String)CONST_STRING_SEPARATOR, (String)this.separator));
        retval.append("    ").append(XMLHandler.addTagValue((String)CONST_STRING_ENCLOSURE, (String)this.enclosure));
        retval.append("    ").append(XMLHandler.addTagValue((String)CONST_STRING_ENCLOSURE_FORCED, (boolean)this.enclosureForced));
        retval.append("    ").append(XMLHandler.addTagValue((String)CONST_STRING_ENCLOSURE_FIX_DISABLED, (boolean)this.disableEnclosureFix));
        retval.append("    ").append(XMLHandler.addTagValue((String)CONST_STRING_HEADER, (boolean)this.headerEnabled));
        retval.append("    ").append(XMLHandler.addTagValue((String)CONST_STRING_FOOTER, (boolean)this.footerEnabled));
        retval.append("    ").append(XMLHandler.addTagValue((String)CONST_STRING_FORMAT, (String)this.fileFormat));
        retval.append("    ").append(XMLHandler.addTagValue((String)CONST_STRING_COMPRESSION, (String)this.getFileCompression()));
        retval.append("    ").append(XMLHandler.addTagValue((String)CONST_STRING_ENCODING, (String)this.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)CONST_STRING_ENDED_LINE, (String)this.endedLine));
        retval.append("    ").append(XMLHandler.addTagValue((String)CONST_STRING_FILE_NAME_IN_FIELD, (boolean)this.fileNameInField));
        retval.append("    ").append(XMLHandler.addTagValue((String)CONST_STRING_FILE_NAME_FIELD, (String)this.fileNameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)CONST_STRING_CREATE_PARENT_FOLDER, (boolean)this.createparentfolder));
        retval.append("    <file>").append(Const.CR);
        this.saveFileOptions(retval);
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (TextFileField field : this.outputFields) {
            if (Utils.isEmpty((CharSequence)field.getName())) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)CONST_STRING_NAME, (String)field.getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)CONST_STRING_TYPE, (String)field.getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)CONST_STRING_FORMAT, (String)field.getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)CONST_STRING_CURRENCY, (String)field.getCurrencySymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)CONST_STRING_DECIMAL, (String)field.getDecimalSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)CONST_STRING_GROUP, (String)field.getGroupingSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)CONST_STRING_NULLIF, (String)field.getNullString()));
            retval.append("        ").append(XMLHandler.addTagValue((String)CONST_STRING_TRIM_TYPE, (String)field.getTrimTypeCode()));
            retval.append("        ").append(XMLHandler.addTagValue((String)CONST_STRING_LENGTH, (int)field.getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)CONST_STRING_PRECISION, (int)field.getPrecision()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    protected void saveFileOptions(StringBuilder retval) {
        if (this.parentStepMeta != null && this.parentStepMeta.getParentTransMeta() != null) {
            this.parentStepMeta.getParentTransMeta().getNamedClusterEmbedManager().registerUrl(this.fileName);
        }
        this.saveSource(retval, this.fileName);
        retval.append("      ").append(XMLHandler.addTagValue((String)CONST_STRING_SERVLET_OUTPUT, (boolean)this.servletOutput));
        retval.append("      ").append(XMLHandler.addTagValue((String)CONST_STRING_DO_NOT_OPEN_NEW_FILE_INIT, (boolean)this.doNotOpenNewFileInit));
        retval.append("      ").append(XMLHandler.addTagValue((String)CONST_STRING_EXTENTION, (String)this.extension));
        retval.append("      ").append(XMLHandler.addTagValue((String)CONST_STRING_APPEND, (boolean)this.fileAppended));
        retval.append("      ").append(XMLHandler.addTagValue((String)CONST_STRING_SPLIT, (boolean)this.stepNrInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)CONST_STRING_HASPARTNO, (boolean)this.partNrInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)CONST_STRING_ADD_DATE, (boolean)this.dateInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)CONST_STRING_ADD_TIME, (boolean)this.timeInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)CONST_STRING_SPECIFY_FORMAT, (boolean)this.isSpecifyingFormat()));
        retval.append("      ").append(XMLHandler.addTagValue((String)CONST_STRING_DATE_TIME_FORMAT, (String)this.getDateTimeFormat()));
        retval.append("      ").append(XMLHandler.addTagValue((String)CONST_STRING_ADD_TO_RESULT_FILENAMES, (boolean)this.addToResultFilenames));
        retval.append("      ").append(XMLHandler.addTagValue((String)CONST_STRING_PAD, (boolean)this.padded));
        retval.append("      ").append(XMLHandler.addTagValue((String)CONST_STRING_FAST_DUMP, (boolean)this.fastDump));
        retval.append("      ").append(XMLHandler.addTagValue((String)CONST_STRING_SPLITEVERY, (String)this.splitEveryRows));
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            long splitEvery;
            this.separator = rep.getStepAttributeString(id_step, CONST_STRING_SEPARATOR);
            this.enclosure = rep.getStepAttributeString(id_step, CONST_STRING_ENCLOSURE);
            this.enclosureForced = rep.getStepAttributeBoolean(id_step, CONST_STRING_ENCLOSURE_FORCED);
            this.disableEnclosureFix = rep.getStepAttributeBoolean(id_step, 0, CONST_STRING_ENCLOSURE_FIX_DISABLED, true);
            this.createparentfolder = rep.getStepAttributeBoolean(id_step, CONST_STRING_CREATE_PARENT_FOLDER);
            this.headerEnabled = rep.getStepAttributeBoolean(id_step, CONST_STRING_HEADER);
            this.footerEnabled = rep.getStepAttributeBoolean(id_step, CONST_STRING_FOOTER);
            this.fileFormat = rep.getStepAttributeString(id_step, CONST_STRING_FORMAT);
            this.setFileCompression(rep.getStepAttributeString(id_step, CONST_STRING_COMPRESSION));
            this.fileNameInField = rep.getStepAttributeBoolean(id_step, CONST_STRING_FILE_NAME_IN_FIELD);
            this.fileNameField = rep.getStepAttributeString(id_step, CONST_STRING_FILE_NAME_FIELD);
            if (this.getFileCompression() == null) {
                if (rep.getStepAttributeBoolean(id_step, CONST_STRING_ZIPPED)) {
                    this.setFileCompression(fileCompressionTypeCodes[1]);
                } else {
                    this.setFileCompression(fileCompressionTypeCodes[0]);
                }
            }
            this.encoding = rep.getStepAttributeString(id_step, CONST_STRING_ENCODING);
            this.fileName = this.loadSourceRep(rep, id_step, metaStore);
            this.servletOutput = rep.getStepAttributeBoolean(id_step, CONST_STRING_FILE_SERVLET_OUTPUT);
            this.doNotOpenNewFileInit = rep.getStepAttributeBoolean(id_step, CONST_STRING_DO_NOT_OPEN_NEW_FILE_INIT);
            this.extension = rep.getStepAttributeString(id_step, CONST_STRING_FILE_EXTENTION);
            this.fileAppended = rep.getStepAttributeBoolean(id_step, CONST_STRING_FILE_APPEND);
            this.splitEveryRows = rep.getStepAttributeString(id_step, CONST_STRING_FILE_SPLIT_ROWS);
            if (Utils.isEmpty((CharSequence)this.splitEveryRows) && (splitEvery = rep.getStepAttributeInteger(id_step, CONST_STRING_FILE_SPLIT)) > 0L) {
                this.splitEveryRows = Long.toString(splitEvery);
            }
            this.stepNrInFilename = rep.getStepAttributeBoolean(id_step, CONST_STRING_FILE_ADD_STEPNR);
            this.partNrInFilename = rep.getStepAttributeBoolean(id_step, CONST_STRING_FILE_ADD_PARTNR);
            this.dateInFilename = rep.getStepAttributeBoolean(id_step, CONST_STRING_FILE_ADD_DATE);
            this.timeInFilename = rep.getStepAttributeBoolean(id_step, CONST_STRING_FILE_ADD_TIME);
            this.setSpecifyingFormat(rep.getStepAttributeBoolean(id_step, CONST_STRING_SPECIFY_FORMAT));
            this.setDateTimeFormat(rep.getStepAttributeString(id_step, CONST_STRING_DATE_TIME_FORMAT));
            String addToResultFiles = rep.getStepAttributeString(id_step, CONST_STRING_ADD_TO_RESULT_FILENAMES);
            this.addToResultFilenames = Utils.isEmpty((CharSequence)addToResultFiles) || rep.getStepAttributeBoolean(id_step, CONST_STRING_ADD_TO_RESULT_FILENAMES);
            this.padded = rep.getStepAttributeBoolean(id_step, CONST_STRING_FILE_PAD);
            this.fastDump = rep.getStepAttributeBoolean(id_step, CONST_STRING_FILE_FAST_DUMP);
            this.newline = this.getNewLine(this.fileFormat);
            int nrfields = rep.countNrStepAttributes(id_step, CONST_STRING_FIELD_NAME);
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.outputFields[i] = new TextFileField();
                this.outputFields[i].setName(rep.getStepAttributeString(id_step, i, CONST_STRING_FIELD_NAME));
                this.outputFields[i].setType(rep.getStepAttributeString(id_step, i, CONST_STRING_FIELD_TYPE));
                this.outputFields[i].setFormat(rep.getStepAttributeString(id_step, i, CONST_STRING_FIELD_FORMAT));
                this.outputFields[i].setCurrencySymbol(rep.getStepAttributeString(id_step, i, CONST_STRING_FIELD_CURRENCY));
                this.outputFields[i].setDecimalSymbol(rep.getStepAttributeString(id_step, i, CONST_STRING_FIELD_DECIMAL));
                this.outputFields[i].setGroupingSymbol(rep.getStepAttributeString(id_step, i, CONST_STRING_FIELD_GROUP));
                this.outputFields[i].setTrimType(ValueMetaString.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, CONST_STRING_FIELD_TRIM_TYPE)));
                this.outputFields[i].setNullString(rep.getStepAttributeString(id_step, i, CONST_STRING_FIELD_NULLIF));
                this.outputFields[i].setLength((int)rep.getStepAttributeInteger(id_step, i, CONST_STRING_FIELD_LENGTH));
                this.outputFields[i].setPrecision((int)rep.getStepAttributeInteger(id_step, i, CONST_STRING_FIELD_PRECISION));
            }
            this.endedLine = rep.getStepAttributeString(id_step, CONST_STRING_ENDED_LINE);
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_SEPARATOR, this.separator);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_ENCLOSURE, this.enclosure);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_ENCLOSURE_FORCED, this.enclosureForced);
            rep.saveStepAttribute(id_transformation, id_step, 0, CONST_STRING_ENCLOSURE_FIX_DISABLED, this.disableEnclosureFix);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_HEADER, this.headerEnabled);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_FOOTER, this.footerEnabled);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_FORMAT, this.fileFormat);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_COMPRESSION, this.getFileCompression());
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_ENCODING, this.encoding);
            this.saveSourceRep(rep, id_transformation, id_step, this.fileName);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_FILE_SERVLET_OUTPUT, this.servletOutput);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_DO_NOT_OPEN_NEW_FILE_INIT, this.doNotOpenNewFileInit);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_FILE_EXTENTION, this.extension);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_FILE_APPEND, this.fileAppended);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_FILE_SPLIT_ROWS, this.splitEveryRows);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_FILE_ADD_STEPNR, this.stepNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_FILE_ADD_PARTNR, this.partNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_FILE_ADD_DATE, this.dateInFilename);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_DATE_TIME_FORMAT, this.getDateTimeFormat());
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_CREATE_PARENT_FOLDER, this.createparentfolder);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_SPECIFY_FORMAT, this.isSpecifyingFormat());
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_ADD_TO_RESULT_FILENAMES, this.addToResultFilenames);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_FILE_ADD_TIME, this.timeInFilename);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_FILE_PAD, this.padded);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_FILE_FAST_DUMP, this.fastDump);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_FILE_NAME_IN_FIELD, this.fileNameInField);
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_FILE_NAME_FIELD, this.fileNameField);
            for (int i = 0; i < this.outputFields.length; ++i) {
                TextFileField field = this.outputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, CONST_STRING_FIELD_NAME, field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, CONST_STRING_FIELD_TYPE, field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, CONST_STRING_FIELD_FORMAT, field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, CONST_STRING_FIELD_CURRENCY, field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, CONST_STRING_FIELD_DECIMAL, field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, CONST_STRING_FIELD_GROUP, field.getGroupingSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, CONST_STRING_FIELD_TRIM_TYPE, field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, CONST_STRING_FIELD_NULLIF, field.getNullString());
                rep.saveStepAttribute(id_transformation, id_step, i, CONST_STRING_FIELD_LENGTH, field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, CONST_STRING_FIELD_PRECISION, field.getPrecision());
            }
            rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_ENDED_LINE, this.endedLine);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            StringBuilder missingFields = new StringBuilder();
            boolean errorFound = false;
            for (TextFileField outputField : this.outputFields) {
                int idx = prev.indexOfValue(outputField.getName());
                if (idx >= 0) continue;
                missingFields.append("\t\t").append(outputField.getName()).append(Const.CR);
                errorFound = true;
            }
            if (errorFound) {
                String errorMessage = BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.FieldsNotFound", (Object[])new Object[]{missingFields});
                cr = new CheckResult(4, errorMessage, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new TextFileOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new TextFileOutputData();
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            if (!this.fileNameInField && !Utils.isEmpty((CharSequence)this.fileName)) {
                FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName), (VariableSpace)space);
                this.fileName = resourceNamingInterface.nameResource(fileObject, space, true);
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void setFilename(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return this.getStepMetaInjectionInterface().extractStepMetadataEntries();
    }

    protected String loadSource(Node stepnode, IMetaStore metastore) {
        return XMLHandler.getTagValue((Node)stepnode, (String)CONST_STRING_FILE, (String)CONST_STRING_NAME);
    }

    protected void saveSource(StringBuilder retVal, String value) {
        retVal.append("      ").append(XMLHandler.addTagValue((String)CONST_STRING_NAME, (String)this.fileName));
    }

    protected String loadSourceRep(Repository rep, ObjectId id_step, IMetaStore metaStore) throws KettleException {
        return rep.getStepAttributeString(id_step, CONST_STRING_FILE_NAME);
    }

    protected void saveSourceRep(Repository rep, ObjectId id_transformation, ObjectId id_step, String value) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, CONST_STRING_FILE_NAME, this.fileName);
    }

    @Override
    public boolean passDataToServletOutput() {
        return this.servletOutput;
    }

    @Override
    public void resolve() {
        if (this.fileName != null && !this.fileName.isEmpty()) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.fileName));
                if (AliasedFileObject.isAliasedFile((FileObject)fileObject)) {
                    this.fileName = ((AliasedFileObject)fileObject).getAELSafeURIString();
                }
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected synchronized void calcMetaWithFieldOptions(TextFileOutputData data) {
        if (null == this.metaWithFieldOptions) {
            if (!Utils.isEmpty((Object[])this.getOutputFields())) {
                this.metaWithFieldOptions = new ValueMetaInterface[this.getOutputFields().length];
                for (int i = 0; i < this.getOutputFields().length; ++i) {
                    ValueMetaInterface v = data.outputRowMeta.getValueMeta(data.fieldnrs[i]);
                    if (v == null) continue;
                    this.metaWithFieldOptions[i] = v.clone();
                    TextFileField field = this.getOutputFields()[i];
                    this.metaWithFieldOptions[i].setLength(field.getLength());
                    this.metaWithFieldOptions[i].setPrecision(field.getPrecision());
                    if (!Utils.isEmpty((CharSequence)field.getFormat())) {
                        this.metaWithFieldOptions[i].setConversionMask(field.getFormat());
                    }
                    this.metaWithFieldOptions[i].setDecimalSymbol(field.getDecimalSymbol());
                    this.metaWithFieldOptions[i].setGroupingSymbol(field.getGroupingSymbol());
                    this.metaWithFieldOptions[i].setCurrencySymbol(field.getCurrencySymbol());
                    this.metaWithFieldOptions[i].setTrimType(field.getTrimType());
                    if (!Utils.isEmpty((CharSequence)this.getEncoding())) {
                        this.metaWithFieldOptions[i].setStringEncoding(this.getEncoding());
                    }
                    this.metaWithFieldOptions[i].setOutputPaddingEnabled(true);
                }
            } else {
                this.metaWithFieldOptions = null;
            }
        }
    }

    protected synchronized ValueMetaInterface[] getMetaWithFieldOptions() {
        if (null == this.metaWithFieldOptions) {
            this.metaWithFieldOptions = new ValueMetaInterface[0];
        }
        return this.metaWithFieldOptions;
    }
}

