/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableoutput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepInjectionUtil;
import org.pentaho.di.trans.step.StepMetaInjectionEntryInterface;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;

@Deprecated
public class TableOutputMetaInjection
implements StepMetaInjectionInterface {
    private TableOutputMeta meta;

    public TableOutputMetaInjection(TableOutputMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        Entry[] fieldsEntries;
        Entry[] topEntries;
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        for (Entry topEntry : topEntries = new Entry[]{Entry.TARGET_SCHEMA, Entry.TARGET_TABLE, Entry.COMMIT_SIZE, Entry.TRUNCATE_TABLE, Entry.SPECIFY_DATABASE_FIELDS, Entry.IGNORE_INSERT_ERRORS, Entry.USE_BATCH_UPDATE, Entry.PARTITION_OVER_TABLES, Entry.PARTITIONING_FIELD, Entry.PARTITION_DATA_PER, Entry.TABLE_NAME_DEFINED_IN_FIELD, Entry.TABLE_NAME_FIELD, Entry.STORE_TABLE_NAME, Entry.RETURN_AUTO_GENERATED_KEY, Entry.AUTO_GENERATED_KEY_FIELD}) {
            all.add(new StepInjectionMetaEntry(topEntry.name(), topEntry.getValueType(), topEntry.getDescription()));
        }
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry(Entry.DATABASE_FIELDS.name(), 0, Entry.DATABASE_FIELDS.description);
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry(Entry.DATABASE_FIELD.name(), 0, Entry.DATABASE_FIELD.description);
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : fieldsEntries = new Entry[]{Entry.DATABASE_FIELDNAME, Entry.STREAM_FIELDNAME}) {
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<String> databaseFields = new ArrayList<String>();
        ArrayList<String> streamFields = new ArrayList<String>();
        block22: for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            String lookValue = (String)lookFields.getValue();
            switch (fieldsEntry) {
                case DATABASE_FIELDS: {
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        Entry fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry != Entry.DATABASE_FIELD) continue;
                        String databaseFieldname = null;
                        String streamFieldname = null;
                        List<StepInjectionMetaEntry> entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            Entry metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            String value = (String)entry.getValue();
                            switch (metaEntry) {
                                case DATABASE_FIELDNAME: {
                                    databaseFieldname = value;
                                    break;
                                }
                                case STREAM_FIELDNAME: {
                                    streamFieldname = value;
                                    break;
                                }
                            }
                        }
                        databaseFields.add(databaseFieldname);
                        streamFields.add(streamFieldname);
                    }
                    continue block22;
                }
                case TARGET_SCHEMA: {
                    this.meta.setSchemaName(lookValue);
                    break;
                }
                case TARGET_TABLE: {
                    this.meta.setTableName(lookValue);
                    break;
                }
                case COMMIT_SIZE: {
                    this.meta.setCommitSize(lookValue);
                    break;
                }
                case TRUNCATE_TABLE: {
                    this.meta.setTruncateTable("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case SPECIFY_DATABASE_FIELDS: {
                    this.meta.setSpecifyFields("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case IGNORE_INSERT_ERRORS: {
                    this.meta.setIgnoreErrors("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case USE_BATCH_UPDATE: {
                    this.meta.setUseBatchUpdate("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case PARTITION_OVER_TABLES: {
                    this.meta.setPartitioningEnabled("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case PARTITIONING_FIELD: {
                    this.meta.setPartitioningField(lookValue);
                    break;
                }
                case PARTITION_DATA_PER: {
                    this.meta.setPartitioningDaily("DAY".equalsIgnoreCase(lookValue));
                    this.meta.setPartitioningMonthly("MONTH".equalsIgnoreCase(lookValue));
                    break;
                }
                case TABLE_NAME_DEFINED_IN_FIELD: {
                    this.meta.setTableNameInField("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case TABLE_NAME_FIELD: {
                    this.meta.setTableNameField(lookValue);
                    break;
                }
                case STORE_TABLE_NAME: {
                    this.meta.setTableNameInTable("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case RETURN_AUTO_GENERATED_KEY: {
                    this.meta.setReturningGeneratedKeys("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case AUTO_GENERATED_KEY_FIELD: {
                    this.meta.setGeneratedKeyField(lookValue);
                    break;
                }
            }
        }
        if (databaseFields.size() > 0) {
            this.meta.setFieldDatabase(databaseFields.toArray(new String[databaseFields.size()]));
            this.meta.setFieldStream(streamFields.toArray(new String[streamFields.size()]));
        }
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        ArrayList<StepInjectionMetaEntry> list = new ArrayList<StepInjectionMetaEntry>();
        list.add(StepInjectionUtil.getEntry(Entry.TARGET_SCHEMA, this.meta.getSchemaName()));
        list.add(StepInjectionUtil.getEntry(Entry.TARGET_TABLE, this.meta.getTableName()));
        list.add(StepInjectionUtil.getEntry(Entry.COMMIT_SIZE, this.meta.getCommitSize()));
        list.add(StepInjectionUtil.getEntry(Entry.TRUNCATE_TABLE, this.meta.truncateTable()));
        list.add(StepInjectionUtil.getEntry(Entry.SPECIFY_DATABASE_FIELDS, this.meta.specifyFields()));
        list.add(StepInjectionUtil.getEntry(Entry.IGNORE_INSERT_ERRORS, this.meta.ignoreErrors()));
        list.add(StepInjectionUtil.getEntry(Entry.USE_BATCH_UPDATE, this.meta.useBatchUpdate()));
        list.add(StepInjectionUtil.getEntry(Entry.PARTITION_OVER_TABLES, this.meta.isPartitioningEnabled()));
        list.add(StepInjectionUtil.getEntry(Entry.PARTITIONING_FIELD, this.meta.getPartitioningField()));
        list.add(StepInjectionUtil.getEntry(Entry.PARTITION_DATA_PER, this.meta.isPartitioningDaily() ? "DAY" : (this.meta.isPartitioningMonthly() ? "MONTH" : "")));
        list.add(StepInjectionUtil.getEntry(Entry.TABLE_NAME_DEFINED_IN_FIELD, this.meta.isTableNameInField()));
        list.add(StepInjectionUtil.getEntry(Entry.TABLE_NAME_FIELD, this.meta.getTableNameField()));
        list.add(StepInjectionUtil.getEntry(Entry.STORE_TABLE_NAME, this.meta.isTableNameInTable()));
        list.add(StepInjectionUtil.getEntry(Entry.RETURN_AUTO_GENERATED_KEY, this.meta.isReturningGeneratedKeys()));
        list.add(StepInjectionUtil.getEntry(Entry.AUTO_GENERATED_KEY_FIELD, this.meta.getGeneratedKeyField()));
        StepInjectionMetaEntry fieldsEntry = StepInjectionUtil.getEntry(Entry.DATABASE_FIELDS);
        list.add(fieldsEntry);
        for (int i = 0; i < this.meta.getFieldDatabase().length; ++i) {
            StepInjectionMetaEntry fieldEntry = StepInjectionUtil.getEntry(Entry.DATABASE_FIELD);
            List<StepInjectionMetaEntry> details = fieldEntry.getDetails();
            details.add(StepInjectionUtil.getEntry(Entry.DATABASE_FIELDNAME, this.meta.getFieldDatabase()[i]));
            details.add(StepInjectionUtil.getEntry(Entry.STREAM_FIELDNAME, this.meta.getFieldStream()[i]));
            fieldsEntry.getDetails().add(fieldEntry);
        }
        return list;
    }

    public TableOutputMeta getMeta() {
        return this.meta;
    }

    public static enum Entry implements StepMetaInjectionEntryInterface
    {
        TARGET_SCHEMA(2, "The target schema"),
        TARGET_TABLE(2, "The target table"),
        COMMIT_SIZE(2, "The commit size"),
        TRUNCATE_TABLE(2, "Truncate table? (Y/N)"),
        SPECIFY_DATABASE_FIELDS(2, "Specify database fields? (Y/N)"),
        IGNORE_INSERT_ERRORS(2, "Ignore insert errors? (Y/N)"),
        USE_BATCH_UPDATE(2, "Use batch update for inserts? (Y/N)"),
        PARTITION_OVER_TABLES(2, "Partition data over tables? (Y/N)"),
        PARTITIONING_FIELD(2, "Partitioning field"),
        PARTITION_DATA_PER(2, "Partition data per (month/day)"),
        TABLE_NAME_DEFINED_IN_FIELD(2, "Is the name of the table defined in a field? (Y/N)"),
        TABLE_NAME_FIELD(2, "Field that contains the name of table"),
        STORE_TABLE_NAME(2, "Store the tablename field? (Y/N)"),
        RETURN_AUTO_GENERATED_KEY(2, "Return auto-generated key? (Y/N)"),
        AUTO_GENERATED_KEY_FIELD(2, "Name of auto-generated key field"),
        DATABASE_FIELDS(0, "The database fields"),
        DATABASE_FIELD(0, "One database field"),
        DATABASE_FIELDNAME(2, "Table field"),
        STREAM_FIELDNAME(2, "Stream field");

        private int valueType;
        private String description;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        @Override
        public int getValueType() {
            return this.valueType;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }
    }
}

