/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tablecompare;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tablecompare.TableCompare;
import org.pentaho.di.trans.steps.tablecompare.TableCompareData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class TableCompareMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = TableCompare.class;
    private DatabaseMeta referenceConnection;
    private String referenceSchemaField;
    private String referenceTableField;
    private DatabaseMeta compareConnection;
    private String compareSchemaField;
    private String compareTableField;
    private String keyFieldsField;
    private String excludeFieldsField;
    private String nrErrorsField;
    private String nrRecordsReferenceField;
    private String nrRecordsCompareField;
    private String nrErrorsLeftJoinField;
    private String nrErrorsInnerJoinField;
    private String nrErrorsRightJoinField;
    private String keyDescriptionField;
    private String valueReferenceField;
    private String valueCompareField;

    public String getReferenceSchemaField() {
        return this.referenceSchemaField;
    }

    public void setReferenceSchemaField(String referenceSchemaField) {
        this.referenceSchemaField = referenceSchemaField;
    }

    public String getReferenceTableField() {
        return this.referenceTableField;
    }

    public void setReferenceTableField(String referenceTableField) {
        this.referenceTableField = referenceTableField;
    }

    public String getCompareSchemaField() {
        return this.compareSchemaField;
    }

    public void setCompareSchemaField(String compareSchemaField) {
        this.compareSchemaField = compareSchemaField;
    }

    public String getCompareTableField() {
        return this.compareTableField;
    }

    public void setCompareTableField(String compareTableField) {
        this.compareTableField = compareTableField;
    }

    public String getNrErrorsField() {
        return this.nrErrorsField;
    }

    public void setNrErrorsField(String nrErrorsField) {
        this.nrErrorsField = nrErrorsField;
    }

    public DatabaseMeta getReferenceConnection() {
        return this.referenceConnection;
    }

    public void setReferenceConnection(DatabaseMeta referenceConnection) {
        this.referenceConnection = referenceConnection;
    }

    public DatabaseMeta getCompareConnection() {
        return this.compareConnection;
    }

    public void setCompareConnection(DatabaseMeta compareConnection) {
        this.compareConnection = compareConnection;
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        ArrayList<DatabaseMeta> connList = new ArrayList<DatabaseMeta>(2);
        if (this.compareConnection != null) {
            connList.add(this.compareConnection);
        }
        if (this.referenceConnection != null) {
            connList.add(this.referenceConnection);
        }
        if (connList.size() > 0) {
            DatabaseMeta[] rtn = new DatabaseMeta[connList.size()];
            connList.toArray(rtn);
            return rtn;
        }
        return super.getUsedDatabaseConnections();
    }

    public String getKeyFieldsField() {
        return this.keyFieldsField;
    }

    public void setKeyFieldsField(String keyFieldsField) {
        this.keyFieldsField = keyFieldsField;
    }

    public String getExcludeFieldsField() {
        return this.excludeFieldsField;
    }

    public void setExcludeFieldsField(String excludeFieldsField) {
        this.excludeFieldsField = excludeFieldsField;
    }

    public String getNrRecordsReferenceField() {
        return this.nrRecordsReferenceField;
    }

    public void setNrRecordsReferenceField(String nrRecordsReferenceField) {
        this.nrRecordsReferenceField = nrRecordsReferenceField;
    }

    public String getNrRecordsCompareField() {
        return this.nrRecordsCompareField;
    }

    public void setNrRecordsCompareField(String nrRecordsCompareField) {
        this.nrRecordsCompareField = nrRecordsCompareField;
    }

    public String getNrErrorsLeftJoinField() {
        return this.nrErrorsLeftJoinField;
    }

    public void setNrErrorsLeftJoinField(String nrErrorsLeftJoinField) {
        this.nrErrorsLeftJoinField = nrErrorsLeftJoinField;
    }

    public String getNrErrorsInnerJoinField() {
        return this.nrErrorsInnerJoinField;
    }

    public void setNrErrorsInnerJoinField(String nrErrorsInnerJoinField) {
        this.nrErrorsInnerJoinField = nrErrorsInnerJoinField;
    }

    public String getNrErrorsRightJoinField() {
        return this.nrErrorsRightJoinField;
    }

    public void setNrErrorsRightJoinField(String nrErrorsRightJoinField) {
        this.nrErrorsRightJoinField = nrErrorsRightJoinField;
    }

    public String getKeyDescriptionField() {
        return this.keyDescriptionField;
    }

    public void setKeyDescriptionField(String keyDescriptionField) {
        this.keyDescriptionField = keyDescriptionField;
    }

    public String getValueReferenceField() {
        return this.valueReferenceField;
    }

    public void setValueReferenceField(String valueReferenceField) {
        this.valueReferenceField = valueReferenceField;
    }

    public String getValueCompareField() {
        return this.valueCompareField;
    }

    public void setValueCompareField(String valueCompareField) {
        this.valueCompareField = valueCompareField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        TableCompareMeta retval = (TableCompareMeta)super.clone();
        return retval;
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (Utils.isEmpty((CharSequence)this.nrErrorsField)) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"TableCompareMeta.Exception.NrErrorsFieldIsNotSpecified", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)this.nrRecordsReferenceField)) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"TableCompareMeta.Exception.NrRecordsReferenceFieldNotSpecified", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)this.nrRecordsCompareField)) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"TableCompareMeta.Exception.NrRecordsCompareFieldNotSpecified", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)this.nrErrorsLeftJoinField)) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"TableCompareMeta.Exception.NrErrorsLeftJoinFieldNotSpecified", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)this.nrErrorsInnerJoinField)) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"TableCompareMeta.Exception.NrErrorsInnerJoinFieldNotSpecified", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)this.nrErrorsRightJoinField)) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"TableCompareMeta.Exception.NrErrorsRightJoinFieldNotSpecified", (String[])new String[0]));
        }
        ValueMetaInteger nrErrorsValueMeta = new ValueMetaInteger(this.nrErrorsField);
        nrErrorsValueMeta.setLength(9);
        nrErrorsValueMeta.setOrigin(origin);
        inputRowMeta.addValueMeta((ValueMetaInterface)nrErrorsValueMeta);
        ValueMetaInteger nrRecordsReference = new ValueMetaInteger(this.nrRecordsReferenceField);
        nrRecordsReference.setLength(9);
        nrRecordsReference.setOrigin(origin);
        inputRowMeta.addValueMeta((ValueMetaInterface)nrRecordsReference);
        ValueMetaInteger nrRecordsCompare = new ValueMetaInteger(this.nrRecordsCompareField);
        nrRecordsCompare.setLength(9);
        nrRecordsCompare.setOrigin(origin);
        inputRowMeta.addValueMeta((ValueMetaInterface)nrRecordsCompare);
        ValueMetaInteger nrErrorsLeft = new ValueMetaInteger(this.nrErrorsLeftJoinField);
        nrErrorsLeft.setLength(9);
        nrErrorsLeft.setOrigin(origin);
        inputRowMeta.addValueMeta((ValueMetaInterface)nrErrorsLeft);
        ValueMetaInteger nrErrorsInner = new ValueMetaInteger(this.nrErrorsInnerJoinField);
        nrErrorsInner.setLength(9);
        nrErrorsInner.setOrigin(origin);
        inputRowMeta.addValueMeta((ValueMetaInterface)nrErrorsInner);
        ValueMetaInteger nrErrorsRight = new ValueMetaInteger(this.nrErrorsRightJoinField);
        nrErrorsRight.setLength(9);
        nrErrorsRight.setOrigin(origin);
        inputRowMeta.addValueMeta((ValueMetaInterface)nrErrorsRight);
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.referenceConnection = DatabaseMeta.findDatabase(databases, (String)XMLHandler.getTagValue((Node)stepnode, (String)"reference_connection"));
            this.referenceSchemaField = XMLHandler.getTagValue((Node)stepnode, (String)"reference_schema_field");
            this.referenceTableField = XMLHandler.getTagValue((Node)stepnode, (String)"reference_table_field");
            this.compareConnection = DatabaseMeta.findDatabase(databases, (String)XMLHandler.getTagValue((Node)stepnode, (String)"compare_connection"));
            this.compareSchemaField = XMLHandler.getTagValue((Node)stepnode, (String)"compare_schema_field");
            this.compareTableField = XMLHandler.getTagValue((Node)stepnode, (String)"compare_table_field");
            this.keyFieldsField = XMLHandler.getTagValue((Node)stepnode, (String)"key_fields_field");
            this.excludeFieldsField = XMLHandler.getTagValue((Node)stepnode, (String)"exclude_fields_field");
            this.nrErrorsField = XMLHandler.getTagValue((Node)stepnode, (String)"nr_errors_field");
            this.nrRecordsReferenceField = XMLHandler.getTagValue((Node)stepnode, (String)"nr_records_reference_field");
            this.nrRecordsCompareField = XMLHandler.getTagValue((Node)stepnode, (String)"nr_records_compare_field");
            this.nrErrorsLeftJoinField = XMLHandler.getTagValue((Node)stepnode, (String)"nr_errors_left_join_field");
            this.nrErrorsInnerJoinField = XMLHandler.getTagValue((Node)stepnode, (String)"nr_errors_inner_join_field");
            this.nrErrorsRightJoinField = XMLHandler.getTagValue((Node)stepnode, (String)"nr_errors_right_join_field");
            this.keyDescriptionField = XMLHandler.getTagValue((Node)stepnode, (String)"key_description_field");
            this.valueReferenceField = XMLHandler.getTagValue((Node)stepnode, (String)"value_reference_field");
            this.valueCompareField = XMLHandler.getTagValue((Node)stepnode, (String)"value_compare_field");
        }
        catch (Exception e) {
            throw new KettleXMLException("It was not possibke to load the Trim metadata from XML", (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("      ").append(XMLHandler.addTagValue((String)"reference_connection", this.referenceConnection == null ? null : this.referenceConnection.getName()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reference_schema_field", (String)this.referenceSchemaField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reference_table_field", (String)this.referenceTableField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compare_connection", this.compareConnection == null ? null : this.compareConnection.getName()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compare_schema_field", (String)this.compareSchemaField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compare_table_field", (String)this.compareTableField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"key_fields_field", (String)this.keyFieldsField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"exclude_fields_field", (String)this.excludeFieldsField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_errors_field", (String)this.nrErrorsField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_records_reference_field", (String)this.nrRecordsReferenceField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_records_compare_field", (String)this.nrRecordsCompareField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_errors_left_join_field", (String)this.nrErrorsLeftJoinField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_errors_inner_join_field", (String)this.nrErrorsInnerJoinField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_errors_right_join_field", (String)this.nrErrorsRightJoinField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"key_description_field", (String)this.keyDescriptionField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"value_reference_field", (String)this.valueReferenceField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"value_compare_field", (String)this.valueCompareField));
        return retval.toString();
    }

    @Override
    public void setDefault() {
        this.nrErrorsField = "nrErrors";
        this.nrRecordsReferenceField = "nrRecordsReferenceTable";
        this.nrRecordsCompareField = "nrRecordsCompareTable";
        this.nrErrorsLeftJoinField = "nrErrorsLeftJoin";
        this.nrErrorsInnerJoinField = "nrErrorsInnerJoin";
        this.nrErrorsRightJoinField = "nrErrorsRightJoin";
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.referenceConnection = rep.loadDatabaseMetaFromStepAttribute(id_step, "reference_connection_id", databases);
            this.referenceSchemaField = rep.getStepAttributeString(id_step, "reference_schema_field");
            this.referenceTableField = rep.getStepAttributeString(id_step, "reference_table_field");
            this.compareConnection = rep.loadDatabaseMetaFromStepAttribute(id_step, "compare_connection_id", databases);
            this.compareSchemaField = rep.getStepAttributeString(id_step, "compare_schema_field");
            this.compareTableField = rep.getStepAttributeString(id_step, "compare_table_field");
            this.keyFieldsField = rep.getStepAttributeString(id_step, "key_fields_field");
            this.excludeFieldsField = rep.getStepAttributeString(id_step, "exclude_fields_field");
            this.nrErrorsField = rep.getStepAttributeString(id_step, "nr_errors_field");
            this.nrRecordsReferenceField = rep.getStepAttributeString(id_step, "nr_records_reference_field");
            this.nrRecordsCompareField = rep.getStepAttributeString(id_step, "nr_records_compare_field");
            this.nrErrorsLeftJoinField = rep.getStepAttributeString(id_step, "nr_errors_left_join_field");
            this.nrErrorsInnerJoinField = rep.getStepAttributeString(id_step, "nr_errors_inner_join_field");
            this.nrErrorsRightJoinField = rep.getStepAttributeString(id_step, "nr_errors_right_join_field");
            this.keyDescriptionField = rep.getStepAttributeString(id_step, "key_description_field");
            this.valueReferenceField = rep.getStepAttributeString(id_step, "value_reference_field");
            this.valueCompareField = rep.getStepAttributeString(id_step, "value_compare_field");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "reference_connection_id", this.referenceConnection);
            rep.saveStepAttribute(id_transformation, id_step, "reference_schema_field", this.referenceSchemaField);
            rep.saveStepAttribute(id_transformation, id_step, "reference_table_field", this.referenceTableField);
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "compare_connection_id", this.compareConnection);
            rep.saveStepAttribute(id_transformation, id_step, "compare_schema_field", this.compareSchemaField);
            rep.saveStepAttribute(id_transformation, id_step, "compare_table_field", this.compareTableField);
            rep.saveStepAttribute(id_transformation, id_step, "key_fields_field", this.keyFieldsField);
            rep.saveStepAttribute(id_transformation, id_step, "exclude_fields_field", this.excludeFieldsField);
            rep.saveStepAttribute(id_transformation, id_step, "nr_errors_field", this.nrErrorsField);
            rep.saveStepAttribute(id_transformation, id_step, "nr_records_reference_field", this.nrRecordsReferenceField);
            rep.saveStepAttribute(id_transformation, id_step, "nr_records_compare_field", this.nrRecordsCompareField);
            rep.saveStepAttribute(id_transformation, id_step, "nr_errors_left_join_field", this.nrErrorsLeftJoinField);
            rep.saveStepAttribute(id_transformation, id_step, "nr_errors_inner_join_field", this.nrErrorsInnerJoinField);
            rep.saveStepAttribute(id_transformation, id_step, "nr_errors_right_join_field", this.nrErrorsRightJoinField);
            rep.saveStepAttribute(id_transformation, id_step, "key_description_field", this.keyDescriptionField);
            rep.saveStepAttribute(id_transformation, id_step, "value_reference_field", this.valueReferenceField);
            rep.saveStepAttribute(id_transformation, id_step, "value_compare_field", this.valueCompareField);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new TableCompare(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new TableCompareData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

