/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.switchcase;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.switchcase.ContainsKeyToRowSetMap;
import org.pentaho.di.trans.steps.switchcase.KeyToRowSetMap;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseData;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseMeta;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseTarget;

public class SwitchCase
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SwitchCaseMeta.class;
    private SwitchCaseMeta meta;
    private SwitchCaseData data;

    public SwitchCase(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Set<RowSet> rowSetSet;
        this.meta = (SwitchCaseMeta)smi;
        this.data = (SwitchCaseData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.createOutputValueMapping();
        }
        Object lookupData = this.data.valueMeta.convertData(this.data.inputValueMeta, r[this.data.fieldIndex]);
        Set<RowSet> set = rowSetSet = this.data.valueMeta.isNull(lookupData = SwitchCase.prepareObjectType(lookupData)) ? this.data.nullRowSetSet : this.data.outputMap.get(lookupData);
        if (rowSetSet == null) {
            rowSetSet = this.data.defaultRowSetSet;
        }
        for (RowSet rowSet : rowSetSet) {
            this.putRowTo(this.data.outputRowMeta, r, rowSet);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"SwitchCase.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SwitchCaseMeta)smi;
        this.data = (SwitchCaseData)sdi;
        if (!super.init(smi, sdi)) {
            return false;
        }
        KeyToRowSetMap keyToRowSetMap = this.data.outputMap = this.meta.isContains() ? new ContainsKeyToRowSetMap() : new KeyToRowSetMap();
        if (Utils.isEmpty((CharSequence)this.meta.getFieldname())) {
            this.logError(BaseMessages.getString(PKG, (String)"SwitchCase.Log.NoFieldSpecifiedToSwitchWith", (String[])new String[0]));
            return false;
        }
        try {
            this.data.valueMeta = ValueMetaFactory.createValueMeta((String)this.meta.getFieldname(), (int)this.meta.getCaseValueType());
            this.data.valueMeta.setConversionMask(this.meta.getCaseValueFormat());
            this.data.valueMeta.setGroupingSymbol(this.meta.getCaseValueGroup());
            this.data.valueMeta.setDecimalSymbol(this.meta.getCaseValueDecimal());
            this.data.stringValueMeta = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)this.data.valueMeta, (int)2);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"SwitchCase.Log.UnexpectedError", (Object[])new Object[]{e}));
        }
        return true;
    }

    void createOutputValueMapping() throws KettleException {
        this.data.outputRowMeta = this.getInputRowMeta().clone();
        this.meta.getFields(this.getInputRowMeta(), this.getStepname(), null, null, this, this.repository, this.metaStore);
        this.data.fieldIndex = this.getInputRowMeta().indexOfValue(this.meta.getFieldname());
        if (this.data.fieldIndex < 0) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SwitchCase.Exception.UnableToFindFieldName", (String[])new String[]{this.meta.getFieldname()}));
        }
        this.data.inputValueMeta = this.getInputRowMeta().getValueMeta(this.data.fieldIndex);
        try {
            RowSet rowSet;
            SwitchCaseTarget target;
            StepIOMetaInterface ioMeta = this.meta.getStepIOMeta();
            List<StreamInterface> targetStreams = ioMeta.getTargetStreams();
            for (int i = 0; i < targetStreams.size() && (target = (SwitchCaseTarget)targetStreams.get(i).getSubject()) != null; ++i) {
                if (target.caseTargetStep == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SwitchCase.Log.NoTargetStepSpecifiedForValue", (String[])new String[]{target.caseValue}));
                }
                RowSet rowSet2 = this.findOutputRowSet(target.caseTargetStep.getName());
                if (rowSet2 == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SwitchCase.Log.UnableToFindTargetRowSetForStep", (Object[])new Object[]{target.caseTargetStep}));
                }
                try {
                    Object value = this.data.valueMeta.convertDataFromString(target.caseValue, this.data.stringValueMeta, null, null, 0);
                    if (this.data.valueMeta.isNull(value)) {
                        this.data.nullRowSetSet.add(rowSet2);
                        continue;
                    }
                    value = SwitchCase.prepareObjectType(value);
                    this.data.outputMap.put(value, rowSet2);
                    continue;
                }
                catch (Exception e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SwitchCase.Log.UnableToConvertValue", (String[])new String[]{target.caseValue}), (Throwable)e);
                }
            }
            if (this.meta.getDefaultTargetStep() != null && (rowSet = this.findOutputRowSet(this.meta.getDefaultTargetStep().getName())) != null) {
                this.data.defaultRowSetSet.add(rowSet);
                if (this.data.nullRowSetSet.isEmpty()) {
                    this.data.nullRowSetSet.add(rowSet);
                }
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    protected static Object prepareObjectType(Object o) {
        return o instanceof byte[] ? Integer.valueOf(Arrays.hashCode((byte[])o)) : o;
    }
}

