/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.stepsmetrics;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.stepsmetrics.StepsMetrics;
import org.pentaho.di.trans.steps.stepsmetrics.StepsMetricsData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class StepsMetricsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = StepsMetrics.class;
    public static final String[] RequiredStepsDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredStepsCode = new String[]{"N", "Y"};
    public static final String YES = "Y";
    public static final String NO = "N";
    private String[] stepName;
    private String[] stepCopyNr;
    private String[] stepRequired;
    private String stepnamefield;
    private String stepidfield;
    private String steplinesinputfield;
    private String steplinesoutputfield;
    private String steplinesreadfield;
    private String steplinesupdatedfield;
    private String steplineswrittentfield;
    private String steplineserrorsfield;
    private String stepsecondsfield;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        StepsMetricsMeta retval = (StepsMetricsMeta)super.clone();
        int nrfields = this.stepName.length;
        retval.allocate(nrfields);
        System.arraycopy(this.stepName, 0, retval.stepName, 0, nrfields);
        System.arraycopy(this.stepCopyNr, 0, retval.stepCopyNr, 0, nrfields);
        System.arraycopy(this.stepRequired, 0, retval.stepRequired, 0, nrfields);
        return retval;
    }

    public void allocate(int nrfields) {
        this.stepName = new String[nrfields];
        this.stepCopyNr = new String[nrfields];
        this.stepRequired = new String[nrfields];
    }

    public String[] getStepName() {
        return this.stepName;
    }

    public String[] getStepCopyNr() {
        return this.stepCopyNr;
    }

    public void setStepName(String[] stepName) {
        this.stepName = stepName;
    }

    public void setStepCopyNr(String[] stepCopyNr) {
        this.stepCopyNr = stepCopyNr;
    }

    public String getRequiredStepsDesc(String tt) {
        if (tt == null) {
            return RequiredStepsDesc[0];
        }
        if (tt.equals(RequiredStepsCode[1])) {
            return RequiredStepsDesc[1];
        }
        return RequiredStepsDesc[0];
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        String stepseconds;
        String steplineserrors;
        String steplineswritten;
        String steplinesupdated;
        String steplinesread;
        String steplinesoutput;
        String steplinesinput;
        String stepid;
        r.clear();
        String stepname = space.environmentSubstitute(this.stepnamefield);
        if (!Utils.isEmpty((CharSequence)stepname)) {
            ValueMetaString v = new ValueMetaString(stepname);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (!Utils.isEmpty((CharSequence)(stepid = space.environmentSubstitute(this.stepidfield)))) {
            ValueMetaString v = new ValueMetaString(stepid);
            v.setOrigin(name);
            v.setLength(10, 0);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (!Utils.isEmpty((CharSequence)(steplinesinput = space.environmentSubstitute(this.steplinesinputfield)))) {
            ValueMetaInteger v = new ValueMetaInteger(steplinesinput);
            v.setOrigin(name);
            v.setLength(10, 0);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (!Utils.isEmpty((CharSequence)(steplinesoutput = space.environmentSubstitute(this.steplinesoutputfield)))) {
            ValueMetaInteger v = new ValueMetaInteger(steplinesoutput);
            v.setOrigin(name);
            v.setLength(10, 0);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (!Utils.isEmpty((CharSequence)(steplinesread = space.environmentSubstitute(this.steplinesreadfield)))) {
            ValueMetaInteger v = new ValueMetaInteger(steplinesread);
            v.setOrigin(name);
            v.setLength(10, 0);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (!Utils.isEmpty((CharSequence)(steplinesupdated = space.environmentSubstitute(this.steplinesupdatedfield)))) {
            ValueMetaInteger v = new ValueMetaInteger(steplinesupdated);
            v.setOrigin(name);
            v.setLength(10, 0);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (!Utils.isEmpty((CharSequence)(steplineswritten = space.environmentSubstitute(this.steplineswrittentfield)))) {
            ValueMetaInteger v = new ValueMetaInteger(steplineswritten);
            v.setOrigin(name);
            v.setLength(10, 0);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (!Utils.isEmpty((CharSequence)(steplineserrors = space.environmentSubstitute(this.steplineserrorsfield)))) {
            ValueMetaInteger v = new ValueMetaInteger(steplineserrors);
            v.setOrigin(name);
            v.setLength(10, 0);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (!Utils.isEmpty((CharSequence)(stepseconds = space.environmentSubstitute(this.stepsecondsfield)))) {
            ValueMetaInteger v = new ValueMetaInteger(stepseconds);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node steps = XMLHandler.getSubNode((Node)stepnode, (String)"steps");
            int nrsteps = XMLHandler.countNodes((Node)steps, (String)"step");
            this.allocate(nrsteps);
            for (int i = 0; i < nrsteps; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)steps, (String)"step", (int)i);
                this.stepName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.stepCopyNr[i] = XMLHandler.getTagValue((Node)fnode, (String)"copyNr");
                this.stepRequired[i] = XMLHandler.getTagValue((Node)fnode, (String)"stepRequired");
            }
            this.stepnamefield = XMLHandler.getTagValue((Node)stepnode, (String)"stepnamefield");
            this.stepidfield = XMLHandler.getTagValue((Node)stepnode, (String)"stepidfield");
            this.steplinesinputfield = XMLHandler.getTagValue((Node)stepnode, (String)"steplinesinputfield");
            this.steplinesoutputfield = XMLHandler.getTagValue((Node)stepnode, (String)"steplinesoutputfield");
            this.steplinesreadfield = XMLHandler.getTagValue((Node)stepnode, (String)"steplinesreadfield");
            this.steplinesupdatedfield = XMLHandler.getTagValue((Node)stepnode, (String)"steplinesupdatedfield");
            this.steplineswrittentfield = XMLHandler.getTagValue((Node)stepnode, (String)"steplineswrittentfield");
            this.steplineserrorsfield = XMLHandler.getTagValue((Node)stepnode, (String)"steplineserrorsfield");
            this.stepsecondsfield = XMLHandler.getTagValue((Node)stepnode, (String)"stepsecondsfield");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    <steps>" + Const.CR);
        for (int i = 0; i < this.stepName.length; ++i) {
            retval.append("      <step>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.stepName[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"copyNr", (String)this.stepCopyNr[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"stepRequired", (String)this.stepRequired[i]));
            retval.append("        </step>" + Const.CR);
        }
        retval.append("      </steps>" + Const.CR);
        retval.append("        " + XMLHandler.addTagValue((String)"stepnamefield", (String)this.stepnamefield));
        retval.append("        " + XMLHandler.addTagValue((String)"stepidfield", (String)this.stepidfield));
        retval.append("        " + XMLHandler.addTagValue((String)"steplinesinputfield", (String)this.steplinesinputfield));
        retval.append("        " + XMLHandler.addTagValue((String)"steplinesoutputfield", (String)this.steplinesoutputfield));
        retval.append("        " + XMLHandler.addTagValue((String)"steplinesreadfield", (String)this.steplinesreadfield));
        retval.append("        " + XMLHandler.addTagValue((String)"steplinesupdatedfield", (String)this.steplinesupdatedfield));
        retval.append("        " + XMLHandler.addTagValue((String)"steplineswrittentfield", (String)this.steplineswrittentfield));
        retval.append("        " + XMLHandler.addTagValue((String)"steplineserrorsfield", (String)this.steplineserrorsfield));
        retval.append("        " + XMLHandler.addTagValue((String)"stepsecondsfield", (String)this.stepsecondsfield));
        return retval.toString();
    }

    @Override
    public void setDefault() {
        int nrsteps = 0;
        this.allocate(nrsteps);
        for (int i = 0; i < nrsteps; ++i) {
            this.stepName[i] = "step" + i;
            this.stepCopyNr[i] = "CopyNr" + i;
            this.stepRequired[i] = NO;
        }
        this.stepnamefield = BaseMessages.getString(PKG, (String)"StepsMetricsDialog.Label.Stepname", (String[])new String[0]);
        this.stepidfield = BaseMessages.getString(PKG, (String)"StepsMetricsDialog.Label.Stepid", (String[])new String[0]);
        this.steplinesinputfield = BaseMessages.getString(PKG, (String)"StepsMetricsDialog.Label.Linesinput", (String[])new String[0]);
        this.steplinesoutputfield = BaseMessages.getString(PKG, (String)"StepsMetricsDialog.Label.Linesoutput", (String[])new String[0]);
        this.steplinesreadfield = BaseMessages.getString(PKG, (String)"StepsMetricsDialog.Label.Linesread", (String[])new String[0]);
        this.steplinesupdatedfield = BaseMessages.getString(PKG, (String)"StepsMetricsDialog.Label.Linesupdated", (String[])new String[0]);
        this.steplineswrittentfield = BaseMessages.getString(PKG, (String)"StepsMetricsDialog.Label.Lineswritten", (String[])new String[0]);
        this.steplineserrorsfield = BaseMessages.getString(PKG, (String)"StepsMetricsDialog.Label.Lineserrors", (String[])new String[0]);
        this.stepsecondsfield = BaseMessages.getString(PKG, (String)"StepsMetricsDialog.Label.Time", (String[])new String[0]);
    }

    public void setStepRequired(String[] stepRequiredin) {
        for (int i = 0; i < stepRequiredin.length; ++i) {
            this.stepRequired[i] = this.getRequiredStepsCode(stepRequiredin[i]);
        }
    }

    public String getRequiredStepsCode(String tt) {
        if (tt == null) {
            return RequiredStepsCode[0];
        }
        if (tt.equals(RequiredStepsDesc[1])) {
            return RequiredStepsCode[1];
        }
        return RequiredStepsCode[0];
    }

    public String[] getStepRequired() {
        return this.stepRequired;
    }

    public String getStepNameFieldName() {
        return this.stepnamefield;
    }

    public void setStepNameFieldName(String stepnamefield) {
        this.stepnamefield = stepnamefield;
    }

    public String getStepIdFieldName() {
        return this.stepidfield;
    }

    public void setStepIdFieldName(String stepidfield) {
        this.stepidfield = stepidfield;
    }

    public String getStepLinesInputFieldName() {
        return this.steplinesinputfield;
    }

    public void setStepLinesInputFieldName(String steplinesinputfield) {
        this.steplinesinputfield = steplinesinputfield;
    }

    public String getStepLinesOutputFieldName() {
        return this.steplinesoutputfield;
    }

    public void setStepLinesOutputFieldName(String steplinesoutputfield) {
        this.steplinesoutputfield = steplinesoutputfield;
    }

    public String getStepLinesReadFieldName() {
        return this.steplinesreadfield;
    }

    public void setStepLinesReadFieldName(String steplinesreadfield) {
        this.steplinesreadfield = steplinesreadfield;
    }

    public String getStepLinesWrittenFieldName() {
        return this.steplineswrittentfield;
    }

    public void setStepLinesWrittenFieldName(String steplineswrittentfield) {
        this.steplineswrittentfield = steplineswrittentfield;
    }

    public String getStepLinesErrorsFieldName() {
        return this.steplineserrorsfield;
    }

    public String getStepSecondsFieldName() {
        return this.stepsecondsfield;
    }

    public void setStepSecondsFieldName(String fieldname) {
        this.stepsecondsfield = fieldname;
    }

    public void setStepLinesErrorsFieldName(String steplineserrorsfield) {
        this.steplineserrorsfield = steplineserrorsfield;
    }

    public String getStepLinesUpdatedFieldName() {
        return this.steplinesupdatedfield;
    }

    public void setStepLinesUpdatedFieldName(String steplinesupdatedfield) {
        this.steplinesupdatedfield = steplinesupdatedfield;
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrsteps = rep.countNrStepAttributes(id_step, "step_name");
            this.allocate(nrsteps);
            for (int i = 0; i < nrsteps; ++i) {
                this.stepName[i] = rep.getStepAttributeString(id_step, i, "step_name");
                this.stepCopyNr[i] = rep.getStepAttributeString(id_step, i, "step_CopyNr");
                this.stepRequired[i] = rep.getStepAttributeString(id_step, i, "step_required");
                if (YES.equalsIgnoreCase(this.stepRequired[i])) continue;
                this.stepRequired[i] = NO;
            }
            this.stepnamefield = rep.getStepAttributeString(id_step, "stepnamefield");
            this.stepidfield = rep.getStepAttributeString(id_step, "stepidfield");
            this.steplinesinputfield = rep.getStepAttributeString(id_step, "steplinesinputfield");
            this.steplinesoutputfield = rep.getStepAttributeString(id_step, "steplinesoutputfield");
            this.steplinesreadfield = rep.getStepAttributeString(id_step, "steplinesreadfield");
            this.steplineswrittentfield = rep.getStepAttributeString(id_step, "steplineswrittentfield");
            this.steplinesupdatedfield = rep.getStepAttributeString(id_step, "steplinesupdatedfield");
            this.steplineserrorsfield = rep.getStepAttributeString(id_step, "steplineserrorsfield");
            this.stepsecondsfield = rep.getStepAttributeString(id_step, "stepsecondsfield");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.stepName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "step_name", this.stepName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "step_CopyNr", this.stepCopyNr[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "step_required", this.stepRequired[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "stepnamefield", this.stepnamefield);
            rep.saveStepAttribute(id_transformation, id_step, "stepidfield", this.stepidfield);
            rep.saveStepAttribute(id_transformation, id_step, "steplinesinputfield", this.steplinesinputfield);
            rep.saveStepAttribute(id_transformation, id_step, "steplinesoutputfield", this.steplinesoutputfield);
            rep.saveStepAttribute(id_transformation, id_step, "steplinesreadfield", this.steplinesreadfield);
            rep.saveStepAttribute(id_transformation, id_step, "steplineswrittentfield", this.steplineswrittentfield);
            rep.saveStepAttribute(id_transformation, id_step, "steplinesupdatedfield", this.steplinesupdatedfield);
            rep.saveStepAttribute(id_transformation, id_step, "steplineserrorsfield", this.steplineserrorsfield);
            rep.saveStepAttribute(id_transformation, id_step, "stepsecondsfield", this.stepsecondsfield);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StepsMetricsMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            cr = this.stepName.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"StepsMetricsMeta.CheckResult.AllStepsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(3, BaseMessages.getString(PKG, (String)"StepsMetricsMeta.CheckResult.NoStepsEntered", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StepsMetricsMeta.CheckResult.ReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"StepsMetricsMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"StepsMetricsMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new StepsMetrics(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new StepsMetricsData();
    }

    @Override
    public TransMeta.TransformationType[] getSupportedTransformationTypes() {
        return new TransMeta.TransformationType[]{TransMeta.TransformationType.Normal};
    }
}

