/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mergerows;

import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleRowException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.mergerows.MergeRowsData;
import org.pentaho.di.trans.steps.mergerows.MergeRowsMeta;

public class MergeRows
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MergeRowsMeta.class;
    private static final String VALUE_IDENTICAL = "identical";
    private static final String VALUE_CHANGED = "changed";
    private static final String VALUE_NEW = "new";
    private static final String VALUE_DELETED = "deleted";
    private MergeRowsMeta meta;
    private MergeRowsData data;
    private boolean useRefWhenIdentical = false;

    public MergeRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        int outputIndex;
        Object[] outputRow;
        this.meta = (MergeRowsMeta)smi;
        this.data = (MergeRowsData)sdi;
        if (this.first) {
            int i;
            this.first = false;
            List<StreamInterface> infoStreams = this.meta.getStepIOMeta().getInfoStreams();
            this.data.oneRowSet = this.findInputRowSet(infoStreams.get(0).getStepname());
            this.data.twoRowSet = this.findInputRowSet(infoStreams.get(1).getStepname());
            String useRefWhenIdenticalVar = Const.NVL((String)System.getProperty("KETTLE_COMPATIBILITY_MERGE_ROWS_USE_REFERENCE_STREAM_WHEN_IDENTICAL"), (String)"N");
            this.useRefWhenIdentical = !"N".equalsIgnoreCase(useRefWhenIdenticalVar);
            this.data.one = this.getRowFrom(this.data.oneRowSet);
            this.data.two = this.getRowFrom(this.data.twoRowSet);
            try {
                MergeRows.checkInputLayoutValid(this.data.oneRowSet.getRowMeta(), this.data.twoRowSet.getRowMeta());
            }
            catch (KettleRowException e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MergeRows.Exception.InvalidLayoutDetected", (String[])new String[0]), (Throwable)e);
            }
            if (this.data.one != null) {
                this.data.keyNrs = new int[this.meta.getKeyFields().length];
                for (i = 0; i < this.data.keyNrs.length; ++i) {
                    this.data.keyNrs[i] = this.data.oneRowSet.getRowMeta().indexOfValue(this.meta.getKeyFields()[i]);
                    if (this.data.keyNrs[i] >= 0) continue;
                    String message = BaseMessages.getString(PKG, (String)"MergeRows.Exception.UnableToFindFieldInReferenceStream", (String[])new String[]{this.meta.getKeyFields()[i]});
                    this.logError(message);
                    throw new KettleStepException(message);
                }
            }
            if (this.data.two != null) {
                this.data.valueNrs = new int[this.meta.getValueFields().length];
                for (i = 0; i < this.data.valueNrs.length; ++i) {
                    this.data.valueNrs[i] = this.data.twoRowSet.getRowMeta().indexOfValue(this.meta.getValueFields()[i]);
                    if (this.data.valueNrs[i] >= 0) continue;
                    String message = BaseMessages.getString(PKG, (String)"MergeRows.Exception.UnableToFindFieldInReferenceStream", (String[])new String[]{this.meta.getValueFields()[i]});
                    this.logError(message);
                    throw new KettleStepException(message);
                }
            }
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"MergeRows.Log.DataInfo", (String[])new String[]{Arrays.toString(this.data.one) + ""}) + Arrays.toString(this.data.two));
        }
        if (this.data.one == null && this.data.two == null) {
            this.setOutputDone();
            return false;
        }
        if (this.data.outputRowMeta == null) {
            this.data.outputRowMeta = new RowMeta();
            if (this.data.one != null) {
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), new RowMetaInterface[]{this.data.oneRowSet.getRowMeta()}, null, this, this.repository, this.metaStore);
            } else {
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), new RowMetaInterface[]{this.data.twoRowSet.getRowMeta()}, null, this, this.repository, this.metaStore);
            }
        }
        String flagField = null;
        if (this.data.one == null && this.data.two != null) {
            outputRow = this.data.two;
            outputIndex = this.data.twoRowSet.getRowMeta().size();
            flagField = VALUE_NEW;
            this.data.two = this.getRowFrom(this.data.twoRowSet);
        } else if (this.data.one != null && this.data.two == null) {
            outputRow = this.data.one;
            outputIndex = this.data.oneRowSet.getRowMeta().size();
            flagField = VALUE_DELETED;
            this.data.one = this.getRowFrom(this.data.oneRowSet);
        } else {
            int compare = this.data.oneRowSet.getRowMeta().compare(this.data.one, this.data.two, this.data.keyNrs);
            if (compare == 0) {
                int compareValues = this.data.oneRowSet.getRowMeta().compare(this.data.one, this.data.two, this.data.valueNrs);
                if (compareValues == 0) {
                    if (this.useRefWhenIdentical) {
                        outputRow = this.data.one;
                        outputIndex = this.data.oneRowSet.getRowMeta().size();
                    } else {
                        outputRow = this.data.two;
                        outputIndex = this.data.twoRowSet.getRowMeta().size();
                    }
                    flagField = VALUE_IDENTICAL;
                } else {
                    outputRow = this.data.two;
                    outputIndex = this.data.twoRowSet.getRowMeta().size();
                    flagField = VALUE_CHANGED;
                }
                this.data.one = this.getRowFrom(this.data.oneRowSet);
                this.data.two = this.getRowFrom(this.data.twoRowSet);
            } else if (compare < 0) {
                outputRow = this.data.one;
                outputIndex = this.data.oneRowSet.getRowMeta().size();
                flagField = VALUE_DELETED;
                this.data.one = this.getRowFrom(this.data.oneRowSet);
            } else {
                outputRow = this.data.two;
                outputIndex = this.data.twoRowSet.getRowMeta().size();
                flagField = VALUE_NEW;
                this.data.two = this.getRowFrom(this.data.twoRowSet);
            }
        }
        this.putRow(this.data.outputRowMeta, RowDataUtil.addValueData((Object[])outputRow, (int)outputIndex, (Object)flagField));
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"MergeRows.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MergeRowsMeta)smi;
        this.data = (MergeRowsData)sdi;
        if (super.init(smi, sdi)) {
            List<StreamInterface> infoStreams = this.meta.getStepIOMeta().getInfoStreams();
            if (infoStreams.get(0).getStepMeta() != null ^ infoStreams.get(1).getStepMeta() != null) {
                this.logError(BaseMessages.getString(PKG, (String)"MergeRows.Log.BothTrueAndFalseNeeded", (String[])new String[0]));
            } else {
                return true;
            }
        }
        return false;
    }

    static void checkInputLayoutValid(RowMetaInterface referenceRowMeta, RowMetaInterface compareRowMeta) throws KettleRowException {
        if (referenceRowMeta != null && compareRowMeta != null) {
            BaseStep.safeModeChecking(referenceRowMeta, compareRowMeta);
        }
    }
}

