/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput.jxl;

import java.io.IOException;
import java.io.InputStream;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.spreadsheet.KSheet;
import org.pentaho.di.core.spreadsheet.KWorkbook;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.steps.excelinput.jxl.XLSSheet;

public class XLSWorkbook
implements KWorkbook {
    private LogChannelInterface log;
    private Workbook workbook;
    private String filename;
    private String encoding;
    private InputStream inputStream;

    public XLSWorkbook(String filename, String encoding) throws KettleException {
        this.filename = filename;
        this.encoding = encoding;
        WorkbookSettings ws = new WorkbookSettings();
        if (!Utils.isEmpty((CharSequence)encoding)) {
            ws.setEncoding(encoding);
        }
        try {
            this.inputStream = KettleVFS.getInputStream((String)filename);
            this.workbook = Workbook.getWorkbook((InputStream)this.inputStream, (WorkbookSettings)ws);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public XLSWorkbook(InputStream inputStream, String encoding) throws KettleException {
        this.encoding = encoding;
        WorkbookSettings ws = new WorkbookSettings();
        if (!Utils.isEmpty((CharSequence)encoding)) {
            ws.setEncoding(encoding);
        }
        try {
            this.workbook = Workbook.getWorkbook((InputStream)inputStream, (WorkbookSettings)ws);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void close() {
        if (this.workbook != null) {
            this.workbook.close();
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                this.log.logError("Could not close workbook", (Throwable)e);
            }
        }
    }

    public KSheet getSheet(String sheetName) {
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            return null;
        }
        return new XLSSheet(sheet);
    }

    public String[] getSheetNames() {
        return this.workbook.getSheetNames();
    }

    public String getFilename() {
        return this.filename;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    public KSheet getSheet(int sheetNr) {
        Sheet sheet = this.workbook.getSheet(sheetNr);
        if (sheet == null) {
            return null;
        }
        return new XLSSheet(sheet);
    }

    public String getSheetName(int sheetNr) {
        Sheet sheet = this.workbook.getSheet(sheetNr);
        if (sheet == null) {
            return null;
        }
        return sheet.getName();
    }
}

