/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput;

import java.io.InputStream;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.spreadsheet.KWorkbook;
import org.pentaho.di.trans.steps.excelinput.SpreadSheetType;
import org.pentaho.di.trans.steps.excelinput.jxl.XLSWorkbook;
import org.pentaho.di.trans.steps.excelinput.ods.OdfWorkbook;
import org.pentaho.di.trans.steps.excelinput.poi.PoiWorkbook;
import org.pentaho.di.trans.steps.excelinput.staxpoi.StaxPoiWorkbook;

public class WorkbookFactory {
    public static KWorkbook getWorkbook(SpreadSheetType type, String filename, String encoding) throws KettleException {
        return WorkbookFactory.getWorkbook(type, filename, encoding, null);
    }

    public static KWorkbook getWorkbook(SpreadSheetType type, String filename, String encoding, String password) throws KettleException {
        switch (type) {
            case JXL: {
                return new XLSWorkbook(filename, encoding);
            }
            case POI: {
                return new PoiWorkbook(filename, encoding, password);
            }
            case SAX_POI: {
                return new StaxPoiWorkbook(filename, encoding);
            }
            case ODS: {
                return new OdfWorkbook(filename, encoding);
            }
        }
        throw new KettleException("Sorry, spreadsheet type " + type.getDescription() + " is not yet supported");
    }

    public static KWorkbook getWorkbook(SpreadSheetType type, InputStream inputStream, String encoding) throws KettleException {
        switch (type) {
            case JXL: {
                return new XLSWorkbook(inputStream, encoding);
            }
            case POI: {
                return new PoiWorkbook(inputStream, encoding);
            }
            case SAX_POI: {
                return new StaxPoiWorkbook(inputStream, encoding);
            }
            case ODS: {
                return new OdfWorkbook(inputStream, encoding);
            }
        }
        throw new KettleException("Sorry, spreadsheet type " + type.getDescription() + " is not yet supported");
    }
}

