/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.delete;

import java.sql.SQLException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.delete.DeleteData;
import org.pentaho.di.trans.steps.delete.DeleteMeta;

public class Delete
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = DeleteMeta.class;
    private DeleteMeta meta;
    private DeleteData data;

    public Delete(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized void deleteValues(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        Object[] deleteRow = new Object[this.data.deleteParameterRowMeta.size()];
        int deleteIndex = 0;
        for (int i = 0; i < this.meta.getKeyStream().length; ++i) {
            if (this.data.keynrs[i] >= 0) {
                deleteRow[deleteIndex] = row[this.data.keynrs[i]];
                ++deleteIndex;
            }
            if (this.data.keynrs2[i] < 0) continue;
            deleteRow[deleteIndex] = row[this.data.keynrs2[i]];
            ++deleteIndex;
        }
        this.data.db.setValues(this.data.deleteParameterRowMeta, deleteRow, this.data.prepStatementDelete);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"Delete.Log.SetValuesForDelete", (String[])new String[]{this.data.deleteParameterRowMeta.getString(deleteRow), rowMeta.getString(row)}));
        }
        this.data.db.insertRow(this.data.prepStatementDelete);
        this.incrementLinesUpdated();
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block10: {
            this.meta = (DeleteMeta)smi;
            this.data = (DeleteData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                this.data.schemaTable = this.meta.getDatabaseMeta().getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Delete.Log.CheckingRow", (String[])new String[0]) + this.getInputRowMeta().getString(r));
                }
                this.data.keynrs = new int[this.meta.getKeyStream().length];
                this.data.keynrs2 = new int[this.meta.getKeyStream().length];
                for (int i = 0; i < this.meta.getKeyStream().length; ++i) {
                    this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getKeyStream()[i]);
                    if (this.data.keynrs[i] < 0 && !"IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) && !"IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"Delete.Exception.FieldRequired", (String[])new String[]{this.meta.getKeyStream()[i]}));
                    }
                    int n = this.data.keynrs2[i] = this.meta.getKeyStream2().length == 0 ? -1 : this.getInputRowMeta().indexOfValue(this.meta.getKeyStream2()[i]);
                    if (this.data.keynrs2[i] < 0 && "BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"Delete.Exception.FieldRequired", (String[])new String[]{this.meta.getKeyStream2()[i]}));
                    }
                    if (!this.log.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"Delete.Log.FieldInfo", (String[])new String[]{this.meta.getKeyStream()[i]}) + this.data.keynrs[i]);
                }
                this.prepareDelete(this.getInputRowMeta());
            }
            try {
                this.deleteValues(this.getInputRowMeta(), r);
                this.putRow(this.data.outputRowMeta, r);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"Delete.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"Delete.Log.ErrorInStep", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block10;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "DEL001");
            }
        }
        return true;
    }

    public void prepareDelete(RowMetaInterface rowMeta) throws KettleDatabaseException {
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        this.data.deleteParameterRowMeta = new RowMeta();
        String sql = "DELETE FROM " + this.data.schemaTable + Const.CR;
        sql = sql + "WHERE ";
        for (int i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                this.data.deleteParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                this.data.deleteParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream2()[i]));
                continue;
            }
            if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ";
                continue;
            }
            sql = sql + " " + this.meta.getKeyCondition()[i] + " ? ";
            this.data.deleteParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
        }
        try {
            if (this.log.isDetailed()) {
                this.logDetailed("Setting delete preparedStatement to [" + sql + "]");
            }
            this.data.prepStatementDelete = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare statement for SQL statement [" + sql + "]", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DeleteMeta)smi;
        this.data = (DeleteData)sdi;
        if (super.init(smi, sdi)) {
            if (this.meta.getDatabaseMeta() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"Delete.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                return false;
            }
            this.data.db = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
            this.data.db.shareVariablesWith((VariableSpace)this);
            try {
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Delete.Log.ConnectedToDB", (String[])new String[0]));
                }
                this.data.db.setCommit(this.meta.getCommitSize(this));
                return true;
            }
            catch (KettleException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"Delete.Log.ErrorOccurred", (String[])new String[0]) + ke.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DeleteMeta)smi;
        this.data = (DeleteData)sdi;
        if (this.data.db != null) {
            try {
                if (!this.data.db.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        this.data.db.commit();
                    } else {
                        this.data.db.rollback();
                    }
                }
                this.data.db.closeUpdate();
            }
            catch (KettleDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"Delete.Log.UnableToCommitUpdateConnection", (String[])new String[0]) + this.data.db + "] :" + e.toString());
                this.setErrors(1L);
            }
            finally {
                this.data.db.disconnect();
            }
        }
        super.dispose(smi, sdi);
    }
}

