/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.errorhandling;

import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandler;

public class CompositeFileErrorHandler
implements FileErrorHandler {
    private List<FileErrorHandler> handlers;

    public CompositeFileErrorHandler(List<FileErrorHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void handleFile(FileObject file) throws KettleException {
        for (FileErrorHandler handler : this.handlers) {
            handler.handleFile(file);
        }
    }

    @Override
    public void handleLineError(long lineNr, String filePart) throws KettleException {
        for (FileErrorHandler handler : this.handlers) {
            handler.handleLineError(lineNr, filePart);
        }
    }

    @Override
    public void close() throws KettleException {
        for (FileErrorHandler handler : this.handlers) {
            handler.close();
        }
    }

    @Override
    public void handleNonExistantFile(FileObject file) throws KettleException {
        for (FileErrorHandler handler : this.handlers) {
            handler.handleNonExistantFile(file);
        }
    }

    @Override
    public void handleNonAccessibleFile(FileObject file) throws KettleException {
        for (FileErrorHandler handler : this.handlers) {
            handler.handleNonAccessibleFile(file);
        }
    }
}

