/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.ael.websocket.handler;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.engine.api.remote.Message;
import org.pentaho.di.engine.api.remote.StopMessage;
import org.pentaho.di.trans.ael.websocket.TransWebSocketEngineAdapter;
import org.pentaho.di.trans.ael.websocket.exception.MessageEventHandlerExecutionException;
import org.pentaho.di.trans.ael.websocket.handler.MessageEventHandler;

public class StopMessageEventHandler
implements MessageEventHandler {
    private static final String TRANSFORMATION_STOP = "TRANSFORMATION_STOP_TRANS_WEBSOCK";
    private transient LogChannelInterface log;
    private transient CountDownLatch transFinishedSignal;
    private transient TransWebSocketEngineAdapter transAdapter;
    private AtomicInteger errors;
    private boolean cancelling;

    public StopMessageEventHandler(LogChannelInterface log, AtomicInteger errors, CountDownLatch transFinishedSignal, TransWebSocketEngineAdapter transAdapter, boolean cancelling) {
        this.log = log;
        this.errors = errors;
        this.transFinishedSignal = transFinishedSignal;
        this.transAdapter = transAdapter;
        this.cancelling = cancelling;
    }

    @Override
    public void execute(Message message) throws MessageEventHandlerExecutionException {
        StopMessage stopMessage = (StopMessage)message;
        if (stopMessage.operationFailed()) {
            this.log.logError("Could not verify termination status: " + stopMessage.getReasonPhrase());
            this.log.logError("Please check with cluster administrator.");
        } else if (stopMessage.sessionWasKilled()) {
            this.log.logError("Finalizing execution: " + stopMessage.getReasonPhrase());
            this.errors.incrementAndGet();
        } else {
            this.log.logBasic("Finalizing execution: " + stopMessage.getReasonPhrase());
        }
        if (!this.cancelling) {
            this.transAdapter.finishProcess(false);
        }
        try {
            this.transAdapter.getDaemonEndpoint().close(stopMessage.getReasonPhrase());
        }
        catch (KettleException e) {
            this.log.logError("Error finalizing", (Throwable)e);
        }
        this.transAdapter.closeSessionMonitor();
        this.transFinishedSignal.countDown();
    }

    @Override
    public String getIdentifier() {
        return TRANSFORMATION_STOP;
    }
}

