/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.ael.websocket;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.di.engine.api.model.ModelType;
import org.pentaho.di.engine.api.remote.Message;
import org.pentaho.di.engine.api.remote.RemoteSource;
import org.pentaho.di.engine.api.remote.StopMessage;
import org.pentaho.di.trans.ael.websocket.exception.HandlerRegistrationException;
import org.pentaho.di.trans.ael.websocket.exception.MessageEventFireEventException;
import org.pentaho.di.trans.ael.websocket.handler.MessageEventHandler;

public class MessageEventService {
    private Map<Message, List<MessageEventHandler>> registeredHandlers = new HashMap<Message, List<MessageEventHandler>>();

    public void fireEvent(Message event) throws MessageEventFireEventException {
        if (event != null) {
            List<MessageEventHandler> handlers;
            if (this.containsHandlerFor(event) && (handlers = this.getHandlersFor(event)) != null && handlers.size() > 0) {
                MessageEventFireEventException messageEventFireEventException = null;
                for (MessageEventHandler handler : handlers) {
                    try {
                        handler.execute(event);
                    }
                    catch (Exception e) {
                        if (messageEventFireEventException == null) {
                            messageEventFireEventException = new MessageEventFireEventException("Unable to execute some handler.");
                        }
                        messageEventFireEventException.addHandlerException(e);
                    }
                }
                if (messageEventFireEventException != null) {
                    throw messageEventFireEventException;
                }
            }
        } else {
            throw new MessageEventFireEventException("Unable to fire a null event");
        }
    }

    public final void addHandler(Message eventType, MessageEventHandler handler) throws HandlerRegistrationException {
        if (handler == null || eventType == null) {
            throw new HandlerRegistrationException("One of the parameters is null :  eventType: " + eventType + " handler:" + handler);
        }
        this.addHandlerFor(eventType, handler);
    }

    public final boolean hasHandlers(Message eventType) {
        return this.containsHandlerFor(eventType);
    }

    private boolean containsHandlerFor(Message eventType) {
        if (eventType == null || this.registeredHandlers.isEmpty()) {
            return false;
        }
        MessageComparator msgComparator = new MessageComparator();
        for (Message e : this.registeredHandlers.keySet()) {
            if (msgComparator.compare(e, eventType) != 0) continue;
            return true;
        }
        return false;
    }

    public List<MessageEventHandler> getHandlersFor(Message eventType) {
        List<MessageEventHandler> toRet = null;
        if (eventType == null || this.registeredHandlers.isEmpty()) {
            return toRet;
        }
        MessageComparator msgComparator = new MessageComparator();
        for (Map.Entry<Message, List<MessageEventHandler>> entry : this.registeredHandlers.entrySet()) {
            if (msgComparator.compare(entry.getKey(), eventType) != 0) continue;
            toRet = entry.getValue();
        }
        return toRet;
    }

    private void addHandlerFor(Message eventType, MessageEventHandler handler) throws HandlerRegistrationException {
        if (this.containsHandlerFor(eventType)) {
            List<MessageEventHandler> handlers = this.getHandlersFor(eventType);
            for (MessageEventHandler tmpHandler : handlers) {
                if (!tmpHandler.getIdentifier().equals(handler.getIdentifier())) continue;
                throw new HandlerRegistrationException("The handler with identifier " + tmpHandler.getIdentifier() + " is already registered for the event " + eventType);
            }
            handlers.add(handler);
        } else {
            ArrayList<MessageEventHandler> newHandlerList = new ArrayList<MessageEventHandler>(10);
            newHandlerList.add(handler);
            this.registeredHandlers.put(eventType, newHandlerList);
        }
    }

    private class MessageComparator
    implements Comparator<Message> {
        private MessageComparator() {
        }

        @Override
        public int compare(Message o1, Message o2) {
            if (o1 == null || o2 == null) {
                return -1;
            }
            if (o1.getClass().getName().equals(o2.getClass().getName())) {
                RemoteSource remoteSource;
                RemoteSource keyRemoteSource;
                if (o2 instanceof StopMessage) {
                    return 0;
                }
                if (o2 instanceof PDIEvent && this.sameType(keyRemoteSource = (RemoteSource)((PDIEvent)o1).getSource(), remoteSource = (RemoteSource)((PDIEvent)o2).getSource()) && (this.sameId(keyRemoteSource, remoteSource) || this.isTrans(keyRemoteSource))) {
                    return 0;
                }
            }
            return -1;
        }

        private boolean isTrans(RemoteSource source1) {
            return source1.getModelType() == ModelType.TRANSFORMATION;
        }

        private boolean sameId(RemoteSource source1, RemoteSource source2) {
            return Objects.isNull(source1.getId()) && Objects.isNull(source2.getId()) || Objects.nonNull(source1.getId()) && source1.getId().equals(source2.getId());
        }

        private boolean sameType(RemoteSource source1, RemoteSource source2) {
            return source1.getModelType() == source2.getModelType();
        }
    }
}

