/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.net.URI;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.ael.websocket.TransWebSocketEngineAdapter;

public class TransSupplier
implements Supplier<Trans> {
    private static final Class<?> PKG = TransSupplier.class;
    private static final String MSG_KETTLE_ENGINE = "TransSupplier.SelectedEngine.Kettle";
    private static final String MSG_SPARK_ENGINE = "TransSupplier.SelectedEngine.Spark";
    private final TransMeta transMeta;
    private final LogChannelInterface log;
    private final Supplier<Trans> fallbackSupplier;

    public TransSupplier(TransMeta transMeta, LogChannelInterface log, Supplier<Trans> fallbackSupplier) {
        this.transMeta = transMeta;
        this.log = log;
        this.fallbackSupplier = fallbackSupplier;
    }

    @Override
    public Trans get() {
        if (Utils.isEmpty((CharSequence)this.transMeta.getVariable("engine"))) {
            this.log.logBasic(BaseMessages.getString(PKG, (String)MSG_KETTLE_ENGINE, (String[])new String[0]));
            return this.fallbackSupplier.get();
        }
        Variables variables = new Variables();
        variables.initializeVariablesFrom(null);
        String protocol = this.transMeta.environmentSubstitute(this.transMeta.getVariable("engine.scheme"));
        String url = this.transMeta.environmentSubstitute(this.transMeta.getVariable("engine.url"));
        URI uri = URI.create(protocol + url);
        boolean ssl = "https".equalsIgnoreCase(protocol) || "wss".equalsIgnoreCase(protocol);
        this.log.logBasic(BaseMessages.getString(PKG, (String)MSG_SPARK_ENGINE, (String[])new String[]{protocol, url}));
        return new TransWebSocketEngineAdapter(this.transMeta, uri.getHost(), uri.getPort(), ssl);
    }

    private Predicate<PluginInterface> useThisEngine() {
        return plugin -> Arrays.stream(plugin.getIds()).filter(id -> id.equals(this.transMeta.getVariable("engine"))).findAny().isPresent();
    }

    private Object loadPlugin(PluginInterface plugin) {
        try {
            return PluginRegistry.getInstance().loadClass(plugin);
        }
        catch (KettlePluginException e) {
            throw new RuntimeException(e);
        }
    }
}

