/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.pentaho.di.base.MetaFileLoaderImpl;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.util.serialization.BaseSerializingMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.HasRepositoryDirectories;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingIODefinition;
import org.pentaho.metastore.api.IMetaStore;

public abstract class StepWithMappingMeta
extends BaseSerializingMeta
implements HasRepositoryDirectories,
StepMetaInterface {
    private static Class<?> PKG = StepWithMappingMeta.class;
    protected ObjectLocationSpecificationMethod specificationMethod;
    protected String transName;
    protected String fileName;
    protected String directoryPath;
    protected ObjectId transObjectId;

    public static TransMeta loadMappingMeta(StepWithMappingMeta mappingMeta, Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        return StepWithMappingMeta.loadMappingMeta(mappingMeta, rep, metaStore, space, true);
    }

    public static TransMeta loadMappingMeta(StepWithMappingMeta executorMeta, Repository rep, IMetaStore metaStore, VariableSpace space, boolean share) throws KettleException {
        MetaFileLoaderImpl metaFileLoader = new MetaFileLoaderImpl(executorMeta, executorMeta.getSpecificationMethod());
        TransMeta mappingTransMeta = (TransMeta)metaFileLoader.getMetaForStep(rep, metaStore, space);
        if (share) {
            StepWithMappingMeta.replaceVariableValues(mappingTransMeta, space);
            StepWithMappingMeta.addMissingVariables(mappingTransMeta, space);
        }
        mappingTransMeta.setRepository(rep);
        mappingTransMeta.setMetaStore(metaStore);
        mappingTransMeta.setFilename(mappingTransMeta.getFilename());
        return mappingTransMeta;
    }

    public static void activateParams(VariableSpace childVariableSpace, NamedParams childNamedParams, VariableSpace parent, String[] listParameters, String[] mappingVariables, String[] inputFields) {
        StepWithMappingMeta.activateParams(childVariableSpace, childNamedParams, parent, listParameters, mappingVariables, inputFields, true);
    }

    public static void activateParams(VariableSpace childVariableSpace, NamedParams childNamedParams, VariableSpace parent, String[] listParameters, String[] mappingVariables, String[] inputFields, boolean isPassingAllParameters) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        HashSet<String> subTransParameters = new HashSet<String>(Arrays.asList(listParameters));
        if (mappingVariables != null) {
            for (int i = 0; i < mappingVariables.length; ++i) {
                parameters.put(mappingVariables[i], parent.environmentSubstitute(inputFields[i]));
                if (Utils.isEmpty((CharSequence)Const.trim((String)parent.environmentSubstitute(inputFields[i])))) continue;
                parent.setVariable(mappingVariables[i], parent.environmentSubstitute(inputFields[i]));
            }
        }
        for (String variableName : parent.listVariables()) {
            if (parameters.containsKey(variableName)) {
                parameters.put(variableName, parent.getVariable(variableName));
                continue;
            }
            if (!ArrayUtils.contains((Object[])listParameters, (Object)variableName) || !isPassingAllParameters) continue;
            parameters.put(variableName, parent.getVariable(variableName));
        }
        for (Map.Entry entry : parameters.entrySet()) {
            String key = (String)entry.getKey();
            String value = Const.NVL((String)((String)entry.getValue()), (String)"");
            if (subTransParameters.contains(key)) {
                try {
                    childNamedParams.setParameterValue(key, Const.NVL((String)((String)entry.getValue()), (String)""));
                }
                catch (UnknownParamException unknownParamException) {}
                continue;
            }
            try {
                childNamedParams.addParameterDefinition(key, "", "");
                childNamedParams.setParameterValue(key, value);
            }
            catch (DuplicateParamException duplicateParamException) {
            }
            catch (UnknownParamException unknownParamException) {
                // empty catch block
            }
            childVariableSpace.setVariable(key, value);
        }
        childNamedParams.activateParameters();
    }

    public ObjectLocationSpecificationMethod getSpecificationMethod() {
        return this.specificationMethod;
    }

    @Override
    public ObjectLocationSpecificationMethod[] getSpecificationMethods() {
        return new ObjectLocationSpecificationMethod[]{this.specificationMethod};
    }

    public void setSpecificationMethod(ObjectLocationSpecificationMethod specificationMethod) {
        this.specificationMethod = specificationMethod;
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    @Override
    public String[] getDirectories() {
        return new String[]{this.directoryPath};
    }

    @Override
    public void setDirectories(String[] directories) {
        this.directoryPath = directories[0];
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void replaceFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getTransName() {
        return this.transName;
    }

    public void setTransName(String transName) {
        this.transName = transName;
    }

    public ObjectId getTransObjectId() {
        return this.transObjectId;
    }

    public void setTransObjectId(ObjectId transObjectId) {
        this.transObjectId = transObjectId;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            TransMeta mappingTransMeta = StepWithMappingMeta.loadMappingMeta(this, repository, metaStore, space);
            String proposedNewFilename = mappingTransMeta.exportResources(mappingTransMeta, definitions, resourceNamingInterface, repository, metaStore);
            String newFilename = "${Internal.Entry.Current.Directory}/" + proposedNewFilename;
            mappingTransMeta.setFilename(newFilename);
            mappingTransMeta.setRepositoryDirectory((RepositoryDirectoryInterface)new RepositoryDirectory());
            this.replaceFileName(newFilename);
            this.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
            return proposedNewFilename;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"StepWithMappingMeta.Exception.UnableToLoadTrans", (String[])new String[]{this.fileName}));
        }
    }

    public static void addMissingVariables(VariableSpace fromSpace, VariableSpace toSpace) {
        String[] variableNames;
        if (toSpace == null) {
            return;
        }
        for (String variable : variableNames = toSpace.listVariables()) {
            if (fromSpace.getVariable(variable) != null) continue;
            fromSpace.setVariable(variable, toSpace.getVariable(variable));
        }
    }

    public static void replaceVariableValues(VariableSpace childTransMeta, VariableSpace replaceBy, String type) {
        String[] variableNames;
        if (replaceBy == null) {
            return;
        }
        for (String variableName : variableNames = replaceBy.listVariables()) {
            if (childTransMeta.getVariable(variableName) == null || StepWithMappingMeta.isInternalVariable(variableName, type)) continue;
            childTransMeta.setVariable(variableName, replaceBy.getVariable(variableName));
        }
    }

    public static void replaceVariableValues(VariableSpace childTransMeta, VariableSpace replaceBy) {
        StepWithMappingMeta.replaceVariableValues(childTransMeta, replaceBy, "");
    }

    private static boolean isInternalVariable(String variableName, String type) {
        return type.equals("Trans") ? StepWithMappingMeta.isTransInternalVariable(variableName) : (type.equals("Job") ? StepWithMappingMeta.isJobInternalVariable(variableName) : StepWithMappingMeta.isJobInternalVariable(variableName) || StepWithMappingMeta.isTransInternalVariable(variableName));
    }

    private static boolean isTransInternalVariable(String variableName) {
        return Arrays.asList(Const.INTERNAL_TRANS_VARIABLES).contains(variableName);
    }

    private static boolean isJobInternalVariable(String variableName) {
        return Arrays.asList(Const.INTERNAL_JOB_VARIABLES).contains(variableName);
    }

    public List<MappingIODefinition> getInputMappings() {
        return Collections.emptyList();
    }

    public List<MappingIODefinition> getOutputMappings() {
        return Collections.emptyList();
    }
}

