/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;

public class DatabaseImpact {
    private static Class<?> PKG = Trans.class;
    public static final int TYPE_IMPACT_NONE = 0;
    public static final int TYPE_IMPACT_READ = 1;
    public static final int TYPE_IMPACT_WRITE = 2;
    public static final int TYPE_IMPACT_READ_WRITE = 3;
    public static final int TYPE_IMPACT_TRUNCATE = 4;
    public static final int TYPE_IMPACT_DELETE = 5;
    public static final int TYPE_IMPACT_UPDATE = 6;
    public static final String[] typeDesc = new String[]{BaseMessages.getString(PKG, (String)"DatabaseImpact.TypeDesc.Label.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseImpact.TypeDesc.Label.Read", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseImpact.TypeDesc.Label.Write", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseImpact.TypeDesc.Label.ReadOrWrite", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseImpact.TypeDesc.Label.Truncate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseImpact.TypeDesc.Label.Delete", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseImpact.TypeDesc.Label.Update", (String[])new String[0])};
    private String transname;
    private String stepname;
    private String dbname;
    private String table;
    private String field;
    private String valuename;
    private String valueorigin;
    private String sql;
    private String remark;
    private int type;

    public DatabaseImpact(int type, String transname, String stepname, String dbname, String table, String field, String valuename, String valueorigin, String sql, String remark) {
        this.type = type;
        this.transname = transname;
        this.stepname = stepname;
        this.dbname = dbname;
        this.table = table;
        this.field = field;
        this.valuename = valuename;
        this.valueorigin = valueorigin;
        this.sql = sql;
        this.remark = remark;
    }

    public String getTransformationName() {
        return this.transname;
    }

    public String getStepName() {
        return this.stepname;
    }

    public String getValueOrigin() {
        return this.valueorigin;
    }

    public String getDatabaseName() {
        return this.dbname;
    }

    public String getTable() {
        return this.table;
    }

    public String getField() {
        return this.field;
    }

    public String getValue() {
        return this.valuename;
    }

    public String getSQL() {
        return this.sql;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getTypeDesc() {
        return typeDesc[this.type];
    }

    public static final int getTypeDesc(String typedesc) {
        for (int i = 1; i < typeDesc.length; ++i) {
            if (!typeDesc[i].equalsIgnoreCase(typedesc)) continue;
            return i;
        }
        return 0;
    }

    public int getType() {
        return this.type;
    }

    public RowMetaAndData getRow() {
        RowMetaAndData r = new RowMetaAndData();
        r.addValue((ValueMetaInterface)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Type", (String[])new String[0])), (Object)this.getTypeDesc());
        r.addValue((ValueMetaInterface)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Transformation", (String[])new String[0])), (Object)this.getTransformationName());
        r.addValue((ValueMetaInterface)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Step", (String[])new String[0])), (Object)this.getStepName());
        r.addValue((ValueMetaInterface)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Database", (String[])new String[0])), (Object)this.getDatabaseName());
        r.addValue((ValueMetaInterface)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Table", (String[])new String[0])), (Object)this.getTable());
        r.addValue((ValueMetaInterface)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Field", (String[])new String[0])), (Object)this.getField());
        r.addValue((ValueMetaInterface)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Value", (String[])new String[0])), (Object)this.getValue());
        r.addValue((ValueMetaInterface)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.ValueOrigin", (String[])new String[0])), (Object)this.getValueOrigin());
        r.addValue((ValueMetaInterface)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.SQL", (String[])new String[0])), (Object)this.getSQL());
        r.addValue((ValueMetaInterface)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Remarks", (String[])new String[0])), (Object)this.getRemark());
        return r;
    }
}

