/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.io.ByteArrayInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleSecurityException;
import org.pentaho.di.core.logging.LoggingBuffer;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;

public class RepositoryConnectionUtils {
    private static final Log logger = LogFactory.getLog(RepositoryConnectionUtils.class);
    private static final String SINGLE_DI_SERVER_INSTANCE = "singleDiServerInstance";
    private static Class<?> PKG = RepositoryConnectionUtils.class;

    public static Repository connectToRepository(String repositoryName, boolean isSingleDiServerInstance, String userName, String fullyQualifiedServerUrl, LoggingBuffer logBuffer) throws KettleSecurityException, KettleException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Creating Meta-repository");
        }
        RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" Populating Meta repository");
        }
        try {
            if (isSingleDiServerInstance) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"singleDiServerInstance=true, loading default repository");
                }
                String repositoriesXml = RepositoryConnectionUtils.getEmbeddedDefaultRepositoryXml(fullyQualifiedServerUrl);
                ByteArrayInputStream sbis = new ByteArrayInputStream(repositoriesXml.getBytes("UTF-8"));
                repositoriesMeta.readDataFromInputStream(sbis);
            } else {
                repositoriesMeta.readData();
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString((String)"RepositoryConnectionUtils.ERROR_0018_META_REPOSITORY_NOT_POPULATED"), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" Finding repository metadata");
        }
        RepositoryMeta repositoryMeta = null;
        try {
            repositoryMeta = isSingleDiServerInstance ? repositoriesMeta.findRepository(SINGLE_DI_SERVER_INSTANCE) : repositoriesMeta.findRepository(repositoryName);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RepositoryConnectionUtils.ERROR_0004_REPOSITORY_NOT_FOUND", (String[])new String[]{repositoryName}), (Throwable)e);
        }
        if (repositoryMeta == null) {
            if (logger.isDebugEnabled() && logBuffer != null) {
                logger.debug((Object)logBuffer.getBuffer().toString());
            }
            throw new KettleException(BaseMessages.getString(PKG, (String)"RepositoryConnectionUtils.ERROR_0004_REPOSITORY_NOT_FOUND", (String[])new String[]{repositoryName}));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" Getting repository instance ");
        }
        Repository repository = null;
        try {
            repository = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, repositoryMeta.getId(), Repository.class);
            repository.init(repositoryMeta);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString((String)"RepositoryConnectionUtils.ERROR_0016_COULD_NOT_GET_REPOSITORY_INSTANCE"), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Connecting to repository ");
        }
        repository.connect(userName, "ignore");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" Connected to repository ");
        }
        return repository;
    }

    private static String getEmbeddedDefaultRepositoryXml(String fullyQualifiedServerUrl) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><repositories><repository><id>PentahoEnterpriseRepository</id><name>singleDiServerInstance</name><description>singleDiServerInstance</description><repository_location_url>" + fullyQualifiedServerUrl + "</repository_location_url><version_comment_mandatory>N</version_comment_mandatory></repository></repositories>";
    }
}

