/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.sql;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntrySQL
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    public static final String USE_VARIABLE_SUBSTITUTION_TAG = "useVariableSubstitution";
    public static final String SQLFROMFILE_TAG = "sqlfromfile";
    public static final String SQLFILENAME_TAG = "sqlfilename";
    public static final String SEND_ONE_STATEMENT_TAG = "sendOneStatement";
    public static final String CONNECTION_TAG = "connection";
    public static final String INDENT = "      ";
    private static final Class<?> PKG = JobEntrySQL.class;
    public static final String SQL_TAG = "sql";
    public static final String ID_DATABASE = "id_database";
    private String sql = null;
    private DatabaseMeta databaseMeta = null;
    private boolean useVariableSubstitution = false;
    private boolean sqlFromFile = false;
    private String sqlFilename;
    private boolean sendOneStatement = false;

    public JobEntrySQL(String n) {
        super(n, "");
    }

    public JobEntrySQL() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntrySQL je = (JobEntrySQL)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(200);
        retval.append(super.getXML());
        retval.append(INDENT).append(XMLHandler.addTagValue((String)SQL_TAG, (String)this.sql));
        retval.append(INDENT).append(XMLHandler.addTagValue((String)USE_VARIABLE_SUBSTITUTION_TAG, (String)(this.useVariableSubstitution ? "T" : "F")));
        retval.append(INDENT).append(XMLHandler.addTagValue((String)SQLFROMFILE_TAG, (String)(this.sqlFromFile ? "T" : "F")));
        retval.append(INDENT).append(XMLHandler.addTagValue((String)SQLFILENAME_TAG, (String)this.sqlFilename));
        retval.append(INDENT).append(XMLHandler.addTagValue((String)SEND_ONE_STATEMENT_TAG, (String)(this.sendOneStatement ? "T" : "F")));
        retval.append(INDENT).append(XMLHandler.addTagValue((String)CONNECTION_TAG, this.databaseMeta == null ? null : this.databaseMeta.getName()));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.sql = XMLHandler.getTagValue((Node)entrynode, (String)SQL_TAG);
            String dbname = XMLHandler.getTagValue((Node)entrynode, (String)CONNECTION_TAG);
            String sSubs = XMLHandler.getTagValue((Node)entrynode, (String)USE_VARIABLE_SUBSTITUTION_TAG);
            if (sSubs != null && sSubs.equalsIgnoreCase("T")) {
                this.useVariableSubstitution = true;
            }
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)dbname);
            String ssql = XMLHandler.getTagValue((Node)entrynode, (String)SQLFROMFILE_TAG);
            if (ssql != null && ssql.equalsIgnoreCase("T")) {
                this.sqlFromFile = true;
            }
            this.sqlFilename = XMLHandler.getTagValue((Node)entrynode, (String)SQLFILENAME_TAG);
            String sOneStatement = XMLHandler.getTagValue((Node)entrynode, (String)SEND_ONE_STATEMENT_TAG);
            if (sOneStatement != null && sOneStatement.equalsIgnoreCase("T")) {
                this.sendOneStatement = true;
            }
        }
        catch (KettleException e) {
            throw new KettleXMLException("Unable to load job entry of type 'sql' from XML node", (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId idJobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            String ssendOneStatement;
            String ssql;
            this.sql = rep.getJobEntryAttributeString(idJobentry, SQL_TAG);
            String sSubs = rep.getJobEntryAttributeString(idJobentry, USE_VARIABLE_SUBSTITUTION_TAG);
            if (sSubs != null && sSubs.equalsIgnoreCase("T")) {
                this.useVariableSubstitution = true;
            }
            if ((ssql = rep.getJobEntryAttributeString(idJobentry, SQLFROMFILE_TAG)) != null && ssql.equalsIgnoreCase("T")) {
                this.sqlFromFile = true;
            }
            if ((ssendOneStatement = rep.getJobEntryAttributeString(idJobentry, SEND_ONE_STATEMENT_TAG)) != null && ssendOneStatement.equalsIgnoreCase("T")) {
                this.sendOneStatement = true;
            }
            this.sqlFilename = rep.getJobEntryAttributeString(idJobentry, SQLFILENAME_TAG);
            this.databaseMeta = rep.loadDatabaseMetaFromJobEntryAttribute(idJobentry, CONNECTION_TAG, ID_DATABASE, databases);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'sql' from the repository with idJobentry=" + idJobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId idJob) throws KettleException {
        try {
            rep.saveDatabaseMetaJobEntryAttribute(idJob, this.getObjectId(), CONNECTION_TAG, ID_DATABASE, this.databaseMeta);
            rep.saveJobEntryAttribute(idJob, this.getObjectId(), SQL_TAG, this.sql);
            rep.saveJobEntryAttribute(idJob, this.getObjectId(), USE_VARIABLE_SUBSTITUTION_TAG, this.useVariableSubstitution ? "T" : "F");
            rep.saveJobEntryAttribute(idJob, this.getObjectId(), SQLFROMFILE_TAG, this.sqlFromFile ? "T" : "F");
            rep.saveJobEntryAttribute(idJob, this.getObjectId(), SQLFILENAME_TAG, this.sqlFilename);
            rep.saveJobEntryAttribute(idJob, this.getObjectId(), SEND_ONE_STATEMENT_TAG, this.sendOneStatement ? "T" : "F");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'sql' to the repository for idJob=" + idJob, (Throwable)dbe);
        }
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    public String getSQL() {
        return this.sql;
    }

    public String getSQLFilename() {
        return this.sqlFilename;
    }

    public void setSQLFilename(String sqlFilename) {
        this.sqlFilename = sqlFilename;
    }

    public boolean getUseVariableSubstitution() {
        return this.useVariableSubstitution;
    }

    public void setUseVariableSubstitution(boolean subs) {
        this.useVariableSubstitution = subs;
    }

    public void setSQLFromFile(boolean sqlFromFileIn) {
        this.sqlFromFile = sqlFromFileIn;
    }

    public boolean getSQLFromFile() {
        return this.sqlFromFile;
    }

    public boolean isSendOneStatement() {
        return this.sendOneStatement;
    }

    public void setSendOneStatement(boolean sendOneStatementIn) {
        this.sendOneStatement = sendOneStatementIn;
    }

    public void setDatabase(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public DatabaseMeta getDatabase() {
        return this.databaseMeta;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result result, int nr) {
        if (this.databaseMeta != null) {
            try (Database db = new Database((LoggingObjectInterface)this, this.databaseMeta);){
                String theSql;
                String string = theSql = this.sqlFromFile ? this.buildSqlFromFile() : this.sql;
                if (Utils.isEmpty((CharSequence)theSql)) {
                    Result result2 = result;
                    return result2;
                }
                db.shareVariablesWith((VariableSpace)this);
                db.connect(this.parentJob.getTransactionId(), null);
                if (this.useVariableSubstitution) {
                    theSql = this.environmentSubstitute(theSql);
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobSQL.Log.SQlStatement", (String[])new String[]{theSql}));
                }
                if (this.sendOneStatement) {
                    db.execStatement(theSql);
                } else {
                    db.execStatements(theSql);
                }
            }
            catch (KettleDatabaseException je) {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(PKG, (String)"JobSQL.ErrorRunJobEntry", (String[])new String[]{je.getMessage()}));
            }
        } else {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"JobSQL.NoDatabaseConnection", (String[])new String[0]));
        }
        result.setResult(result.getNrErrors() == 0L);
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String buildSqlFromFile() throws KettleDatabaseException {
        if (this.sqlFilename == null) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"JobSQL.NoSQLFileSpecified", (String[])new String[0]));
        }
        String realFilename = this.environmentSubstitute(this.sqlFilename);
        try (FileObject sqlFile = KettleVFS.getFileObject((String)realFilename, (VariableSpace)this);){
            String string;
            block19: {
                if (!sqlFile.exists()) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobSQL.SQLFileNotExist", (String[])new String[]{realFilename}));
                    throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"JobSQL.SQLFileNotExist", (String[])new String[]{realFilename}));
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobSQL.SQLFileExists", (String[])new String[]{realFilename}));
                }
                InputStream inputStream = KettleVFS.getInputStream((FileObject)sqlFile);
                try {
                    String sLine;
                    InputStreamReader bufferedStream = new InputStreamReader(new BufferedInputStream(inputStream, 500));
                    BufferedReader buff = new BufferedReader(bufferedStream);
                    StringBuilder sqlBuilder = new StringBuilder(Const.CR);
                    while ((sLine = buff.readLine()) != null) {
                        if (Utils.isEmpty((CharSequence)sLine)) {
                            sqlBuilder.append(Const.CR);
                            continue;
                        }
                        sqlBuilder.append(Const.CR).append(sLine);
                    }
                    string = sqlBuilder.toString();
                    if (inputStream == null) break block19;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return string;
        }
        catch (Exception e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"JobSQL.ErrorRunningSQLfromFile", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.databaseMeta};
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.databaseMeta != null) {
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(this.databaseMeta.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.databaseMeta.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "SQL", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

