/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ftpput;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFileFactory;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.ftp.MVSFileParser;
import org.pentaho.di.job.entries.ftpput.PDIFTPClient;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryFTPPUT
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryFTPPUT.class;
    public static final int FTP_DEFAULT_PORT = 21;
    private String serverName = null;
    private String serverPort = "21";
    private String userName;
    private String password;
    private String remoteDirectory = null;
    private String localDirectory = null;
    private String wildcard;
    private boolean binaryMode;
    private int timeout;
    private boolean remove;
    private boolean onlyPuttingNewFiles;
    private boolean activeConnection;
    private String controlEncoding;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String socksProxyHost;
    private String socksProxyPort = "1080";
    private String socksProxyUsername;
    private String socksProxyPassword;
    private static final String LEGACY_CONTROL_ENCODING = "US-ASCII";
    private static final String DEFAULT_CONTROL_ENCODING = "ISO-8859-1";

    public JobEntryFTPPUT(String n) {
        super(n, "");
        this.setControlEncoding(DEFAULT_CONTROL_ENCODING);
    }

    public JobEntryFTPPUT() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryFTPPUT je = (JobEntryFTPPUT)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(450);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"serverport", (String)this.serverPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remoteDirectory", (String)this.remoteDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"localDirectory", (String)this.localDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"binary", (boolean)this.binaryMode));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (int)this.timeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remove", (boolean)this.remove));
        retval.append("      ").append(XMLHandler.addTagValue((String)"only_new", (boolean)this.onlyPuttingNewFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"active", (boolean)this.activeConnection));
        retval.append("      ").append(XMLHandler.addTagValue((String)"control_encoding", (String)this.controlEncoding));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_host", (String)this.proxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_username", (String)this.proxyUsername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"socksproxy_host", (String)this.socksProxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"socksproxy_port", (String)this.socksProxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"socksproxy_username", (String)this.socksProxyUsername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"socksproxy_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.socksProxyPassword)));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.serverPort = XMLHandler.getTagValue((Node)entrynode, (String)"serverport");
            this.userName = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.remoteDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"remoteDirectory");
            this.localDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"localDirectory");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.binaryMode = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"binary"));
            this.timeout = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"timeout"), (int)10000);
            this.remove = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"remove"));
            this.onlyPuttingNewFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"only_new"));
            this.activeConnection = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"active"));
            this.controlEncoding = XMLHandler.getTagValue((Node)entrynode, (String)"control_encoding");
            this.proxyHost = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_host");
            this.proxyPort = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_port");
            this.proxyUsername = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_username");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"proxy_password"));
            this.socksProxyHost = XMLHandler.getTagValue((Node)entrynode, (String)"socksproxy_host");
            this.socksProxyPort = XMLHandler.getTagValue((Node)entrynode, (String)"socksproxy_port");
            this.socksProxyUsername = XMLHandler.getTagValue((Node)entrynode, (String)"socksproxy_username");
            this.socksProxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"socksproxy_password"));
            if (this.controlEncoding == null) {
                this.controlEncoding = LEGACY_CONTROL_ENCODING;
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.UnableToLoadFromXml", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.serverPort = rep.getJobEntryAttributeString(id_jobentry, "serverport");
            this.userName = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.remoteDirectory = rep.getJobEntryAttributeString(id_jobentry, "remoteDirectory");
            this.localDirectory = rep.getJobEntryAttributeString(id_jobentry, "localDirectory");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.binaryMode = rep.getJobEntryAttributeBoolean(id_jobentry, "binary");
            this.timeout = (int)rep.getJobEntryAttributeInteger(id_jobentry, "timeout");
            this.remove = rep.getJobEntryAttributeBoolean(id_jobentry, "remove");
            this.onlyPuttingNewFiles = rep.getJobEntryAttributeBoolean(id_jobentry, "only_new");
            this.activeConnection = rep.getJobEntryAttributeBoolean(id_jobentry, "active");
            this.controlEncoding = rep.getJobEntryAttributeString(id_jobentry, "control_encoding");
            if (this.controlEncoding == null) {
                this.controlEncoding = LEGACY_CONTROL_ENCODING;
            }
            this.proxyHost = rep.getJobEntryAttributeString(id_jobentry, "proxy_host");
            this.proxyPort = rep.getJobEntryAttributeString(id_jobentry, "proxy_port");
            this.proxyUsername = rep.getJobEntryAttributeString(id_jobentry, "proxy_username");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "proxy_password"));
            this.socksProxyHost = rep.getJobEntryAttributeString(id_jobentry, "socksproxy_host");
            this.socksProxyPort = rep.getJobEntryAttributeString(id_jobentry, "socksproxy_port");
            this.socksProxyUsername = rep.getJobEntryAttributeString(id_jobentry, "socksproxy_username");
            this.socksProxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "socksproxy_password"));
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobFTPPUT.UnableToLoadFromRepo", (String[])new String[]{String.valueOf(id_jobentry)}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "serverport", this.serverPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "username", this.userName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "remoteDirectory", this.remoteDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "localDirectory", this.localDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "binary", this.binaryMode);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "timeout", this.timeout);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "remove", this.remove);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "only_new", this.onlyPuttingNewFiles);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "active", this.activeConnection);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "control_encoding", this.controlEncoding);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_host", this.proxyHost);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_port", this.proxyPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_username", this.proxyUsername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_password", Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "socksproxy_host", this.socksProxyHost);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "socksproxy_port", this.socksProxyPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "socksproxy_username", this.socksProxyUsername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "socksproxy_password", Encr.encryptPasswordIfNotUsingVariables((String)this.socksProxyPassword));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobFTPPUT.UnableToSaveToRepo", (String[])new String[]{String.valueOf(id_job)}), (Throwable)dbe);
        }
    }

    public boolean isBinaryMode() {
        return this.binaryMode;
    }

    public void setBinaryMode(boolean binaryMode) {
        this.binaryMode = binaryMode;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isOnlyPuttingNewFiles() {
        return this.onlyPuttingNewFiles;
    }

    public void setOnlyPuttingNewFiles(boolean onlyPuttingNewFiles) {
        this.onlyPuttingNewFiles = onlyPuttingNewFiles;
    }

    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setControlEncoding(String encoding) {
        this.controlEncoding = encoding;
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public void setRemoteDirectory(String directory) {
        this.remoteDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public void setLocalDirectory(String directory) {
        this.localDirectory = directory;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public boolean isActiveConnection() {
        return this.activeConnection;
    }

    public void setActiveConnection(boolean activeConnection) {
        this.activeConnection = activeConnection;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setSocksProxyHost(String socksProxyHost) {
        this.socksProxyHost = socksProxyHost;
    }

    public void setSocksProxyPort(String socksProxyPort) {
        this.socksProxyPort = socksProxyPort;
    }

    public void setSocksProxyUsername(String socksProxyUsername) {
        this.socksProxyUsername = socksProxyUsername;
    }

    public void setSocksProxyPassword(String socksProxyPassword) {
        this.socksProxyPassword = socksProxyPassword;
    }

    public String getSocksProxyHost() {
        return this.socksProxyHost;
    }

    public String getSocksProxyPort() {
        return this.socksProxyPort;
    }

    public String getSocksProxyUsername() {
        return this.socksProxyUsername;
    }

    public String getSocksProxyPassword() {
        return this.socksProxyPassword;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        FTPClient ftpclient;
        Result result;
        block33: {
            result = previousResult;
            result.setResult(false);
            long filesput = 0L;
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.Starting", (String[])new String[0]));
            }
            ftpclient = null;
            try {
                String realWildcard;
                List<String> files;
                File localFiles;
                File[] children;
                String realLocalDirectory;
                ftpclient = this.createAndSetUpFtpClient();
                String realUsername = this.environmentSubstitute(this.userName);
                String realPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.password));
                ftpclient.connect();
                ftpclient.login(realUsername, realPassword);
                if (this.binaryMode) {
                    ftpclient.setType(FTPTransferType.BINARY);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.BinaryMode", (String[])new String[0]));
                    }
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.Logged", (String[])new String[]{realUsername}));
                }
                this.hookInOtherParsers(ftpclient);
                String realRemoteDirectory = this.environmentSubstitute(this.remoteDirectory);
                if (!Utils.isEmpty((CharSequence)realRemoteDirectory)) {
                    ftpclient.chdir(realRemoteDirectory);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.ChangedDirectory", (String[])new String[]{realRemoteDirectory}));
                    }
                }
                if ((realLocalDirectory = this.environmentSubstitute(this.localDirectory)) == null) {
                    throw new FTPException(BaseMessages.getString(PKG, (String)"JobFTPPUT.LocalDir.NotSpecified", (String[])new String[0]));
                }
                if (realLocalDirectory.startsWith("file:")) {
                    realLocalDirectory = new URI(realLocalDirectory).getPath();
                }
                if ((children = (localFiles = new File(realLocalDirectory)).listFiles()) == null) {
                    files = Collections.emptyList();
                } else {
                    files = new ArrayList<String>(children.length);
                    for (File child : children) {
                        if (child.isDirectory()) continue;
                        files.add(child.getName());
                    }
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.FoundFileLocalDirectory", (String[])new String[]{"" + files.size(), realLocalDirectory}));
                }
                Pattern pattern = !Utils.isEmpty((CharSequence)(realWildcard = this.environmentSubstitute(this.wildcard))) ? Pattern.compile(realWildcard) : null;
                for (String file : files) {
                    if (this.parentJob.isStopped()) break;
                    boolean toBeProcessed = true;
                    if (pattern != null) {
                        Matcher matcher = pattern.matcher(file);
                        toBeProcessed = matcher.matches();
                    }
                    if (!toBeProcessed) continue;
                    boolean fileExist = false;
                    try {
                        fileExist = ftpclient.exists(file);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.log.isDebug()) {
                        if (fileExist) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.FileExists", (String[])new String[]{file}));
                        } else {
                            this.logDebug(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.FileDoesNotExists", (String[])new String[]{file}));
                        }
                    }
                    if (fileExist && this.onlyPuttingNewFiles) continue;
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.PuttingFileToRemoteDirectory", (String[])new String[]{file, realRemoteDirectory}));
                    }
                    String localFilename = realLocalDirectory + Const.FILE_SEPARATOR + file;
                    ftpclient.put(localFilename, file);
                    ++filesput;
                    if (!this.remove) continue;
                    new File(localFilename).delete();
                    if (!this.log.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.DeletedFile", (String[])new String[]{localFilename}));
                }
                result.setResult(true);
                if (!this.log.isDetailed()) break block33;
                this.logDebug(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.WeHavePut", (String[])new String[]{"" + filesput}));
            }
            catch (Exception e) {
                try {
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.ErrorPuttingFiles", (String[])new String[]{e.getMessage()}));
                    this.logError(Const.getStackTracker((Throwable)e));
                }
                catch (Throwable throwable) {
                    if (ftpclient != null && ftpclient.connected()) {
                        try {
                            ftpclient.quit();
                        }
                        catch (Exception e2) {
                            this.logError(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.ErrorQuitingFTP", (String[])new String[]{e2.getMessage()}));
                        }
                    }
                    FTPClient.clearSOCKS();
                    throw throwable;
                }
                if (ftpclient != null && ftpclient.connected()) {
                    try {
                        ftpclient.quit();
                    }
                    catch (Exception e3) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.ErrorQuitingFTP", (String[])new String[]{e3.getMessage()}));
                    }
                }
                FTPClient.clearSOCKS();
            }
        }
        if (ftpclient != null && ftpclient.connected()) {
            try {
                ftpclient.quit();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.ErrorQuitingFTP", (String[])new String[]{e.getMessage()}));
            }
        }
        FTPClient.clearSOCKS();
        return result;
    }

    FTPClient createAndSetUpFtpClient() throws IOException, FTPException {
        String realServerName = this.environmentSubstitute(this.serverName);
        String realServerPort = this.environmentSubstitute(this.serverPort);
        FTPClient ftpClient = this.createFtpClient();
        ftpClient.setRemoteAddr(InetAddress.getByName(realServerName));
        if (!Utils.isEmpty((CharSequence)realServerPort)) {
            ftpClient.setRemotePort(Const.toInt((String)realServerPort, (int)21));
        }
        if (!Utils.isEmpty((CharSequence)this.proxyHost)) {
            int port;
            String realProxyHost = this.environmentSubstitute(this.proxyHost);
            ftpClient.setRemoteAddr(InetAddress.getByName(realProxyHost));
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPPUT.OpenedProxyConnectionOn", (String[])new String[]{realProxyHost}));
            }
            if ((port = Const.toInt((String)this.environmentSubstitute(this.proxyPort), (int)21)) != 0) {
                ftpClient.setRemotePort(port);
            }
        } else if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPPUT.OpenConnection", (String[])new String[]{realServerName}));
        }
        if (this.activeConnection) {
            ftpClient.setConnectMode(FTPConnectMode.ACTIVE);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.SetActiveConnection", (String[])new String[0]));
            }
        } else {
            ftpClient.setConnectMode(FTPConnectMode.PASV);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.SetPassiveConnection", (String[])new String[0]));
            }
        }
        if (this.timeout > 0) {
            ftpClient.setTimeout(this.timeout);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.SetTimeout", (String[])new String[]{"" + this.timeout}));
            }
        }
        ftpClient.setControlEncoding(this.controlEncoding);
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobFTPPUT.Log.SetEncoding", (String[])new String[]{this.controlEncoding}));
        }
        if (!Utils.isEmpty((CharSequence)this.socksProxyHost)) {
            if (Utils.isEmpty((CharSequence)this.socksProxyPort)) {
                throw new FTPException(BaseMessages.getString(PKG, (String)"JobFTPPUT.SocksProxy.PortMissingException", (String[])new String[]{this.environmentSubstitute(this.socksProxyHost)}));
            }
            FTPClient.initSOCKS((String)this.environmentSubstitute(this.socksProxyPort), (String)this.environmentSubstitute(this.socksProxyHost));
            if (!Utils.isEmpty((CharSequence)this.socksProxyUsername) && Utils.isEmpty((CharSequence)this.socksProxyPassword) || Utils.isEmpty((CharSequence)this.socksProxyUsername) && !Utils.isEmpty((CharSequence)this.socksProxyPassword)) {
                throw new FTPException(BaseMessages.getString(PKG, (String)"JobFTPPUT.SocksProxy.IncompleteCredentials", (String[])new String[]{this.environmentSubstitute(this.socksProxyHost), this.getName()}));
            }
        }
        return ftpClient;
    }

    FTPClient createFtpClient() {
        return new PDIFTPClient(this.log);
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Utils.isEmpty((CharSequence)this.serverName)) {
            String realServerName = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServerName, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "localDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "serverPort", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }

    protected void hookInOtherParsers(FTPClient ftpClient) throws FTPException, IOException {
        VariableSpace vs;
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTP.DEBUG.Hooking.Parsers", (String[])new String[0]));
        }
        String system = ftpClient.system();
        MVSFileParser parser = new MVSFileParser(this.log);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTP.DEBUG.Created.MVS.Parser", (String[])new String[0]));
        }
        FTPFileFactory factory = new FTPFileFactory(system);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTP.DEBUG.Created.Factory", (String[])new String[0]));
        }
        factory.addParser((FTPFileParser)parser);
        ftpClient.setFTPFileFactory(factory);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTP.DEBUG.Get.Variable.Space", (String[])new String[0]));
        }
        if ((vs = this.getVariables()) != null) {
            String otherParserNames;
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTP.DEBUG.Getting.Other.Parsers", (String[])new String[0]));
            }
            if ((otherParserNames = vs.getVariable("ftp.file.parser.class.names")) != null) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTP.DEBUG.Creating.Parsers", (String[])new String[0]));
                }
                String[] parserClasses = otherParserNames.split("|");
                String cName = null;
                Class<?> clazz = null;
                Object parserInstance = null;
                for (int i = 0; i < parserClasses.length; ++i) {
                    cName = parserClasses[i].trim();
                    if (cName.length() <= 0) continue;
                    try {
                        clazz = Class.forName(cName);
                        parserInstance = clazz.newInstance();
                        if (!(parserInstance instanceof FTPFileParser)) continue;
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.DEBUG.Created.Other.Parser", (String[])new String[]{cName}));
                        }
                        factory.addParser((FTPFileParser)parserInstance);
                        continue;
                    }
                    catch (Exception ignored) {
                        if (!this.log.isDebug()) continue;
                        ignored.printStackTrace();
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTP.ERROR.Creating.Parser", (String[])new String[]{cName}));
                    }
                }
            }
        }
    }
}

