/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.checkfilelocked;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.checkfilelocked.LockFile;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryCheckFilesLocked
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static final String ARG_FROM_PREVIOUS_ATTR = "arg_from_previous";
    private static final String FILE_MASK_ATTR = "filemask";
    private static final String INCLUDE_SUBFOLDERS_ATTR = "include_subfolders";
    private static final String NAME_ATTR = "name";
    private static Class<?> PKG = JobEntryCheckFilesLocked.class;
    public boolean argFromPrevious = false;
    public boolean includeSubfolders = false;
    public String[] arguments = null;
    public String[] filemasks;
    private boolean oneFileLocked;

    public JobEntryCheckFilesLocked(String n) {
        super(n, "");
    }

    public JobEntryCheckFilesLocked() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryCheckFilesLocked je = (JobEntryCheckFilesLocked)super.clone();
        if (this.arguments != null) {
            int nrFields = this.arguments.length;
            je.allocate(nrFields);
            System.arraycopy(this.arguments, 0, je.arguments, 0, nrFields);
            System.arraycopy(this.filemasks, 0, je.filemasks, 0, nrFields);
        }
        return je;
    }

    public void allocate(int nrFields) {
        this.arguments = new String[nrFields];
        this.filemasks = new String[nrFields];
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)ARG_FROM_PREVIOUS_ATTR, (boolean)this.argFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)INCLUDE_SUBFOLDERS_ATTR, (boolean)this.includeSubfolders));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)NAME_ATTR, (String)this.arguments[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)FILE_MASK_ATTR, (String)this.filemasks[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)ARG_FROM_PREVIOUS_ATTR));
            this.includeSubfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)INCLUDE_SUBFOLDERS_ATTR));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XMLHandler.getTagValue((Node)fnode, (String)NAME_ATTR);
                this.filemasks[i] = XMLHandler.getTagValue((Node)fnode, (String)FILE_MASK_ATTR);
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.UnableToLoadFromXml", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId idJobEntry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(idJobEntry, ARG_FROM_PREVIOUS_ATTR);
            this.includeSubfolders = rep.getJobEntryAttributeBoolean(idJobEntry, INCLUDE_SUBFOLDERS_ATTR);
            int argnr = rep.countNrJobEntryAttributes(idJobEntry, NAME_ATTR);
            this.arguments = new String[argnr];
            this.filemasks = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(idJobEntry, a, NAME_ATTR);
                this.filemasks[a] = rep.getJobEntryAttributeString(idJobEntry, a, FILE_MASK_ATTR);
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.UnableToLoadFromRepo", (String[])new String[]{String.valueOf(idJobEntry)}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId idJob) throws KettleException {
        try {
            rep.saveJobEntryAttribute(idJob, this.getObjectId(), ARG_FROM_PREVIOUS_ATTR, this.argFromPrevious);
            rep.saveJobEntryAttribute(idJob, this.getObjectId(), INCLUDE_SUBFOLDERS_ATTR, this.includeSubfolders);
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(idJob, this.getObjectId(), i, NAME_ATTR, this.arguments[i]);
                    rep.saveJobEntryAttribute(idJob, this.getObjectId(), i, FILE_MASK_ATTR, this.filemasks[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.UnableToSaveToRepo", (String[])new String[]{String.valueOf(idJob)}), (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        List rows = result.getRows();
        this.oneFileLocked = false;
        result.setResult(true);
        try {
            if (this.argFromPrevious && this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.FoundPreviousRows", (String[])new String[]{String.valueOf(rows != null ? rows.size() : 0)}));
            }
            if (this.argFromPrevious && rows != null) {
                this.processFromPreviousArgument(rows);
            } else if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length && !this.parentJob.isStopped(); ++i) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.ProcessingArg", (String[])new String[]{this.arguments[i], this.filemasks[i]}));
                    }
                    this.processFile(this.arguments[i], this.filemasks[i]);
                }
            }
            if (this.oneFileLocked) {
                result.setResult(false);
                result.setNrErrors(1L);
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.ErrorRunningJobEntry", (Object[])new Object[]{e}));
        }
        return result;
    }

    private void processFromPreviousArgument(List<RowMetaAndData> rows) throws KettleValueException {
        for (int iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
            RowMetaAndData resultRow = rows.get(iteration);
            String fileFolderPrevious = resultRow.getString(0, "");
            String fileMasksPrevious = resultRow.getString(1, "");
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.ProcessingRow", (String[])new String[]{fileFolderPrevious, fileMasksPrevious}));
            }
            this.processFile(fileFolderPrevious, fileMasksPrevious);
        }
    }

    private void processFile(String filename, String wildcard) {
        String realFileFolderName = this.environmentSubstitute(filename);
        String realWildcard = this.environmentSubstitute(wildcard);
        try (FileObject fileFolder = KettleVFS.getFileObject((String)realFileFolderName);){
            FileObject[] files = new FileObject[]{fileFolder};
            if (fileFolder.exists()) {
                if (fileFolder.getType() == FileType.FOLDER) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.ProcessingFolder", (String[])new String[]{realFileFolderName}));
                    }
                    files = fileFolder.findFiles((FileSelector)new TextFileSelector(fileFolder.toString(), realWildcard));
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.TotalFilesToCheck", (String[])new String[]{String.valueOf(files.length)}));
                    }
                } else if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.ProcessingFile", (String[])new String[]{realFileFolderName}));
                }
                this.checkFilesLocked(files);
            } else {
                this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.FileNotExist", (String[])new String[]{realFileFolderName}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryCheckFilesLocked.CouldNotProcess", (String[])new String[]{realFileFolderName, e.getMessage()}));
        }
    }

    private void checkFilesLocked(FileObject[] files) throws KettleException {
        for (int i = 0; i < files.length && !this.oneFileLocked; ++i) {
            FileObject file = files[i];
            String filename = KettleVFS.getFilename((FileObject)file);
            LockFile locked = new LockFile(filename);
            if (locked.isLocked()) {
                this.oneFileLocked = true;
                this.logError(BaseMessages.getString(PKG, (String)"JobCheckFilesLocked.Log.FileLocked", (String[])new String[]{filename}));
                continue;
            }
            if (!this.isDetailed()) continue;
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobCheckFilesLocked.Log.FileNotLocked", (String[])new String[]{filename}));
        }
    }

    public void setIncludeSubfolders(boolean includeSubfolders) {
        this.includeSubfolders = includeSubfolders;
    }

    public void setargFromPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String[] getFilemasks() {
        return this.filemasks;
    }

    public boolean isIncludeSubfolders() {
        return this.includeSubfolders;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (res) {
            ValidatorContext ctx = new ValidatorContext();
            AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
            AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
            for (int i = 0; i < this.arguments.length; ++i) {
                JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
            }
        }
    }

    private class TextFileSelector
    implements FileSelector {
        String fileWildcard = null;
        String sourceFolder = null;

        public TextFileSelector(String sourcefolderin, String filewildcard) {
            if (!Utils.isEmpty((CharSequence)sourcefolderin)) {
                this.sourceFolder = sourcefolderin;
            }
            if (!Utils.isEmpty((CharSequence)filewildcard)) {
                this.fileWildcard = filewildcard;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean returncode = false;
            try {
                if (!info.getFile().toString().equals(this.sourceFolder)) {
                    String shortFilename = info.getFile().getName().getBaseName();
                    if (!info.getFile().getParent().equals(info.getBaseFolder())) {
                        if (JobEntryCheckFilesLocked.this.includeSubfolders) {
                            returncode = this.includeFileCheck(info, shortFilename);
                        }
                    } else {
                        returncode = this.includeFileCheck(info, shortFilename);
                    }
                }
            }
            catch (Exception e) {
                JobEntryCheckFilesLocked.this.logError(BaseMessages.getString((Class)PKG, (String)"JobCheckFilesLocked.Error.Exception.ProcessError", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"JobCheckFilesLocked.Error.Exception.Process", (String[])new String[]{info.getFile().toString(), e.getMessage()}));
            }
            return returncode;
        }

        private boolean includeFileCheck(FileSelectInfo info, String shortFilename) throws FileSystemException {
            if (info.getFile().getType() == FileType.FILE && this.getFileWildcard(shortFilename, this.fileWildcard)) {
                if (JobEntryCheckFilesLocked.this.isDetailed()) {
                    JobEntryCheckFilesLocked.this.logDetailed(BaseMessages.getString((Class)PKG, (String)"JobEntryCheckFilesLocked.CheckingFile", (String[])new String[]{info.getFile().toString()}));
                }
                return true;
            }
            return false;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return info.getDepth() == 0 || JobEntryCheckFilesLocked.this.includeSubfolders;
        }

        private boolean getFileWildcard(String selectedfile, String wildcard) {
            Pattern pattern = null;
            boolean getIt = true;
            if (!Utils.isEmpty((CharSequence)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
                Matcher matcher = pattern.matcher(selectedfile);
                getIt = matcher.matches();
            }
            return getIt;
        }
    }
}

